/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.SequenceGenerator;

public class EntityTypes {
    private static EntityTypes singleton;
    private Map entityTypesByID;
    private Map entityTypesByType;
    private Object updateLock = new Object();
    private static String ENTITY_TYPE_TABLE;
    private static String TYPE_ID_COLUMN;
    private static String TYPE_NAME_COLUMN;
    private static String DESCRIPTIVE_NAME_COLUMN;
    public static int NULL_TYPE_ID;
    public static Class GROUP_ENTITY_TYPE;
    public static Class LEAF_ENTITY_TYPE;
    static /* synthetic */ Class class$org$jasig$portal$groups$IEntityGroup;
    static /* synthetic */ Class class$org$jasig$portal$groups$IEntity;

    private EntityTypes() {
        this.initialize();
    }

    public static void addIfNecessary(Class newType, String description) throws Exception {
        EntityTypes.singleton().addEntityTypeIfNecessary(newType, description);
    }

    private void addEntityType(Class newType, String description) throws Exception {
        if (this.getEntityTypesByType().get(newType) == null) {
            int nextKey = this.getNextKey();
            EntityType et = new EntityType(newType, new Integer(nextKey), description);
            this.insertEntityType(et);
            this.primAddEntityType(et);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityTypeIfNecessary(Class newType, String description) throws Exception {
        Object object = this.updateLock;
        synchronized (object) {
            block7: {
                if (this.getEntityTypesByType().get(newType) == null) {
                    EntityTypes.refresh();
                    if (this.getEntityTypesByType().get(newType) == null) {
                        try {
                            this.addEntityType(newType, description);
                        }
                        catch (Exception ex) {
                            EntityTypes.refresh();
                            if (this.getEntityTypesByType().get(newType) != null) break block7;
                            String errString = "Attempt to add entity type failed: " + ex.getMessage();
                            LogService.log(LogService.ERROR, errString);
                            throw ex;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntityType(Class type) throws SQLException {
        Object object = this.updateLock;
        synchronized (object) {
            EntityTypes.refresh();
            EntityType et = (EntityType)this.getEntityTypesByType().get(type);
            if (et != null) {
                this.deleteEntityType(et);
                this.primRemoveEntityType(et);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                ps = new RDBMServices.PreparedStatement(conn, EntityTypes.getDeleteEntityTypeSql());
                ps.setInt(1, et.getTypeId());
                ps.setString(2, et.getType().getName());
                LogService.log(LogService.DEBUG, "EntityTypes.deleteEntityType(): " + ps + "(" + et.getTypeId() + ", " + et.getType() + ")");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem deleting type " + et;
                    LogService.log(LogService.ERROR, errString);
                    throw new SQLException(errString);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
                throw throwable;
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    private static String getAllColumnNames() {
        return TYPE_ID_COLUMN + ", " + TYPE_NAME_COLUMN + ", " + DESCRIPTIVE_NAME_COLUMN;
    }

    public Iterator getAllEntityTypeIDs() {
        return this.entityTypesByID.keySet().iterator();
    }

    public Iterator getAllEntityTypes() {
        ArrayList<Class> types = new ArrayList<Class>(this.getEntityTypesByType().size());
        Iterator i = this.entityTypesByID.values().iterator();
        while (i.hasNext()) {
            EntityType et = (EntityType)i.next();
            types.add(et.getType());
        }
        return types.iterator();
    }

    private static String getDeleteEntityTypeSql() {
        return "DELETE FROM " + ENTITY_TYPE_TABLE + " WHERE " + TYPE_ID_COLUMN + " = ? AND " + TYPE_NAME_COLUMN + " = ?";
    }

    public static String getDescriptiveName(Class type) {
        return EntityTypes.singleton().getDescriptiveNameForType(type);
    }

    public String getDescriptiveNameForType(Class type) {
        EntityType et = (EntityType)this.getEntityTypesByType().get(type);
        return et.getDescriptiveName();
    }

    public Integer getEntityIDFromType(Class type) {
        EntityType et = (EntityType)this.getEntityTypesByType().get(type);
        return et == null ? null : et.getTypeId();
    }

    public static Class getEntityType(Integer typeID) {
        return EntityTypes.singleton().getEntityTypeFromID(typeID);
    }

    public Class getEntityTypeFromID(Integer id) {
        EntityType et = (EntityType)this.getEntityTypesByID().get(id);
        return et == null ? null : et.getType();
    }

    public static Integer getEntityTypeID(Class type) {
        return EntityTypes.singleton().getEntityIDFromType(type);
    }

    private synchronized Map getEntityTypesByID() {
        return this.entityTypesByID;
    }

    private Map cloneHashMap(Map m) {
        return (Map)((HashMap)m).clone();
    }

    private synchronized Map getEntityTypesByType() {
        return this.entityTypesByType;
    }

    private static String getInsertEntityTypeSql() {
        return "INSERT INTO " + ENTITY_TYPE_TABLE + " (" + EntityTypes.getAllColumnNames() + ") VALUES (?, ?, ?)";
    }

    private int getNextKey() throws Exception {
        return SequenceGenerator.instance().getNextInt(ENTITY_TYPE_TABLE);
    }

    private static String getSelectEntityTypesSql() {
        return "SELECT " + EntityTypes.getAllColumnNames() + " FROM " + ENTITY_TYPE_TABLE;
    }

    private static String getUpdateEntityTypeSql() {
        return "UPDATE " + ENTITY_TYPE_TABLE + " SET " + DESCRIPTIVE_NAME_COLUMN + " = ? WHERE " + TYPE_ID_COLUMN + " = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.initializeCaches();
        Connection conn = null;
        Integer typeID = null;
        Class<?> entityType = null;
        String description = null;
        EntityType et = null;
        try {
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            try {
                ResultSet rs = stmnt.executeQuery(EntityTypes.getSelectEntityTypesSql());
                try {
                    while (rs.next()) {
                        typeID = new Integer(rs.getInt(1));
                        entityType = Class.forName(rs.getString(2));
                        description = rs.getString(3);
                        et = new EntityType(entityType, typeID, description);
                        this.primAddEntityType(et);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (Exception ex) {
            LogService.log(LogService.ERROR, ex);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private void initializeCaches() {
        this.entityTypesByID = new HashMap(10);
        this.entityTypesByType = new HashMap(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                ps = new RDBMServices.PreparedStatement(conn, EntityTypes.getInsertEntityTypeSql());
                ps.setInt(1, et.getTypeId());
                ps.setString(2, et.getType().getName());
                ps.setString(3, et.getDescriptiveName());
                LogService.log(LogService.DEBUG, "EntityTypes.insertEntityType(): " + ps + "(" + et.getTypeId() + ", " + et.getType() + ", " + et.getDescriptiveName() + ")");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem adding entity type " + et;
                    LogService.log(LogService.ERROR, errString);
                    throw new SQLException(errString);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
                throw throwable;
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    private void primAddEntityType(EntityType et) {
        Map typesByType = this.cloneHashMap(this.getEntityTypesByType());
        typesByType.put(et.getType(), et);
        Map typesByID = this.cloneHashMap(this.getEntityTypesByID());
        typesByID.put(et.getTypeId(), et);
        this.setEntityTypesByType(typesByType);
        this.setEntityTypesByID(typesByID);
    }

    private void primRemoveEntityType(EntityType et) {
        Map typesByType = this.cloneHashMap(this.getEntityTypesByType());
        typesByType.remove(et.getType());
        Map typesByID = this.cloneHashMap(this.getEntityTypesByID());
        typesByID.remove(et.getTypeId());
        this.setEntityTypesByType(typesByType);
        this.setEntityTypesByID(typesByID);
    }

    public static synchronized void refresh() {
        EntityTypes.singleton().initialize();
    }

    public synchronized void setEntityTypesByID(Map m) {
        this.entityTypesByID = m;
    }

    public synchronized void setEntityTypesByType(Map m) {
        this.entityTypesByType = m;
    }

    public static synchronized EntityTypes singleton() {
        if (singleton == null) {
            singleton = new EntityTypes();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntityType(Class type, String newDescription) throws Exception {
        Object object = this.updateLock;
        synchronized (object) {
            EntityTypes.refresh();
            EntityType et = (EntityType)this.getEntityTypesByType().get(type);
            if (et == null) {
                this.addEntityType(type, newDescription);
            } else {
                et.descriptiveName = newDescription;
                this.updateEntityType(et);
                this.primAddEntityType(et);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityType(EntityType et) throws SQLException {
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            try {
                ps = new RDBMServices.PreparedStatement(conn, EntityTypes.getUpdateEntityTypeSql());
                ps.setString(1, et.getDescriptiveName());
                ps.setInt(2, et.getTypeId());
                LogService.log(LogService.DEBUG, "EntityTypes.updateEntityType(): " + ps + "(" + et.getType() + ", " + et.getDescriptiveName() + ", " + et.getTypeId() + ")");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem updating type " + et;
                    LogService.log(LogService.ERROR, errString);
                    throw new SQLException(errString);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                finally {
                    RDBMServices.releaseConnection(conn);
                }
                throw throwable;
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ENTITY_TYPE_TABLE = "UP_ENTITY_TYPE";
        TYPE_ID_COLUMN = "ENTITY_TYPE_ID";
        TYPE_NAME_COLUMN = "ENTITY_TYPE_NAME";
        DESCRIPTIVE_NAME_COLUMN = "DESCRIPTIVE_NAME";
        NULL_TYPE_ID = -1;
        GROUP_ENTITY_TYPE = class$org$jasig$portal$groups$IEntityGroup == null ? (class$org$jasig$portal$groups$IEntityGroup = EntityTypes.class$("org.jasig.portal.groups.IEntityGroup")) : class$org$jasig$portal$groups$IEntityGroup;
        LEAF_ENTITY_TYPE = class$org$jasig$portal$groups$IEntity == null ? (class$org$jasig$portal$groups$IEntity = EntityTypes.class$("org.jasig.portal.groups.IEntity")) : class$org$jasig$portal$groups$IEntity;
    }

    private class EntityType {
        private Class type;
        private Integer typeId;
        private String descriptiveName;

        private EntityType(Class cl, Integer id, String description) {
            this.type = cl;
            this.typeId = id;
            this.descriptiveName = description;
        }

        private Class getType() {
            return this.type;
        }

        private Integer getTypeId() {
            return this.typeId;
        }

        private String getDescriptiveName() {
            return this.descriptiveName;
        }

        public String toString() {
            String desc = this.descriptiveName == null ? "" : this.descriptiveName;
            return desc + " (" + this.getTypeId() + ") " + this.getType().getName();
        }
    }
}

