/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import javax.servlet.http.HttpSession;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CLogin
implements IPrivilegedChannel,
ICacheable {
    private ChannelStaticData staticData;
    private ChannelRuntimeData runtimeData;
    private String channelName = "Log in...";
    private String attemptedUserName = "";
    private static final String sslLocation = "CLogin/CLogin.ssl";
    private boolean bAuthenticated = false;
    private boolean bauthenticationAttemptFailed = false;
    private boolean bSecurityError = false;
    private String xslUriForKey = null;
    private static final String systemCacheId = "org.jasig.portal.CLogin:";
    private ISecurityContext ic;

    public void setPortalControlStructures(PortalControlStructures pcs) {
        HttpSession session = pcs.getHttpSession();
        String authenticationAttempted = (String)session.getAttribute("up_authenticationAttempted");
        String authenticationError = (String)session.getAttribute("up_authenticationError");
        this.attemptedUserName = (String)session.getAttribute("up_attemptedUserName");
        if (authenticationAttempted != null) {
            this.bauthenticationAttemptFailed = true;
        }
        if (authenticationError != null) {
            this.bSecurityError = true;
        }
    }

    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev) {
    }

    public void setStaticData(ChannelStaticData sd) {
        this.staticData = sd;
        this.ic = this.staticData.getPerson().getSecurityContext();
        if (this.ic != null && this.ic.isAuthenticated()) {
            this.bAuthenticated = true;
        }
    }

    public void setRuntimeData(ChannelRuntimeData rd) {
        this.runtimeData = rd;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        String fullName = this.staticData.getPerson().getFullName();
        Document doc = DocumentFactory.getNewDocument();
        Element loginStatusElement = doc.createElement("login-status");
        if (this.bSecurityError) {
            Element errorElement = doc.createElement("error");
            loginStatusElement.appendChild(errorElement);
        } else if (this.bauthenticationAttemptFailed && !this.bAuthenticated) {
            Element failureElement = doc.createElement("failure");
            failureElement.setAttribute("attemptedUserName", this.attemptedUserName);
            loginStatusElement.appendChild(failureElement);
        } else if (fullName != null) {
            Element fullNameElement = doc.createElement("full-name");
            fullNameElement.appendChild(doc.createTextNode(fullName));
            loginStatusElement.appendChild(fullNameElement);
        }
        doc.appendChild(loginStatusElement);
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        if (!this.staticData.getPerson().getSecurityContext().isAuthenticated()) {
            xslt.setStylesheetParameter("unauthenticated", "true");
        }
        xslt.transform();
    }

    public ChannelCacheKey generateKey() {
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        if (this.staticData.getPerson().isGuest()) {
            k.setKeyScope(1);
            sbKey.append(systemCacheId);
        } else {
            k.setKeyScope(0);
        }
        sbKey.append("userId:").append(this.staticData.getPerson().getID()).append(", ");
        sbKey.append("authenticated:").append(this.staticData.getPerson().getSecurityContext().isAuthenticated()).append(", ");
        if (this.xslUriForKey == null) {
            try {
                String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
                this.xslUriForKey = XSLT.getStylesheetURI(sslUri, this.runtimeData.getBrowserInfo());
            }
            catch (PortalException pe) {
                this.xslUriForKey = "Not attainable!";
            }
        }
        sbKey.append("xslUri:").append(this.xslUriForKey).append(", ");
        sbKey.append("bAuthenticated:").append(this.bAuthenticated).append(", ");
        sbKey.append("bauthenticationAttemptFailed:").append(this.bauthenticationAttemptFailed).append(", ");
        sbKey.append("attemptedUserName:").append(this.attemptedUserName).append(", ");
        sbKey.append("bSecurityError:").append(this.bSecurityError);
        sbKey.append("locales:").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        k.setKey(sbKey.toString());
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    public boolean isCacheValid(Object validity) {
        return true;
    }
}

