/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.permissionsmanager;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IPermissible;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.permissionsmanager.RDBMPermissibleRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.services.LogService;

public class CPermissionsManagerServantFactory {
    private static CPermissionsManagerServantFactory _instance;
    private HashMap servantClasses = new HashMap();

    protected CPermissionsManagerServantFactory() {
    }

    static IServant getPermissionsServant() {
        return CPermissionsManagerServantFactory.getPermissionsServant("CPermissionsManagerServant");
    }

    protected static IServant getPermissionsServant(String name) {
        return CPermissionsManagerServantFactory.instance().getServant(name);
    }

    public static IServant getPermissionsServant(IPermissible owner, ChannelStaticData staticData, IAuthorizationPrincipal[] principals, String[] activities, String[] targets) throws PortalException {
        boolean isOK = true;
        long time1 = Calendar.getInstance().getTime().getTime();
        RDBMPermissibleRegistry.registerPermissible(owner.getClass().getName());
        IServant servant = CPermissionsManagerServantFactory.getPermissionsServant();
        IPermissible[] owners = new IPermissible[]{owner};
        if (activities == null) {
            activities = owner.getActivityTokens();
        }
        if (targets == null) {
            targets = owner.getTargetTokens();
        }
        if (staticData != null) {
            try {
                ChannelStaticData slaveSD = (ChannelStaticData)staticData.clone();
                Enumeration srd = slaveSD.keys();
                while (srd.hasMoreElements()) {
                    slaveSD.remove(srd.nextElement());
                }
                HashMap<String, String[]> tHash = new HashMap<String, String[]>(1);
                tHash.put(owner.getOwnerToken(), targets);
                HashMap<String, String[]> aHash = new HashMap<String, String[]>(1);
                aHash.put(owner.getOwnerToken(), activities);
                if (principals != null) {
                    slaveSD.put("prmPrincipals", principals);
                }
                slaveSD.put("prmOwners", owners);
                slaveSD.put("prmActivities", aHash);
                slaveSD.put("prmTargets", tHash);
                slaveSD.put("prmView", "Assign By Owner");
                servant.setStaticData(slaveSD);
            }
            catch (Exception e) {
                isOK = false;
            }
        } else {
            isOK = false;
        }
        if (!isOK) {
            throw new PortalException("CPermissionsServantFactory.getPermissionsServant():: unable to properly initialize servant, check that mast staticData is being properly passed to this method");
        }
        long time2 = Calendar.getInstance().getTime().getTime();
        LogService.log(LogService.INFO, "CPermissionsManagerFactory took  " + String.valueOf(time2 - time1) + " ms to instantiate");
        return servant;
    }

    protected IServant getServant(String name) {
        IServant rs = null;
        if (this.servantClasses.get(name) == null) {
            try {
                Class<?> cserv = Class.forName("org.jasig.portal.channels.permissionsmanager." + name);
                this.servantClasses.put(name, cserv);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
        if (this.servantClasses.get(name) != null) {
            try {
                rs = (IServant)((Class)this.servantClasses.get(name)).newInstance();
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
        return rs;
    }

    protected static synchronized CPermissionsManagerServantFactory instance() {
        if (_instance == null) {
            _instance = new CPermissionsManagerServantFactory();
        }
        return _instance;
    }
}

