/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.AccountStoreFactory;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.security.provider.NotSoOpaqueCredentials;
import org.jasig.portal.services.LogService;

class CacheSecurityContext
extends ChainingSecurityContext
implements ISecurityContext {
    private final int CACHESECURITYAUTHTYPE = 65283;
    private byte[] cachedcredentials;

    CacheSecurityContext() {
    }

    public int getAuthType() {
        return this.CACHESECURITYAUTHTYPE;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        this.isauth = false;
        if (this.myPrincipal.UID != null && this.myOpaqueCredentials.credentialstring != null) {
            String first_name = null;
            String last_name = null;
            try {
                String[] acct = AccountStoreFactory.getAccountStoreImpl().getUserAccountInformation(this.myPrincipal.UID);
                if (acct[0] != null) {
                    first_name = acct[1];
                    last_name = acct[2];
                    this.myPrincipal.FullName = first_name + " " + last_name;
                    LogService.log(LogService.INFO, "User " + this.myPrincipal.UID + " is authenticated");
                    this.cachedcredentials = new byte[this.myOpaqueCredentials.credentialstring.length];
                    System.arraycopy(this.myOpaqueCredentials.credentialstring, 0, this.cachedcredentials, 0, this.myOpaqueCredentials.credentialstring.length);
                    this.isauth = true;
                }
                LogService.log(LogService.INFO, "No such user: " + this.myPrincipal.UID);
            }
            catch (Exception e) {
                PortalSecurityException ep = new PortalSecurityException("SQL Database Error");
                LogService.log(LogService.ERROR, ep);
                throw ep;
            }
        } else {
            LogService.log(LogService.ERROR, "Principal or OpaqueCredentials not initialized prior to authenticate");
        }
        super.authenticate();
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.isauth) {
            CacheOpaqueCredentials oc = new CacheOpaqueCredentials();
            oc.setCredentials(this.cachedcredentials);
            return oc;
        }
        return null;
    }

    private class CacheOpaqueCredentials
    extends ChainingSecurityContext.ChainingOpaqueCredentials
    implements NotSoOpaqueCredentials {
        private CacheOpaqueCredentials() {
            super(CacheSecurityContext.this);
        }

        public String getCredentials() {
            if (this.credentialstring != null) {
                return new String(this.credentialstring);
            }
            return null;
        }
    }
}

