/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jasig.portal.serialize.CachingOutputStream;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.serialize.CachingWriter;
import org.jasig.portal.serialize.CharacterCachingWriter;
import org.jasig.portal.serialize.HTMLSerializer;
import org.jasig.portal.serialize.OutputFormat;

public final class CachingXHTMLSerializer
extends HTMLSerializer
implements CachingSerializer {
    CharacterCachingWriter cacher;
    String encoding;

    public CachingXHTMLSerializer() {
        super(true, new OutputFormat("xhtml", null, false));
    }

    public CachingXHTMLSerializer(OutputFormat format) {
        super(true, format != null ? format : new OutputFormat("xhtml", null, false));
        this.encoding = format.getEncoding();
    }

    public CachingXHTMLSerializer(Writer writer, OutputFormat format) {
        super(true, format != null ? format : new OutputFormat("xhtml", null, false));
        CachingWriter cw = new CachingWriter(writer);
        this.cacher = cw;
        this.setOutputCharStream(cw);
        this.encoding = format.getEncoding();
    }

    public void setOutputCharStream(Writer writer) {
        CachingWriter cw = new CachingWriter(writer);
        this.cacher = cw;
        super.setOutputCharStream(cw);
    }

    public CachingXHTMLSerializer(OutputStream output, OutputFormat format) {
        super(true, format != null ? format : new OutputFormat("xhtml", null, false));
        CachingOutputStream cos = new CachingOutputStream(output);
        this.cacher = cos;
        this.setOutputByteStream(cos);
        this.encoding = format.getEncoding();
    }

    public void setOutputByteStream(OutputStream output) {
        CachingOutputStream cos = new CachingOutputStream(output);
        this.cacher = cos;
        super.setOutputByteStream(cos);
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xhtml", null, false));
        this.encoding = format.getEncoding();
    }

    public boolean startCaching() throws IOException {
        this._printer.flush();
        return this.cacher.startCaching();
    }

    public boolean stopCaching() throws IOException {
        this._printer.flush();
        return this.cacher.stopCaching();
    }

    public String getCache() throws UnsupportedEncodingException, IOException {
        this._printer.flush();
        return this.cacher.getCache(this.encoding);
    }

    public void printRawCharacters(String text) throws IOException {
        this._printer.printText(text);
    }

    public void setDocumentStarted(boolean setting) {
        this._started = setting;
    }

    public void flush() throws IOException {
        this._printer.flush();
        this.cacher.flush();
    }
}

