/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ExternalServices {
    private ServiceHandler svcHandler;
    private Context servicesContext;
    static /* synthetic */ Class class$org$jasig$portal$services$ExternalServices;

    public ExternalServices(Context servicesContext) {
        this.servicesContext = servicesContext;
        this.svcHandler = new ServiceHandler();
    }

    public static void startServices(Context servicesContext) throws PortalException {
        InputStream svcDescriptor = null;
        try {
            svcDescriptor = ResourceLoader.getResourceAsStream(class$org$jasig$portal$services$ExternalServices == null ? (class$org$jasig$portal$services$ExternalServices = ExternalServices.class$("org.jasig.portal.services.ExternalServices")) : class$org$jasig$portal$services$ExternalServices, "/properties/services.xml");
        }
        catch (Exception ex) {
            throw new PortalException("Failed to load services.xml. External portal services will not be started", ex);
        }
        CarResources cRes = CarResources.getInstance();
        if (svcDescriptor != null || cRes.hasDescriptors()) {
            ExternalServices svcMgr = new ExternalServices(servicesContext);
            if (cRes.hasDescriptors()) {
                try {
                    cRes.getServices(svcMgr.svcHandler);
                }
                catch (Exception ex) {
                    throw new PortalException("Failed to start external portal services in CAR descriptors.", ex);
                }
            }
            if (svcDescriptor != null) {
                try {
                    SAXParser parser = svcMgr.createParser();
                    parser.parse(svcDescriptor, (DefaultHandler)svcMgr.svcHandler);
                }
                catch (Exception ex) {
                    throw new PortalException("Failed to start external portal services defined in services.xml.", ex);
                }
            }
        }
    }

    protected SAXParser createParser() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        return factory.newSAXParser();
    }

    protected void outputMessage(String msg) {
        System.out.println("External services: " + msg);
        LogService.log(LogService.INFO, "External services: " + msg);
    }

    public static Class getClassObject(String className) throws Exception {
        if (className.indexOf("TYPE") != -1 || className.indexOf("class") != -1) {
            if (className.equals("boolean.class") || className.equals("Boolean.TYPE")) {
                return Boolean.TYPE;
            }
            if (className.equals("byte.class") || className.equals("Byte.TYPE")) {
                return Byte.TYPE;
            }
            if (className.equals("short.class") || className.equals("Short.TYPE")) {
                return Short.TYPE;
            }
            if (className.equals("char.class") || className.equals("Char.TYPE")) {
                return Character.TYPE;
            }
            if (className.equals("int.class") || className.equals("Integer.TYPE")) {
                return Integer.TYPE;
            }
            if (className.equals("long.class") || className.equals("Long.TYPE")) {
                return Long.TYPE;
            }
            if (className.equals("float.class") || className.equals("Float.TYPE")) {
                return Float.TYPE;
            }
            if (className.equals("double.class") || className.equals("Double.TYPE")) {
                return Double.TYPE;
            }
        } else {
            return CarResources.getInstance().getClassLoader().loadClass(className);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServiceHandler
    extends DefaultHandler {
        ServiceItem svcItem;
        String elementName;
        Argument argItem;
        boolean argProcessing = false;
        boolean jndiNameporcessing = false;

        ServiceHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementName = qName;
            if (qName.equals("service")) {
                this.svcItem = new ServiceItem();
            } else if (qName.equals("method")) {
                this.svcItem.setMethodType(atts.getValue("type"));
            } else if (qName.equals("arguments")) {
                this.argProcessing = true;
            } else if (qName.equals("argitem")) {
                this.argItem = new Argument();
            } else if (qName.equals("datatype")) {
                String array = atts.getValue("array");
                this.argItem.setArray(array != null && array.equals("true"));
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            this.elementName = null;
            if (qName.equals("service")) {
                String name = this.svcItem.getName();
                String javaClass = this.svcItem.getJavaClass();
                Class[] classNames = null;
                Object[] args = null;
                Class<?> svcClass = null;
                try {
                    svcClass = CarResources.getInstance().getClassLoader().loadClass(javaClass);
                    args = this.svcItem.getArguments();
                    classNames = this.svcItem.getArgumentClasses();
                }
                catch (ClassNotFoundException cnfe) {
                    ExternalServices.this.outputMessage("Class not found - " + cnfe.getMessage());
                    return;
                }
                catch (Exception e) {
                    ExternalServices.this.outputMessage("The service \"" + this.svcItem.getName() + "\" FAILED TO START.");
                    return;
                }
                try {
                    Object obj = null;
                    Object returnObject = null;
                    if (this.svcItem.getStartMethod() != null) {
                        Method startMethod = svcClass.getMethod(this.svcItem.getStartMethod(), classNames);
                        if (Modifier.isStatic(startMethod.getModifiers())) {
                            returnObject = startMethod.invoke(null, args);
                        } else {
                            obj = svcClass.newInstance();
                            returnObject = startMethod.invoke(obj, args);
                        }
                        ExternalServices.this.outputMessage("initialized \"" + this.svcItem.getName() + "\"");
                    }
                    if (this.svcItem.getJndiName() != null) {
                        if (returnObject != null) {
                            ExternalServices.this.servicesContext.bind(this.svcItem.getJndiName(), returnObject);
                            ExternalServices.this.outputMessage("bound intialization result for service \"" + this.svcItem.getName() + "\"");
                        } else {
                            if (obj == null) {
                                obj = svcClass.newInstance();
                            }
                            ExternalServices.this.servicesContext.bind(this.svcItem.getJndiName(), obj);
                            ExternalServices.this.outputMessage("bound class instance for service \"" + this.svcItem.getName() + "\"");
                        }
                    }
                    return;
                }
                catch (NoSuchMethodException nsme) {
                    ExternalServices.this.outputMessage("Method not found - " + nsme.getMessage());
                }
                catch (Exception ex) {
                    ExternalServices.this.outputMessage("General Exception - " + ex.getMessage());
                    ex.printStackTrace();
                }
                ExternalServices.this.outputMessage("The service \"" + this.svcItem.getName() + "\" FAILED TO START.");
            } else if (qName.equals("arguments")) {
                this.argProcessing = false;
            } else if (qName.equals("argitem")) {
                this.svcItem.addArgument(this.argItem);
                this.argItem = null;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.elementName == null) {
                return;
            }
            String chValue = new String(ch, start, length);
            if (this.elementName.equals("name")) {
                this.svcItem.setName(chValue);
            } else if (this.elementName.equals("class")) {
                this.svcItem.setJavaClass(chValue);
            } else if (this.elementName.equals("jndi_name")) {
                this.svcItem.setJndiName(chValue);
            } else if (this.elementName.equals("method")) {
                this.svcItem.setStartMethod(chValue);
            } else if (this.elementName.equals("datatype") && this.argProcessing) {
                this.argItem.setDataType(chValue);
            } else if (this.elementName.equals("value") && this.argProcessing) {
                this.argItem.addValue(chValue);
            }
        }
    }

    class Argument {
        String datatype;
        boolean array;
        ArrayList values = new ArrayList();

        Argument() {
        }

        public void addValue(String argValue) {
            this.values.add(argValue);
        }

        public String getDataType() {
            return this.datatype;
        }

        public void setDataType(String argDataType) {
            this.datatype = argDataType;
        }

        public boolean getArray() {
            return this.array;
        }

        public void setArray(boolean b) {
            this.array = b;
        }

        public Object getValue() throws Exception {
            Object value = null;
            if (this.array) {
                value = Array.newInstance(ExternalServices.getClassObject(this.datatype), this.values.size());
                for (int i = 0; i < this.values.size(); ++i) {
                    Array.set(value, i, this.values.get(i));
                }
            } else {
                value = this.getValue(this.datatype, (String)this.values.get(0));
            }
            return value;
        }

        private Object getValue(String className, String value) throws Exception {
            if (className.indexOf("TYPE") != -1 || className.indexOf("class") != -1) {
                try {
                    if (className.equals("boolean.class") || className.equals("BOOLEAN.TYPE")) {
                        return new Boolean(value);
                    }
                    if (className.equals("byte.class") || className.equals("Byte.TYPE")) {
                        return new Byte(value);
                    }
                    if (className.equals("short.class") || className.equals("Short.TYPE")) {
                        return new Short(value);
                    }
                    if (className.equals("char.class") || className.equals("Char.TYPE")) {
                        return new Character(value.charAt(0));
                    }
                    if (className.equals("int.class") || className.equals("Integer.TYPE")) {
                        return new Integer(value);
                    }
                    if (className.equals("long.class") || className.equals("Long.TYPE")) {
                        return new Long(value);
                    }
                    if (className.equals("float.class") || className.equals("Float.TYPE")) {
                        return new Float(value);
                    }
                    if (className.equals("double.class") || className.equals("Double.TYPE")) {
                        return new Double(value);
                    }
                }
                catch (NumberFormatException nfe) {
                    ExternalServices.this.outputMessage("Cannot convert " + value + " to declared datatype class " + className);
                }
            } else {
                return value;
            }
            return null;
        }
    }

    class ServiceItem {
        String name;
        String javaClass;
        String jndiName;
        String startMethod;
        String methodType;
        List argList;

        ServiceItem() {
        }

        public void setName(String svcName) {
            this.name = svcName;
        }

        public String getName() {
            return this.name;
        }

        public void setJavaClass(String svcClass) {
            this.javaClass = svcClass;
        }

        public String getJavaClass() {
            return this.javaClass;
        }

        public void setStartMethod(String methodName) {
            this.startMethod = methodName;
        }

        public String getStartMethod() {
            return this.startMethod;
        }

        public void setJndiName(String name) {
            this.jndiName = name;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setMethodType(String type) {
            this.methodType = type;
        }

        public boolean isStatic() {
            return this.methodType != null;
        }

        public void addArgument(Argument argItem) {
            if (this.argList == null) {
                this.argList = new ArrayList();
            }
            this.argList.add(argItem);
        }

        public Object[] getArguments() throws Exception {
            Object[] args;
            if (this.argList != null) {
                args = new Object[this.argList.size()];
                for (int i = 0; i < this.argList.size(); ++i) {
                    Argument argItem = (Argument)this.argList.get(i);
                    args[i] = argItem.getValue();
                }
            } else {
                args = new Object[]{};
            }
            return args;
        }

        public Class[] getArgumentClasses() throws Exception {
            Class[] classNames = null;
            if (this.argList != null) {
                classNames = new Class[this.argList.size()];
                for (int i = 0; i < this.argList.size(); ++i) {
                    Argument argItem = (Argument)this.argList.get(i);
                    String className = argItem.getDataType();
                    classNames[i] = argItem.getArray() ? Array.newInstance(ExternalServices.getClassObject(className), 1).getClass() : ExternalServices.getClassObject(className);
                }
            }
            return classNames;
        }
    }
}

