/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XML {
    public static String getElementText(Element e) {
        String val = null;
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            val = n.getNodeValue();
            break;
        }
        return val;
    }

    public static String serializeNode(Node node) {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        format.setIndenting(true);
        return XML.serializeNode(node, format);
    }

    public static String serializeNode(Node node, OutputFormat format) {
        String returnString = null;
        StringWriter outString = new StringWriter();
        XMLSerializer xsl = new XMLSerializer(outString, format);
        try {
            if (node.getNodeType() == 9) {
                xsl.serialize((Document)node);
                returnString = outString.toString();
            } else if (node.getNodeType() == 1) {
                xsl.serialize((Element)node);
                returnString = outString.toString();
            } else {
                returnString = "The node you passed to getNodeAsString() must be of type org.w3c.dom.Document or org.w3c.dom.Element in order to be serialized.";
            }
        }
        catch (IOException ioe) {
            returnString = "Error occurred while trying to serialize node: " + ioe.getMessage();
        }
        return returnString;
    }

    public static Document cloneDocument(Document olddoc) {
        return (Document)olddoc.cloneNode(true);
    }

    public static void dom2sax(Node dom, ContentHandler sax) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer emptytr = tFactory.newTransformer();
        emptytr.transform(new DOMSource(dom), new SAXResult(sax));
    }
}

