/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.webdav.lib.WebdavException;
import org.apache.webdav.lib.WebdavResource;

public class WebdavFile
extends File {
    public static final char davSeparatorChar = '/';
    public static final String davSeparator = String.valueOf('/');
    private HttpURL httpUrl = null;
    private String relPath = null;

    public WebdavFile(WebdavFile parent, String child) throws URIException {
        this(String.valueOf(parent.getAbsolutePath()) + davSeparator + child, parent.getUser(), parent.getPass());
    }

    public WebdavFile(String pathname, String user, String pass) throws URIException {
        this(new HttpURL(user, pass, null, -1, pathname));
    }

    public WebdavFile(URL url, String user, String pass) throws URIException {
        this((HttpURL)(url.getProtocol().equals("https") ? new HttpsURL(user, pass, url.getHost(), url.getPort(), url.getPath()) : new HttpURL(user, pass, url.getHost(), url.getPort(), url.getPath())));
    }

    public WebdavFile(String parent, String child, String user, String pass) throws URIException {
        this(String.valueOf(parent) + davSeparator + child, user, pass);
    }

    public WebdavFile(HttpURL httpUrl) throws URIException {
        super(httpUrl.getURI());
        this.httpUrl = httpUrl;
    }

    public WebdavFile(String aPath) {
        super(aPath);
        this.relPath = aPath;
    }

    private WebdavResource createRes() {
        try {
            if (this.httpUrl == null) {
                throw new WebdavException("this method is not supported with relative paths");
            }
            return new WebdavResource(this.httpUrl);
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    private void closeRes(WebdavResource res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    private File[] toFileArray(List fileList) {
        File[] files = new File[fileList.size()];
        Iterator it = fileList.iterator();
        int i = 0;
        while (i < files.length) {
            files[i] = (WebdavFile)it.next();
            ++i;
        }
        return files;
    }

    public String getUser() throws URIException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getUser();
    }

    public String getPass() throws URIException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getPassword();
    }

    public String getName() {
        if (this.relPath != null) {
            return this.relPath;
        }
        String escapedPath = this.httpUrl.getEscapedPath();
        String escapedName = URIUtil.getName((String)(escapedPath.endsWith("/") ? escapedPath.substring(0, escapedPath.length() - 1) : escapedPath));
        try {
            return URIUtil.decode((String)escapedName);
        }
        catch (URIException e) {
            return escapedName;
        }
    }

    public String getParent() {
        if (this.relPath != null) {
            return null;
        }
        String escapedPath = this.httpUrl.getEscapedPath();
        String parent = escapedPath.substring(0, escapedPath.lastIndexOf(47, escapedPath.length() - 2) + 1);
        if (parent.length() <= 1) {
            return null;
        }
        try {
            return URIUtil.decode((String)parent);
        }
        catch (URIException e) {
            return parent;
        }
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            return new WebdavFile(parent, this.getUser(), this.getPass());
        }
        catch (URIException e) {
            throw new WebdavException((Exception)((Object)e));
        }
    }

    public String getPath() {
        if (this.relPath != null) {
            return this.relPath;
        }
        try {
            return this.httpUrl.getURI();
        }
        catch (URIException e) {
            throw new WebdavException((Exception)((Object)e));
        }
    }

    public boolean isAbsolute() {
        return this.relPath == null;
    }

    public String getAbsolutePath() {
        return this.getPath();
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public File getCanonicalFile() {
        return this;
    }

    public URL toURL() throws MalformedURLException {
        if (this.relPath != null) {
            return null;
        }
        try {
            return new URL(this.httpUrl.getURI());
        }
        catch (URIException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public boolean canRead() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canWrite() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = !res.isLocked();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.exists();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDirectory() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.isCollection();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHidden() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.getIsHidden();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long lastModified() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                long l = res.getGetLastModified();
                Object var3_3 = null;
                this.closeRes(res);
                return l;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                long l = res.getGetContentLength();
                Object var3_3 = null;
                this.closeRes(res);
                return l;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createNewFile() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.putMethod("");
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.deleteMethod();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    public void deleteOnExit() {
        throw new WebdavException("this method is not implemented");
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(FilenameFilter filter) {
        File[] files = this.listFiles(filter);
        String[] names = new String[files.length];
        int i = 0;
        while (i < names.length) {
            names[i] = files[i].getAbsolutePath();
            ++i;
        }
        return names;
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] listFiles(FilenameFilter filter) {
        File[] fileArray;
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                WebdavResource[] allFiles = res.listWebdavResources();
                if (allFiles == null) {
                    File[] fileArray2 = null;
                    Object var6_7 = null;
                    this.closeRes(res);
                    return fileArray2;
                }
                ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
                int i = 0;
                while (true) {
                    if (i >= allFiles.length) {
                        fileArray = this.toFileArray(filtered);
                        break;
                    }
                    if (filter == null || filter.accept(this, allFiles[i].getDisplayName())) {
                        filtered.add(new WebdavFile(allFiles[i].getHttpURL()));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.closeRes(res);
            throw throwable;
        }
        Object var6_8 = null;
        this.closeRes(res);
        return fileArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] listFiles(FileFilter filter) {
        File[] fileArray;
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                WebdavResource[] allFiles = res.listWebdavResources();
                if (allFiles == null) {
                    File[] fileArray2 = null;
                    Object var7_7 = null;
                    this.closeRes(res);
                    return fileArray2;
                }
                ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
                int i = 0;
                while (true) {
                    if (i >= allFiles.length) {
                        fileArray = this.toFileArray(filtered);
                        break;
                    }
                    WebdavFile file = new WebdavFile(allFiles[i].getHttpURL());
                    if (filter == null || filter.accept(file)) {
                        filtered.add(file);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeRes(res);
            throw throwable;
        }
        Object var7_8 = null;
        this.closeRes(res);
        return fileArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mkdir() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.mkcolMethod();
                Object var3_3 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    public boolean mkdirs() {
        return this.mkdir();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean renameTo(File dest) {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                boolean bl = res.moveMethod(dest.getAbsolutePath());
                Object var4_4 = null;
                this.closeRes(res);
                return bl;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    public boolean setLastModified(long time) {
        throw new WebdavException("this method is not implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReadOnly() {
        WebdavResource res = null;
        try {
            try {
                res = this.createRes();
                res.setOverwrite(false);
                Object var3_2 = null;
                this.closeRes(res);
                return true;
            }
            catch (Exception e) {
                throw new WebdavException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeRes(res);
            throw throwable;
        }
    }

    public static File[] listRoots() {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix) {
        return WebdavFile.createTempFile(prefix, suffix, null);
    }

    public String toString() {
        if (this.relPath != null) {
            return this.relPath;
        }
        return this.httpUrl.getEscapedURI();
    }

    public int compareTo(File pathname) {
        if (pathname instanceof WebdavFile) {
            WebdavFile df = (WebdavFile)pathname;
            return df.getPath().compareTo(this.getPath());
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((File)o);
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof WebdavFile) {
            WebdavFile xf = (WebdavFile)x;
            return xf.getPath().equals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

