/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class UpdateMethod
extends XMLResponseMethodBase {
    private String target = null;

    public UpdateMethod() {
    }

    public UpdateMethod(String path) {
        super(path);
    }

    public UpdateMethod(String path, String target) {
        super(path);
        this.target = target;
    }

    public String getName() {
        return "UPDATE";
    }

    protected String generateRequestBody() {
        if (this.target != null) {
            XMLPrinter printer = new XMLPrinter();
            printer.writeXMLHeader();
            printer.writeElement("D", "DAV:", "update", 0);
            printer.writeElement("D", "version", 0);
            printer.writeElement("D", "href", 0);
            printer.writeText(this.target);
            printer.writeElement("D", "href", 1);
            printer.writeElement("D", "version", 1);
            printer.writeElement("D", "update", 1);
            return printer.toString();
        }
        return "";
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 207 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

