/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import org.apache.util.DOMUtils;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CurrentUserPrivilegeSetProperty
extends BaseProperty {
    public static final String TAG_NAME = "current-user-privilege-set";

    public CurrentUserPrivilegeSetProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public boolean hasReadAccess() {
        NodeList readPrivilege = DOMUtils.getElementsByTagNameNS(this.getElement(), "read", "DAV:");
        return readPrivilege.getLength() == 1;
    }

    public boolean hasWriteAccess() {
        NodeList writePrivilege = DOMUtils.getElementsByTagNameNS(this.getElement(), "write", "DAV:");
        return writePrivilege.getLength() == 1;
    }

    public boolean hasReadWriteAccess() {
        return this.hasReadAccess() && this.hasWriteAccess();
    }

    public String getPropertyAsString() {
        String theResult = "";
        theResult = this.hasReadAccess() ? "Read" : theResult;
        theResult = this.hasWriteAccess() ? String.valueOf(theResult) + " Write" : theResult;
        return theResult.trim();
    }
}

