/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.ArrayList;
import org.apache.util.DOMUtils;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LockDiscoveryProperty
extends BaseProperty {
    public static final String TAG_NAME = "lockdiscovery";

    public LockDiscoveryProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Lock[] getActiveLocks() {
        NodeList children = this.element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ArrayList<Lock> locks = new ArrayList<Lock>();
        int i = 0;
        while (i < children.getLength()) {
            try {
                String localName;
                Element child = (Element)children.item(i);
                String namespace = DOMUtils.getElementNamespaceURI(child);
                if (namespace != null && namespace.equals("DAV:") && "activelock".equals(localName = DOMUtils.getElementLocalName(child))) {
                    locks.add(this.parseLock(child));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return locks.toArray(new Lock[locks.size()]);
    }

    protected Lock parseLock(Element element) {
        Element href;
        String timeout;
        int at;
        String depth;
        Element lockType;
        int ls = -1;
        Element child = DOMUtils.getFirstElement(element, "DAV:", "lockscope");
        if (child != null) {
            Element lockScope = DOMUtils.getFirstElement(child, "DAV:", "exclusive");
            if (lockScope != null) {
                ls = 0;
            }
            if ((lockScope = DOMUtils.getFirstElement(child, "DAV:", "shared")) != null) {
                ls = 1;
            }
        }
        int lt = -1;
        child = DOMUtils.getFirstElement(element, "DAV:", "locktype");
        if (child != null && (lockType = DOMUtils.getFirstElement(child, "DAV:", "write")) != null) {
            lt = 0;
        }
        int d = -1;
        child = DOMUtils.getFirstElement(element, "DAV:", "depth");
        if (child != null && (depth = DOMUtils.getTextValue(child)) != null) {
            if ("0".equals(depth)) {
                d = 0;
            } else if ("1".equals(depth)) {
                d = 1;
            } else if ("infinity".equalsIgnoreCase(depth)) {
                d = Integer.MAX_VALUE;
            } else {
                try {
                    d = Integer.parseInt(depth);
                    if (d < 0) {
                        d = -1;
                    }
                }
                catch (NumberFormatException ex) {
                    d = -1;
                }
            }
        }
        String owner = null;
        child = DOMUtils.getFirstElement(element, "DAV:", "owner");
        owner = DOMUtils.getTextValue(child);
        int t = -1;
        child = DOMUtils.getFirstElement(element, "DAV:", "timeout");
        if (child != null && (at = (timeout = DOMUtils.getTextValue(child)).indexOf(45)) > 0) {
            try {
                t = Integer.parseInt(timeout.substring(at + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String lockToken = null;
        child = DOMUtils.getFirstElement(element, "DAV:", "locktoken");
        if (child != null && (href = DOMUtils.getFirstElement(child, "DAV:", "href")) != null) {
            lockToken = DOMUtils.getTextValue(href);
        }
        return new Lock(ls, lt, d, owner, t, lockToken);
    }

    public String getPropertyAsString() {
        Lock[] locks = this.getActiveLocks();
        if (locks == null || locks.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(locks[0].toString());
        int i = 1;
        while (i < locks.length) {
            tmp.append(", ");
            tmp.append(locks[i].toString());
            ++i;
        }
        return tmp.toString();
    }
}

