@echo off
setlocal

rem Set defaults
rem NOTE: (1) TP_HOME=.. works if tprocessor.cmd is started from the bin directory.
rem           Otherwise, set TP_HOME to point to the TProcessor installation directory, or use 
rem           the -home argument
rem 
if "%TP_HOME%" == "" set TP_HOME=..
set PAR=

rem Process parms
:LOOP
if "%1" == "" goto INVOKE_ER
if "%1" == "-?" goto HELP
if "%1" == "-h" goto HELP
if "%1" == "-help" goto HELP
if "%1" == "-home" goto SET_HOME
if "%1" == "-infile" goto SET_INFILE
if "%1" == "-outfile" goto SET_OUTFILE
goto SET_PAR

:SET_PAR
set PAR=%PAR% %1
shift 
goto LOOP

:SET_HOME
shift
set TP_HOME=%1
shift
goto LOOP

:SET_INFILE
shift
set ER_INFILE=-infile %1
shift
goto LOOP

:SET_OUTFILE
shift
set ER_OUTFILE=-outfile %1
shift
goto LOOP

rem Invoke the report
:INVOKE_ER
set OPTS=
set OPTS=%OPTS% -Dxdav.home="%TP_HOME%"
set OPTS=%OPTS% -Xms100M -Xmx200M

if "%ER_INFILE%" == "" set ER_INFILE=-infile %TP_HOME%\testsuite\junit\testcasesresults.xml
if "%ER_OUTFILE%" == "" set ER_OUTFILE=-outfile %TP_HOME%\testsuite\junit\testErrorsReport.txt

set CLASSPATH=
call cpbuild %TP_HOME%\lib

set CLS=org.apache.slide.testsuite.testtools.tprocessor.TErrorsReport %ER_INFILE% %ER_OUTFILE%
goto EXEC

:EXEC
@echo on
"%JAVA_HOME%\bin\java" %OPTS% %CLS% %PAR%
@echo off
goto END

:HELP
echo.
echo Usage: terrorsreport [options] 
echo.
echo Options:
echo   -infile ^<testsuite_result_xml^>     (default: %TP_HOME%\testsuite\junit\testcasesresults.xml)
echo   -outfile ^<errors_report^>           (default: %TP_HOME%\testsuite\junit\errors.txt;
echo                                         also allowed: stdout, stderr)
echo.
goto END

:END
endlocal