/*
 * $Header: /home/cvs/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/tprocessor/StringResponseBodyAssert.java,v 1.5 2004/07/28 09:31:55 ib Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/28 09:31:55 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.tprocessor;

//java
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.slide.testsuite.testtools.tutil.XConf;



/**
 * Abstract root class to perform the necessary checks for the received and expected stream body
 *
 * @version $Revision: 1.5 $
 */
public abstract class StringResponseBodyAssert extends StreamResponseBodyAssert{


    private final static boolean extendedPrintlnsrequested = false;


    /** constructer
     * @param WebdavMethodBase Element
     */
    public StringResponseBodyAssert(HttpMethod method, InputStream expectedBody, XConf xconf, XMLOutput xmlresult, List expectedResponseCodes){
        super(method, expectedBody, xconf, xmlresult, expectedResponseCodes);
    }




    /**
     * checks if Expected Response and Response are same
     */
    public boolean assertResponseBody(){
        if (method.getStatusCode() < 200  || method.getStatusCode() > 300  ){
            return true;
        }

        if (receivedBody == null ||
            expectedBody == null  )
            return true;
        return compareStreams(receivedBody, expectedBody);
    }


    /**
     * checks if Expected and the received Response bodies are identical
     */
    protected boolean compareStrings(String receivedBody, String expectedBody){

        if (receivedBody.equals(expectedBody)) return true;

        if (receivedBody.length() != expectedBody.length()) {
            xmlresult.writeElement("ContentLengthError", "Received = " + receivedBody.length() +
                                                         " Expected = " + expectedBody.length() );
if (extendedPrintlnsrequested) System.out.println( "ContentLengthError " + "Received = " + receivedBody.length() +
                                                         " Expected = " + expectedBody.length());
        }

        String contentValueProblem = null;
        int charsRead = 0;
        while (charsRead < receivedBody.length() &&
               charsRead < expectedBody.length()) {

            char receivedChar = receivedBody.charAt(charsRead);
            char expectedChar = expectedBody.charAt(charsRead);

if (extendedPrintlnsrequested) System.out.println(getStreamCharByte(charsRead, receivedChar, expectedChar) );

            if (receivedChar != expectedChar) {
                if (contentValueProblem == null) {
                    contentValueProblem = "Position = " + charsRead;
                } else {
                    if (contentValueProblem.length() < 1024)
                        contentValueProblem += " ," + charsRead;
                }
            }

            charsRead++;
        }

        if (contentValueProblem != null) {
            xmlresult.writeElement("ContentValueError", contentValueProblem);
        }

        // length or value are not identical
        return false;
    }

//////////////////////////////////////////////
//   some debugging printlns and methods    //
//////////////////////////////////////////////


    /**
     * get a byte as decimal and (try) as character with prefix
     */
    protected String getStreamCharByte(int counter, char exp, char rec){
        return getStreamCharByte(counter, getBytes(exp), getBytes(rec));
    }
    /**
     * get a prefix string for printing
     */
    protected byte[] getBytes(char character){
        try
        {
            return new Character(character).toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) { return new byte[]{0x00};}
    }



}


