/*
 * $Header: /home/cvs/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/tprocessor/XMLStreamResponseBodyAssert.java,v 1.9 2004/07/28 09:31:53 ib Exp $
 * $Revision: 1.9 $
 * $Date: 2004/07/28 09:31:53 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.tprocessor;

//java
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.Exception;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.slide.testsuite.testtools.tutil.XConf;
import org.apache.xerces.parsers.DOMParser;
import org.custommonkey.xmlunit.Diff;
import org.xml.sax.InputSource;


/**
 * Abstract root class to perform the necessary checks for the received and expected stream body
 *
 * @version $Revision: 1.9 $
 */
public abstract class XMLStreamResponseBodyAssert extends StreamResponseBodyAssert {




    /** constructer
     * @param WebdavMethodBase Element
     */
    public XMLStreamResponseBodyAssert(HttpMethod method, InputStream expectedBody, XConf xconf, XMLOutput xmlresult, List expectedResponseCodes){
        super(method, expectedBody, xconf, xmlresult, expectedResponseCodes);
    }







    /**
     * checks if Expected and the received Response bodies are identical
     */
    protected boolean compareStreams(InputStream receivedBody, InputStream expectedBody)  {
        byte[] receivedCopy = null;
        byte[] expectedCopy = null;
        try
        {
            receivedCopy = readFromStream(receivedBody);
            expectedCopy = readFromStream(expectedBody);

//            // compare on a string base
//            String received = new XMLOutputter("", false, "UTF-8").outputString(new SAXBuilder().build(new ByteArrayInputStream(receivedCopy)));
//            String expected = new XMLOutputter("", false, "UTF-8").outputString(new SAXBuilder().build(new ByteArrayInputStream(expectedCopy)));
//            return super.compareStrings(received, expected);

            DOMParser expectedDOM = new DOMParser();
            DOMParser receivedDOM = new DOMParser();
            expectedDOM.parse(new InputSource(new ByteArrayInputStream(expectedCopy)));
            receivedDOM.parse(new InputSource(new ByteArrayInputStream(receivedCopy)));
            Diff difference = new Diff(expectedDOM.getDocument(), receivedDOM.getDocument());
            if (!difference.identical()) {
                xmlresult.writeElement("ContentValueError", difference.toString());
//                System.out.println("##################");
//                System.out.println(diffference.toString());
//                System.out.println("##################");
            }
            return difference.identical();


        }

        catch (Exception e) {
            // if not XML compare it on a binary base
            return super.compareStreams(new ByteArrayInputStream(receivedCopy),
                                        new ByteArrayInputStream(expectedCopy));
        }

    }

    // -------------------------------------------------------- Private Methods


    private static final int CHUNK = 1024*4;


    /**
     * Read the data from the stream and return the result in a byte array.
     * Return null in case of an error.
     */
    public static  byte[] readFromStream(InputStream inputStream) throws IOException {
        byte[] chunk;
        byte[] all;
        int chunkLen;
        int allLen;
        List chunks;
        int i;
        int max;
        int ofs;

        allLen = 0;
        chunk = new byte[CHUNK];
        chunkLen = inputStream.read(chunk);
        chunks = new ArrayList();
        while (chunkLen != -1) {
            chunks.add(new Integer(chunkLen));
            chunks.add(chunk);
            allLen += chunkLen;
            chunk = new byte[CHUNK];
            chunkLen = inputStream.read(chunk);
        }

        all = new byte[allLen];
        ofs = 0;
        max = chunks.size();
        for (i = 0; i < max; i += 2) {
            chunkLen = ((Integer) chunks.get(i)).intValue();
            chunk = (byte[]) chunks.get(i + 1);
            System.arraycopy(chunk, 0, all, ofs, chunkLen);
            ofs += chunkLen;
        }
        return all;
    }



}

