/*
 * $Header: /home/cvs/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/tutil/XConf.java,v 1.5 2004/07/28 09:31:52 ib Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/28 09:31:52 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.tutil;

import java.util.*;
import java.io.*;
import org.jdom.*;
import org.jdom.input.*;

/**
 * Reads the indicated XML file. This config file shall look like this:
 * <pre><code>
 * <config>
 *  <prop1>valueOfProp1</prop1>
 *  <
 *
 *
 *
 *
 * </config>
 
 
 * </code></pre>
 *
 * @version $Revision: 1.5 $
 *
 */
public class XConf {
    
    /**
     * represents the configuration document
     *
     * @invariant (document != null)
     * @see        java.lang.String#equals
     */
    private Document cfgDoc;
    
    private Element rootElement;
    
    /**
     * Creates the document
     *
     * @param      confFile   the content object to be made persistent
     *
     * @exception  IOException
     * @exception  JDOMException
     */
    public XConf (File cfgFile) throws IOException, JDOMException {
        SAXBuilder sb = new SAXBuilder();
        cfgDoc = sb.build (cfgFile);
        rootElement = cfgDoc.getRootElement();
    }
    
    
    /**
     * Creates the document
     *
     * @param      confFile   the content object to be made persistent
     *
     * @exception  IOException
     * @exception  JDOMException
     */
    public XConf (Document doc) throws IOException, JDOMException {
        SAXBuilder sb = new SAXBuilder();
        cfgDoc = doc;
        rootElement = cfgDoc.getRootElement();
    }
    
    /**
     * returns the text value of an element. Key may contain '/'
     * (for example 'db/connectionstring')
     *
     * @param      element the elements name
     *
     * @return     the value of that property or null, if not in config
     */
    public String getProperty (String key) {
        Element el = getElement(key);
        return (el == null) ? null : el.getTextTrim();
    }
    
    /**
     * Returns a List of properties. Key may contain '/'
     * (for example 'db/connectionstring'). The element identified
     * by 'key' must have 0 or more nested elements, the text value
     * of those elements will be returned.
     *
     *
     * @param      element the elements name
     *
     * @return     the value of that property or null, if not in config
     */
    public List getPropertyList (String key) {
        
        List result = new ArrayList();
        
        Element father = getElement (key);
        if (father == null)
            return result;
        
        List children = father.getChildren();
        for (int i = 0; i < children.size(); i++)
            result.add( ((Element)children.get(i)).getTextTrim() );
        
        return result;
    }
    
    /**
     * Returns a List of properties. fatherKey may contain '/'
     * (for example 'db/connectionstring'). The element identified
     * by 'father' must have 0 or more nested elements, the text value
     * of those elements plus the values of father combined with key
     * will be returned.
     *
     *
     * @param      fatherKey the key of the father path (may contain /)
     * @param      key       the key combined with father and added to the result
     *
     * @return     the values of that properties or empty, if not in config
     */
    public List getPropertyList (String fatherKey, String key) {
        
        List result  = getPropertyList(fatherKey);
        result.addAll(getPropertyList(fatherKey+"/"+key));
        
        return result;
    }
    
    
    
    
    
    private Element getElement (String key) {
        StringTokenizer st = new StringTokenizer(key, "/");
        
        Element father = rootElement;
        Element child = null;
        while (st.hasMoreTokens()) {
            String childKey = st.nextToken();
            child = father.getChild (childKey);
            if (child == null)
                return null;
            father = child;
        }
        return father;
    }
    
    
    public static void main (String [] a) throws Exception {
        XConf conf = new XConf (new File (a[0]));
        System.out.println (conf.getPropertyList ("otto/taminobase"));
        System.out.println (conf.getProperty ("tamino/taminobase"));
        
        System.out.println(conf.getPropertyList ("excludedHeaderProperties", "propfind"));
        System.out.println(conf.getPropertyList ("excludedHeaderProperties/propfind"));
    }
}
