/*
 * $Header: /home/cvs/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/walker/WalkerFilter.java,v 1.4 2004/07/28 09:31:50 ib Exp $
 * $Revision: 1.4 $
 * $Date: 2004/07/28 09:31:50 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.walker;

//Java imports
import java.util.*;
import java.io.*;
// pattern matcher
import org.apache.oro.text.awk.*;
import org.apache.oro.text.regex.*;


/**
 * Implement a Filter class (include, exclude) to check file name against
 *
 * @version $Revision: 1.4 $
 */
public class WalkerFilter {
    
    private ArrayList   includeFilter   = new ArrayList();
    private ArrayList   excludeFilter   = new ArrayList();
    private AwkCompiler patternCompiler = new AwkCompiler();
    private AwkMatcher  patternMatcher  = new AwkMatcher();
    
    
    /**
     * Add a fileName to the filter. Eg. *.*, *.xml, WalkerFilter.java etc
     * @param     String        Name of the file to include
     */
    public void includeFileName(String fileName) {
        try {
            if (fileName != null)
                includeFilter.add(patternCompiler.compile(standardPattern(fileName)));
        }
        catch (Exception e) { e.printStackTrace(); }
    }
    
    public void excludeFileName(String fileName) {
        try {
            if (fileName != null)
                excludeFilter.add(patternCompiler.compile(standardPattern(fileName)));
        }
        catch (Exception e) { e.printStackTrace(); }
    }
    
    /**
     * Is the given file acceptable part of the filter.
     * @param     java.io.File
     * @param     String
     * @return    boolean
     */
    public boolean accept(java.io.File file, String path) {
        boolean result = false;
        String fileName = path + File.separatorChar + file.getName();
        
        //Check to see if the file name is part of the filter
        Iterator include = includeFilter.iterator();
        while (include.hasNext()) {
            Pattern element = (Pattern)include.next();
//          System.out.println("Include (" + element.getPattern() + " , " + fileName + " )= " + patternMatcher.matches(fileName, element));
            if (patternMatcher.matches(fileName, element)) result = true;
        }
        
        //Check to see if the file name is part of the filter
        Iterator exclude = excludeFilter.iterator();
        while (exclude.hasNext()) {
            Pattern element = (Pattern)exclude.next();
            if (patternMatcher.matches(fileName, element)) result = false;
//          System.out.println("Exclude (" + element.getPattern() + " , " + fileName + " )= " + patternMatcher.matches(fileName, element));
        }
        
//      System.out.println("RESULT = " + result);
//      System.out.println();
        
        return result;
    }
    
    
    /**
     * This method is used to replace variables in a string
     * @param line the string which will be modified
     * @param pattern search string to be replaced
     * @param value value of the replace string
     * @return value of line, with all applied replacements
     */
    private static String standardPattern(String line){
        return replace(replace(line, ".", "\\."), "*", ".*");
    }
    
    
    
    /**
     * This method is used to replace variables in a string
     * @param line the string which will be modified
     * @param pattern search string to be replaced
     * @param value value of the replace string
     * @return value of line, with all applied replacements
     */
    private static String replace(String line, String pattern, String value){
        int lastFound = line.indexOf(pattern);
        while (lastFound != -1){
            line = line.substring(0, lastFound) +
                value +
                line.substring(lastFound + pattern.length());
            lastFound = line.indexOf(pattern, lastFound+pattern.length()+1);
        }
        //      System.out.println("#### Replaced " + pattern + " with " + value + " --> " + line);
        return line;
    }
    
    
    
    
}


