/*
 * $Header: /home/cvs/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/walker/WalkerTest.java,v 1.5 2004/07/28 09:31:50 ib Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/28 09:31:50 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.walker;


import junit.framework.*;

/**
 * Junit test for the file Walker
 *
 * @version $Revision: 1.5 $
 */
public class WalkerTest extends TestCase {
    
    
    
    private String xdavHome = System.getProperty("xdav.home");
    private String xdavHost = System.getProperty("xdav.host");
    private String xdavPort = System.getProperty("xdav.port");
    
    
    
    /**
     ** Constructor WalkerTest.
     **/
    public WalkerTest(String name) {
        super( name );
        if (xdavHome == null) {
            System.out.println("xdav.home is not set!");
            throw new Error("xdav.home is not set!");
        }
        xdavHome = xdavHome+java.io.File.separatorChar+"testsuite";
        xdavHome = xdavHome+java.io.File.separatorChar+"src";
        xdavHome = xdavHome+java.io.File.separatorChar+"com";
        xdavHome = xdavHome+java.io.File.separatorChar+"softwareag";
        xdavHome = xdavHome+java.io.File.separatorChar+"xtools";
        xdavHome = xdavHome+java.io.File.separatorChar+"xdav";
        xdavHome = xdavHome+java.io.File.separatorChar+"testtools";
        xdavHome = xdavHome+java.io.File.separatorChar+"walker";
        xdavHome = xdavHome+java.io.File.separatorChar+"toBeWalked1";
        
    }
    
    /**
     * walk a directory and check for extensions w1 and w2
     */
    public void testWalker() throws Exception {
        String[] filter = new String[2];
        filter[0] = "*.w1";
        filter[1] = "*.w2";
        String[] exclude = new String[1];
        exclude[0] = "CVS";
        DirectoryWalker walker = new DirectoryWalker(xdavHome, filter, exclude, new WalkerJob() {
                    public void job(String jobName) {
                        //System.out.println(jobName);
                        assertTrue("Wrong extension found " + jobName, jobName.endsWith("w1") || jobName.endsWith("w2"));
                    }
                }
                                                    );
    }
    
    
    
    
}

