/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portal.ErrorID;
import org.jasig.portal.Errors;
import org.jasig.portal.ExceptionHelper;
import org.jasig.portal.MultipartDataSource;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserInstance;
import org.jasig.portal.UserInstanceManager;
import org.jasig.portal.jndi.JNDIManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SubstitutionServletOutputStream;
import org.jasig.portal.utils.SubstitutionWriter;

public class PortalSessionManager
extends HttpServlet {
    public static final String INTERNAL_TAG_VALUE = Long.toHexString(new Random().nextLong());
    public static final String IDEMPOTENT_URL_TAG = "idempotent";
    private static final int sizeLimit = PropertiesManager.getPropertyAsInt("org.jasig.portal.PortalSessionManager.File_upload_max_size");
    private static boolean initialized = false;
    private static ServletContext servletContext = null;
    private static PortalSessionManager instance = null;
    private static boolean fatalError = false;
    public static final ErrorID initPortalContext = new ErrorID("config", "JNDI", "Cannot initialize JNDI context");
    private static final boolean ALLOW_REPEATED_REQUESTS = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.PortalSessionManager.allow_repeated_requests");
    private static final Random randomGenerator = new Random();

    public static final PortalSessionManager getInstance() {
        return instance;
    }

    public void init() throws ServletException {
        if (!initialized) {
            instance = this;
            ServletConfig sc = this.getServletConfig();
            if (sc == null) {
                throw new ServletException("PortalSessionManager.init(): ServletConfig object was returned as null");
            }
            servletContext = sc.getServletContext();
            try {
                JNDIManager.initializePortalContext();
            }
            catch (Exception pe) {
                ExceptionHelper.genericTopHandler(initPortalContext, pe);
                fatalError = true;
            }
            Runtime.getRuntime().addShutdownHook(new Thread("uPortal shutdown hook"){

                public void run() {
                    LogService.log(LogService.INFO, "uPortal stopped");
                }
            });
            initialized = true;
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", PropertiesManager.getProperty("org.xml.sax.driver"));
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("uPortal-version", "uPortal_rel-2-2-0+");
        if (fatalError) {
            try {
                res.sendRedirect("error/fatal.htm");
            }
            catch (IOException e) {
                ExceptionHelper.genericTopHandler(Errors.bug, e);
            }
            return;
        }
        HttpSession session = req.getSession();
        if (session != null) {
            Set<String> requestTags = null;
            boolean request_verified = false;
            if (!ALLOW_REPEATED_REQUESTS) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    requestTags = (Set<String>)session.getAttribute("uP_requestTags");
                    if (requestTags == null) {
                        requestTags = Collections.synchronizedSet(new HashSet());
                        session.setAttribute("uP_requestTags", requestTags);
                    }
                }
                UPFileSpec upfs = new UPFileSpec(req);
                String tag = upfs.getTagId();
                if (tag != null) {
                    request_verified = tag.equals(IDEMPOTENT_URL_TAG) || requestTags.remove(tag);
                }
                LogService.log(LogService.DEBUG, "PortalSessionManager::doGet() : request verified: " + request_verified);
            }
            try {
                UserInstance userInstance = null;
                try {
                    userInstance = UserInstanceManager.getUserInstance(req);
                }
                catch (Exception e) {
                    ExceptionHelper.genericTopHandler(Errors.bug, e);
                    ExceptionHelper.generateErrorPage(res, e);
                    return;
                }
                if (ALLOW_REPEATED_REQUESTS) {
                    userInstance.writeContent(new RequestParamWrapper(req, true), res);
                } else {
                    String newTag = Long.toHexString(randomGenerator.nextLong());
                    LogService.log(LogService.DEBUG, "PortalSessionManager::doGet() : generated new tag \"" + newTag + "\" for the session " + req.getSession(false).getId());
                    if (!requestTags.add(newTag)) {
                        LogService.log(LogService.ERROR, "PortalSessionManager::doGet() : a duplicate tag has been generated ! Time's up !");
                    }
                    userInstance.writeContent(new RequestParamWrapper(req, request_verified), new ResponseSubstitutionWrapper(res, INTERNAL_TAG_VALUE, newTag));
                }
            }
            catch (Exception e) {
                ExceptionHelper.genericTopHandler(Errors.bug, e);
                ExceptionHelper.generateErrorPage(res, e);
                return;
            }
        }
    }

    public static URL getResourceAsURL(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        URL url = null;
        try {
            url = servletContext.getResource(resource);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        return servletContext.getResourceAsStream(resource);
    }

    static {
        LogService.log(LogService.INFO, "uPortal started");
    }

    public class RequestParamWrapper
    implements HttpServletRequest {
        protected final HttpServletRequest req;
        protected Hashtable parameters;
        protected boolean request_verified;

        public RequestParamWrapper(HttpServletRequest source, boolean request_verified) {
            this.req = source;
            this.request_verified = request_verified;
            this.parameters = new Hashtable();
            if (request_verified) {
                String contentType = source.getContentType();
                if (contentType != null && contentType.startsWith("multipart/form-data")) {
                    try {
                        Part attachmentPart;
                        MultipartParser multi = new MultipartParser(source, sizeLimit, true, true, "UTF-8");
                        while ((attachmentPart = multi.readNextPart()) != null) {
                            FilePart filePart;
                            String filename;
                            Object[] valueArray;
                            String partName = attachmentPart.getName();
                            if (attachmentPart.isParam()) {
                                ParamPart parameterPart = (ParamPart)attachmentPart;
                                String paramValue = parameterPart.getStringValue();
                                if (this.parameters.containsKey(partName)) {
                                    String[] oldValueArray = (String[])this.parameters.get(partName);
                                    valueArray = new String[oldValueArray.length + 1];
                                    for (int i = 0; i < oldValueArray.length; ++i) {
                                        valueArray[i] = oldValueArray[i];
                                    }
                                    valueArray[oldValueArray.length] = paramValue;
                                    this.parameters.put(partName, valueArray);
                                    continue;
                                }
                                String[] valueArray2 = new String[]{paramValue};
                                this.parameters.put(partName, valueArray2);
                                continue;
                            }
                            if (!attachmentPart.isFile() || (filename = (filePart = (FilePart)attachmentPart).getFileName()) == null) continue;
                            MultipartDataSource fileUpload = new MultipartDataSource(filePart);
                            if (this.parameters.containsKey(partName)) {
                                MultipartDataSource[] oldValueArray = (MultipartDataSource[])this.parameters.get(partName);
                                MultipartDataSource[] valueArray3 = new MultipartDataSource[oldValueArray.length + 1];
                                for (int i = 0; i < oldValueArray.length; ++i) {
                                    valueArray3[i] = oldValueArray[i];
                                }
                                valueArray3[oldValueArray.length] = fileUpload;
                                this.parameters.put(partName, valueArray3);
                                continue;
                            }
                            valueArray = new MultipartDataSource[]{fileUpload};
                            this.parameters.put(partName, valueArray);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHelper.genericTopHandler(Errors.bug, e);
                    }
                }
                try {
                    source.setCharacterEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    LogService.log(LogService.ERROR, "PortalSessionManager.RequestParamWrapper(): unable to set UTF-8 character encoding! " + uee);
                }
                Enumeration en = source.getParameterNames();
                if (en != null) {
                    while (en.hasMoreElements()) {
                        String pName = (String)en.nextElement();
                        this.parameters.put(pName, source.getParameterValues(pName));
                    }
                }
            }
        }

        public String getParameter(String name) {
            String[] value_array = this.getParameterValues(name);
            if (value_array != null && value_array.length > 0) {
                return value_array[0];
            }
            return null;
        }

        public Enumeration getParameterNames() {
            return this.parameters.keys();
        }

        public String[] getParameterValues(String name) {
            Object[] pars = (Object[])this.parameters.get(name);
            if (pars != null && pars instanceof String[]) {
                return (String[])this.parameters.get(name);
            }
            return null;
        }

        public Map getParameterMap() {
            return this.parameters;
        }

        public Object[] getObjectParameterValues(String name) {
            return (Object[])this.parameters.get(name);
        }

        public String getRequestURI() {
            return this.req.getRequestURI();
        }

        public String getPathInfo() {
            return this.req.getPathInfo();
        }

        public String getPathTranslated() {
            return this.req.getPathTranslated();
        }

        public String getContextPath() {
            return this.req.getContextPath();
        }

        public String getQueryString() {
            return this.req.getQueryString();
        }

        public String getServletPath() {
            return this.req.getServletPath();
        }

        public StringBuffer getRequestURL() {
            try {
                Method m = this.req.getClass().getMethod("getRequestURL", null);
                return (StringBuffer)m.invoke((Object)this.req, null);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            try {
                Class[] paramTypes = new Class[]{new String().getClass()};
                Method m = this.req.getClass().getMethod("setCharacterEncoding", paramTypes);
                Object[] args = new Object[]{env};
                m.invoke((Object)this.req, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getAuthType() {
            return this.req.getAuthType();
        }

        public Cookie[] getCookies() {
            return this.req.getCookies();
        }

        public long getDateHeader(String name) {
            return this.req.getDateHeader(name);
        }

        public String getHeader(String name) {
            return this.req.getHeader(name);
        }

        public Enumeration getHeaders(String name) {
            return this.req.getHeaders(name);
        }

        public Enumeration getHeaderNames() {
            return this.req.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.req.getIntHeader(name);
        }

        public String getMethod() {
            return this.req.getMethod();
        }

        public String getRemoteUser() {
            return this.req.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            return this.req.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            return this.req.getUserPrincipal();
        }

        public String getRequestedSessionId() {
            return this.req.getRequestedSessionId();
        }

        public HttpSession getSession(boolean create) {
            return this.req.getSession(create);
        }

        public HttpSession getSession() {
            return this.req.getSession();
        }

        public boolean isRequestedSessionIdValid() {
            return this.req.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.req.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.req.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.req.isRequestedSessionIdFromURL();
        }

        public Object getAttribute(String name) {
            return this.req.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return this.req.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.req.getCharacterEncoding();
        }

        public int getContentLength() {
            return this.req.getContentLength();
        }

        public String getContentType() {
            return this.req.getContentType();
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.req.getInputStream();
        }

        public String getProtocol() {
            return this.req.getProtocol();
        }

        public String getScheme() {
            return this.req.getScheme();
        }

        public String getServerName() {
            return this.req.getServerName();
        }

        public int getServerPort() {
            return this.req.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.req.getReader();
        }

        public String getRemoteAddr() {
            return this.req.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.req.getRemoteHost();
        }

        public void setAttribute(String name, Object o) {
            this.req.setAttribute(name, o);
        }

        public void removeAttribute(String name) {
            this.req.removeAttribute(name);
        }

        public Locale getLocale() {
            return this.req.getLocale();
        }

        public Enumeration getLocales() {
            return this.req.getLocales();
        }

        public boolean isSecure() {
            return this.req.isSecure();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.req.getRequestDispatcher(path);
        }

        public String getRealPath(String path) {
            throw new RuntimeException("HttpServletRequest.getRealPath(String path) is deprectated!  Use ServletContext.getRealPath(String path) instead.");
        }
    }

    public class ResponseSubstitutionWrapper
    implements HttpServletResponse {
        protected final HttpServletResponse res;
        protected String sessionTag;
        protected String newTag;

        public ResponseSubstitutionWrapper(HttpServletResponse res, String sessionTag, String newTag) {
            this.res = res;
            this.sessionTag = sessionTag;
            this.newTag = newTag;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            byte[] substitute;
            byte[] target;
            String encoding = this.getCharacterEncoding();
            if (encoding != null) {
                target = this.sessionTag.getBytes(encoding);
                substitute = this.newTag.getBytes(encoding);
            } else {
                target = this.sessionTag.getBytes();
                substitute = this.newTag.getBytes();
            }
            return new SubstitutionServletOutputStream(this.res.getOutputStream(), target, substitute, this.getBufferSize());
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(new SubstitutionWriter(this.res.getWriter(), this.sessionTag.toCharArray(), this.newTag.toCharArray(), this.getBufferSize()));
        }

        public String getCharacterEncoding() {
            return this.res.getCharacterEncoding();
        }

        public void reset() {
            this.res.reset();
        }

        public void flushBuffer() throws IOException {
            this.res.flushBuffer();
        }

        public void setContentType(String type) {
            this.res.setContentType(type);
        }

        public void setContentLength(int len) {
            this.res.setContentLength(len);
        }

        public void setBufferSize(int size) {
            this.res.setBufferSize(size);
        }

        public int getBufferSize() {
            return this.res.getBufferSize();
        }

        public boolean isCommitted() {
            return this.res.isCommitted();
        }

        public void setLocale(Locale loc) {
            this.res.setLocale(loc);
        }

        public Locale getLocale() {
            return this.res.getLocale();
        }

        public void resetBuffer() {
            try {
                Method m = this.res.getClass().getMethod("reseBuffer", null);
                m.invoke((Object)this.res, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void addCookie(Cookie cookie) {
            this.res.addCookie(cookie);
        }

        public boolean containsHeader(String name) {
            return this.res.containsHeader(name);
        }

        public String encodeURL(String url) {
            return this.res.encodeURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.res.encodeRedirectURL(url);
        }

        public String encodeUrl(String url) {
            return this.res.encodeUrl(url);
        }

        public String encodeRedirectUrl(String url) {
            return this.res.encodeRedirectUrl(url);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.res.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.res.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.res.sendRedirect(location);
        }

        public void setDateHeader(String name, long date) {
            this.res.setDateHeader(name, date);
        }

        public void addDateHeader(String name, long date) {
            this.res.addDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.res.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.res.addHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.res.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.res.addIntHeader(name, value);
        }

        public void setStatus(int sc) {
            this.res.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.res.setStatus(sc, sm);
        }
    }
}

