/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.CountID;
import org.jasig.portal.ExceptionHelper;
import org.jasig.portal.PortalException;
import org.jasig.portal.ProblemsTable;

public class Problems
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<head><title>uPortal Problem Status</title></head>");
        out.println("<body>");
        out.println("<h1>uPortal Problem Status</h1>");
        String majorname = request.getParameter("major");
        String minorname = request.getParameter("minor");
        if (majorname == null) {
            out.println(this.listRecent());
            out.println(this.listRegistered());
        } else {
            out.println(this.listdetail(majorname, minorname));
        }
        out.println("</body>");
    }

    private String listdetail(String majorname, String minorname) {
        StringBuffer sb = new StringBuffer(1000);
        TreeMap submap = (TreeMap)ProblemsTable.registeredIds.get(majorname);
        CountID countid = null;
        if (submap != null) {
            countid = (CountID)submap.get(minorname);
        }
        if (countid == null) {
            return "No registered error with these parameters.";
        }
        sb.append("<pre>");
        PortalException pe = countid.lastPortalException;
        Exception ex = pe.getRecordedException();
        if (ex == null) {
            ex = pe;
        }
        sb.append("at " + pe.getTimestamp().toString() + "\n");
        sb.append(ExceptionHelper.errorInfo(pe.getErrorID(), pe.getParameter(), ex));
        sb.append("</pre>");
        return sb.toString();
    }

    private String listRegistered() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<h2>Registered Error IDs</h2>");
        Iterator minors = ProblemsTable.registeredIds.values().iterator();
        sb.append("<table>");
        while (minors.hasNext()) {
            TreeMap minor = (TreeMap)minors.next();
            Iterator ids = minor.values().iterator();
            while (ids.hasNext()) {
                CountID nextid = (CountID)ids.next();
                sb.append("<tr><td>");
                sb.append(nextid.errorID.category);
                sb.append("</td><td>");
                sb.append(nextid.errorID.specific);
                sb.append("</td><td>");
                if (nextid.count > 0) {
                    sb.append("<a href='problems?major=" + nextid.errorID.category + "&minor=" + nextid.errorID.specific + "'>");
                }
                sb.append(nextid.errorID.message);
                if (nextid.count > 0) {
                    sb.append("</a>");
                }
                sb.append("</td><td>");
                sb.append(nextid.count);
                sb.append("</td></tr>");
            }
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String listRecent() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<h2>Recent Error IDs</h2>");
        Iterator list = ProblemsTable.recentIds.iterator();
        sb.append("<table>");
        while (list.hasNext()) {
            CountID nextid = (CountID)list.next();
            sb.append("<tr><td>");
            sb.append(nextid.errorID.category);
            sb.append("</td><td>");
            sb.append(nextid.errorID.specific);
            sb.append("</td><td>");
            if (nextid.count > 0) {
                sb.append("<a href='problems?major=" + nextid.errorID.category + "&minor=" + nextid.errorID.specific + "'>");
            }
            sb.append(nextid.errorID.message);
            if (nextid.count > 0) {
                sb.append("</a>");
            }
            sb.append("</td><td>");
            sb.append(nextid.count);
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }
}

