/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IMultithreadedMimeResponse;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseMultithreadedChannel;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.PersonDirectory;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CPersonAttributes
extends BaseMultithreadedChannel
implements IMultithreadedMimeResponse {
    private static final String sslLocation = "CPersonAttributes/CPersonAttributes.ssl";

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        IPerson person = staticData.getPerson();
        Document doc = DocumentFactory.getNewDocument();
        Element attributesE = doc.createElement("attributes");
        Iterator attribs = PersonDirectory.getPropertyNamesIterator();
        while (attribs.hasNext()) {
            String attName = (String)attribs.next();
            Element attributeE = doc.createElement("attribute");
            Element nameE = doc.createElement("name");
            nameE.appendChild(doc.createTextNode(attName));
            attributeE.appendChild(nameE);
            if (person.getAttribute(attName) != null) {
                String value = person.getAttribute(attName).toString();
                Element valueE = doc.createElement("value");
                valueE.appendChild(doc.createTextNode(value));
                attributeE.appendChild(valueE);
            }
            attributesE.appendChild(attributeE);
        }
        doc.appendChild(attributesE);
        XSLT xslt = XSLT.getTransformer(this, runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
        xslt.setStylesheetParameter("downloadWorkerURL", runtimeData.getBaseWorkerURL("download", true));
        xslt.setXSL(sslLocation, runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }

    public String getContentType(String uid) {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        String attrName = runtimeData.getParameter("attribute");
        String mimetype = "jpegPhoto".equals(attrName) ? "image/jpeg" : "application/octet-stream";
        return mimetype;
    }

    public InputStream getInputStream(String uid) throws IOException {
        byte[] imgBytes;
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        String attrName = runtimeData.getParameter("attribute");
        IPerson person = staticData.getPerson();
        if (attrName == null) {
            attrName = "";
        }
        if ((imgBytes = (byte[])person.getAttribute(attrName)) == null) {
            imgBytes = new byte[]{};
        }
        ByteArrayInputStream is = new ByteArrayInputStream(imgBytes);
        return is;
    }

    public void downloadData(OutputStream out, String uid) throws IOException {
    }

    public String getName(String uid) {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        String payloadName = "jpegPhoto".equals(runtimeData.getParameter("attribute")) ? "image.jpg" : "unknown";
        return payloadName;
    }

    public Map getHeaders(String uid) {
        return null;
    }

    public void reportDownloadError(Exception e) {
        LogService.log(LogService.ERROR, "CPersonAttributes::reportDownloadError(): " + e.getMessage());
    }
}

