/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.commands;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.commands.GroupsManagerCommand;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateGroup
extends GroupsManagerCommand {
    public void execute(CGroupsManagerSessionData sessionData) throws Exception {
        ChannelStaticData staticData = sessionData.staticData;
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        Utility.logMessage("DEBUG", "UpdateGroup::execute(): Start");
        Document model = this.getXmlDoc(sessionData);
        String theCommand = runtimeData.getParameter("grpCommand");
        String newName = runtimeData.getParameter("grpName");
        String newDescription = runtimeData.getParameter("grpDescription");
        String updId = this.getCommandArg(runtimeData);
        Element updElem = GroupsManagerXML.getElementByTagNameAndId(model, "group", updId);
        String updKey = updElem.getAttribute("key");
        String curName = GroupsManagerXML.getElementValueForTagName(updElem, "dc:title");
        if (curName == null || curName.equals("")) {
            Utility.logMessage("ERROR", "UpdateGroup::execute(): Cannot find dc:title element for: " + updElem.getAttribute("name"));
            return;
        }
        String curDescription = GroupsManagerXML.getElementValueForTagName(updElem, "dc:description");
        boolean hasChanged = false;
        if (!Utility.areEqual(curName, newName)) {
            Utility.logMessage("DEBUG", "UpdateGroup::execute(): Group name: '" + curName + "' will be updated to : '" + newName + "'");
            hasChanged = true;
        }
        if (!Utility.areEqual(curDescription, newDescription)) {
            Utility.logMessage("DEBUG", "UpdateGroup::execute(): Group: '" + newDescription + "' will be updated to : '" + newDescription + "'");
            hasChanged = true;
        }
        if (!hasChanged) {
            String retMsg;
            Utility.logMessage("DEBUG", "UpdateGroup::execute(): Update was not applied because nothing has been changed.");
            sessionData.feedback = retMsg = "Update was not applied. No changes were entered.";
            return;
        }
        ILockableEntityGroup updGroup = sessionData.lockedGroup;
        if (updGroup == null) {
            String retMsg;
            sessionData.feedback = retMsg = "Unable to retrieve Group!";
            return;
        }
        Utility.logMessage("DEBUG", "UpdateGroup::execute(): About to update group: " + curName);
        updGroup.setName(newName);
        updGroup.setDescription(newDescription);
        updGroup.updateAndRenewLock();
        Utility.logMessage("DEBUG", "UpdateGroup::execute(): About to update xml nodes for group: " + curName);
        GroupsManagerXML.refreshAllNodes(sessionData.getUnrestrictedData(), updGroup);
        Utility.logMessage("DEBUG", "UpdateGroup::execute(): Finished");
    }
}

