/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.UserLayoutNodeDescription;
import org.jasig.portal.utils.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class SimpleLayout
implements IUserLayout {
    private Document layout;
    private String layoutId;
    private String cacheKey;

    public SimpleLayout(String layoutId, Document layout) {
        this.layoutId = layoutId;
        this.layout = layout;
    }

    public void writeTo(ContentHandler ch) throws PortalException {
        try {
            XML.dom2sax(this.layout, ch);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public void writeTo(String nodeId, ContentHandler ch) throws PortalException {
        try {
            XML.dom2sax(this.layout.getElementById(nodeId), ch);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public void writeTo(Document document) throws PortalException {
        document.appendChild(document.importNode(this.layout.getDocumentElement(), true));
    }

    public void writeTo(String nodeId, Document document) throws PortalException {
        document.appendChild(document.importNode(this.layout.getElementById(nodeId), true));
    }

    public IUserLayoutNodeDescription getNodeDescription(String nodeId) throws PortalException {
        Element element = this.layout.getElementById(nodeId);
        return UserLayoutNodeDescription.createUserLayoutNodeDescription(element);
    }

    public String getParentId(String nodeId) throws PortalException {
        Node parent;
        String parentId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null && (parent = element.getParentNode()) != null && parent.getNodeType() == 1) {
            Element parentE = (Element)parent;
            parentId = parentE.getAttribute("ID");
        }
        return parentId;
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        Vector<String> v = new Vector<String>();
        IUserLayoutNodeDescription node = this.getNodeDescription(nodeId);
        if (node instanceof IUserLayoutFolderDescription) {
            Element element = this.layout.getElementById(nodeId);
            for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e;
                if (n.getNodeType() != 1 || (e = (Element)n).getAttribute("ID") == null) continue;
                v.add(e.getAttribute("ID"));
            }
        }
        return v.elements();
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        String nextSiblingId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null) {
            Node sibling;
            for (sibling = element.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
            }
            if (sibling != null) {
                Element e = (Element)sibling;
                nextSiblingId = e.getAttribute("ID");
            }
        }
        return nextSiblingId;
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        String prevSiblingId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null) {
            Node sibling;
            for (sibling = element.getPreviousSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getPreviousSibling()) {
            }
            if (sibling != null) {
                Element e = (Element)sibling;
                prevSiblingId = e.getAttribute("ID");
            }
        }
        return prevSiblingId;
    }

    public String getCacheKey() throws PortalException {
        return this.cacheKey;
    }

    public boolean addLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public String getId() {
        return this.layoutId;
    }

    public String getNodeId(String fname) throws PortalException {
        String nodeId = null;
        NodeList nl = this.layout.getElementsByTagName("channel");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element channelE;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !fname.equals((channelE = (Element)node).getAttribute("fname"))) continue;
            nodeId = channelE.getAttribute("ID");
            break;
        }
        return nodeId;
    }

    public Enumeration getNodeIds() throws PortalException {
        Vector<String> v = new Vector<String>();
        try {
            NodeList nl = XPathAPI.selectNodeList((Node)this.layout, (String)"*");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                v.add(e.getAttribute("ID"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v.elements();
    }

    public String getRootId() {
        String rootNode = null;
        try {
            Element rootNodeE = (Element)XPathAPI.selectSingleNode((Node)this.layout, (String)"/layout/folder");
            rootNode = rootNodeE.getAttribute("ID");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootNode;
    }
}

