/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.BlockingQueue;
import org.jasig.portal.utils.ThreadPool;
import org.jasig.portal.utils.ThreadPoolReceipt;

public class ThreadPoolWorker
extends Thread {
    private static int nextWorkerID = 0;
    private ThreadPool pool;
    private BlockingQueue taskQueue;
    protected ThreadPoolReceipt currentReceipt;
    protected volatile boolean shouldRestart;
    protected volatile boolean shouldQuit;

    public ThreadPoolWorker(ThreadPool pool) {
        super((ThreadGroup)pool, pool.getName() + ":" + ThreadPoolWorker.getNextWorkerID());
        this.pool = pool;
        this.taskQueue = new BlockingQueue(0, 1);
        this.shouldQuit = false;
        this.shouldRestart = false;
    }

    public void run() {
        this.runWork();
        if (this.shouldRestart) {
            this.pool.notifyWorkerRestart(this);
        } else {
            this.pool.notifyWorkerFinished(this);
        }
    }

    public static synchronized String getNextWorkerID() {
        return Integer.toString(nextWorkerID++);
    }

    public synchronized ThreadPoolReceipt process(Runnable target) throws InterruptedException {
        if (this.currentReceipt != null) {
            LogService.log(LogService.ERROR, "ThreadPoolWorker::process() : trying to use a working worker !!! This should never happen.");
        }
        ThreadPoolReceipt returnReceipt = this.currentReceipt = new ThreadPoolReceipt(this);
        this.taskQueue.enqueue(target);
        return returnReceipt;
    }

    private void runWork() throws RuntimeException {
        while (!this.shouldQuit && !this.shouldRestart) {
            try {
                if (this.pool.idleWorkers.nonBlockingPush(this)) {
                    Runnable r = (Runnable)this.taskQueue.dequeue();
                    this.runIt(r);
                    continue;
                }
                this.shouldQuit = true;
            }
            catch (InterruptedException x) {
                if (this.currentReceipt != null) {
                    this.currentReceipt.updateStatus(null, true, false, x);
                    this.currentReceipt = null;
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    private void runIt(Runnable r) throws RuntimeException {
        try {
            r.run();
            this.currentReceipt.updateStatus(null, true, true, null);
            this.currentReceipt = null;
        }
        catch (RuntimeException runex) {
            this.currentReceipt.updateStatus(null, true, false, runex);
            this.currentReceipt = null;
            throw runex;
        }
    }

    public synchronized boolean completeRequest() {
        if (this.shouldQuit) {
            return false;
        }
        this.shouldQuit = true;
        return true;
    }

    public void stopRequest() {
        this.shouldQuit = true;
        this.interrupt();
    }

    public void killRequest() {
        System.out.println("workerID=" + this.getName() + ", killRequest() received.");
        this.shouldRestart = true;
        this.interrupt();
        this.pool.killWorkerThread(this);
    }
}

