/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.PortalException;

public class UPFileSpec {
    public static final String TAG_URL_ELEMENT = "tag";
    public static final String TARGET_URL_ELEMENT = "target";
    public static final String WORKER_URL_ELEMENT = "worker";
    public static final String DETACH_URL_ELEMENT = "detach";
    public static final String RENDER_URL_ELEMENT = "render";
    public static final String PORTAL_URL_SEPARATOR = ".";
    public static final String PORTAL_URL_SUFFIX = "uP";
    public static final String FILE_DOWNLOAD_WORKER = "download";
    public static final int RENDER_METHOD = 0;
    public static final int WORKER_METHOD = 1;
    String tagId = null;
    String method = null;
    String methodNodeId = null;
    String targetNodeId = null;
    String uPFile_extras = null;

    public UPFileSpec() {
    }

    public UPFileSpec(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        String uPFile = servletPath.substring(servletPath.lastIndexOf(47) + 1, servletPath.length());
        this.analyze(uPFile);
    }

    public UPFileSpec(String uPFile) {
        this.analyze(uPFile);
    }

    public UPFileSpec(UPFileSpec up) {
        this.tagId = up.getTagId();
        this.method = up.getMethod();
        this.methodNodeId = up.getMethodNodeId();
        this.targetNodeId = up.getTargetNodeId();
        this.uPFile_extras = up.getUPFileExtras();
    }

    public UPFileSpec(String tagId, int method, String methodNodeId, String targetNodeId, String extraElements) throws PortalException {
        this.setTagId(tagId);
        this.setMethod(method);
        this.setMethodNodeId(methodNodeId);
        this.setTargetNodeId(targetNodeId);
        this.setUPFileExtras(extraElements);
    }

    public void setTagId(String id) {
        this.tagId = id;
    }

    public void setMethod(int method) throws PortalException {
        if (method == 0) {
            this.method = RENDER_URL_ELEMENT;
        } else if (method == 1) {
            this.method = WORKER_URL_ELEMENT;
        } else {
            throw new PortalException("Invalid method code!");
        }
    }

    public void setMethodNodeId(String nodeId) {
        this.methodNodeId = nodeId;
    }

    public void setTargetNodeId(String nodeId) {
        this.targetNodeId = nodeId;
    }

    public void setUPFileExtras(String extras) {
        this.uPFile_extras = extras;
    }

    public String getTagId() {
        return this.tagId;
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethodNodeId() {
        return this.methodNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public String getUPFile() throws PortalException {
        return UPFileSpec.buildUPFileBase(this.tagId, this.method, this.methodNodeId, this.targetNodeId, this.uPFile_extras).concat(PORTAL_URL_SUFFIX);
    }

    public String getUPFileExtras() {
        return this.uPFile_extras;
    }

    public static String buildUPFile(String tagId, int method, String methodNodeId, String targetNodeId, String extraElements) throws PortalException {
        return UPFileSpec.buildUPFileBase(tagId, method, methodNodeId, targetNodeId, extraElements).concat(PORTAL_URL_SUFFIX);
    }

    public static String buildUPFileBase(String tagId, int method, String methodNodeId, String targetNodeId, String extraElements) throws PortalException {
        String methodName = null;
        if (method == 0) {
            methodName = RENDER_URL_ELEMENT;
        } else if (method == 1) {
            methodName = WORKER_URL_ELEMENT;
        } else {
            throw new PortalException("Invalid method code!");
        }
        return UPFileSpec.buildUPFileBase(tagId, methodName, methodNodeId, targetNodeId, extraElements);
    }

    protected static String buildUPFileBase(String tagId, String method, String methodNodeId, String targetNodeId, String extraElements) throws PortalException {
        StringBuffer sb = new StringBuffer();
        if (tagId != null) {
            sb.append(TAG_URL_ELEMENT).append(PORTAL_URL_SEPARATOR);
            sb.append(tagId).append(PORTAL_URL_SEPARATOR);
        }
        if (method == null) {
            throw new PortalException("UPFileSpec: method can not be null!");
        }
        sb.append(method).append(PORTAL_URL_SEPARATOR);
        if (methodNodeId == null) {
            throw new PortalException("UPFileSpec: method node Id can not be null!");
        }
        sb.append(methodNodeId).append(PORTAL_URL_SEPARATOR);
        if (targetNodeId != null) {
            sb.append(TARGET_URL_ELEMENT).append(PORTAL_URL_SEPARATOR);
            sb.append(targetNodeId).append(PORTAL_URL_SEPARATOR);
        }
        if (extraElements != null) {
            sb.append(extraElements).append(PORTAL_URL_SEPARATOR);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void analyze(String uPFile) {
        StringTokenizer uPTokenizer = new StringTokenizer(uPFile, PORTAL_URL_SEPARATOR);
        if (!uPTokenizer.hasMoreTokens()) return;
        String currentToken = uPTokenizer.nextToken();
        if (currentToken.equals(TAG_URL_ELEMENT)) {
            if (!uPTokenizer.hasMoreElements()) return;
            this.tagId = uPTokenizer.nextToken();
            if (!uPTokenizer.hasMoreElements()) return;
            currentToken = uPTokenizer.nextToken();
        }
        if (currentToken.equals(RENDER_URL_ELEMENT)) {
            this.method = currentToken;
        } else if (currentToken.equals(WORKER_URL_ELEMENT)) {
            this.method = currentToken;
        } else {
            this.uPFile_extras = UPFileSpec.sinkTokenization(uPTokenizer, PORTAL_URL_SEPARATOR, currentToken);
            return;
        }
        if (!uPTokenizer.hasMoreElements()) {
            return;
        }
        this.methodNodeId = uPTokenizer.nextToken();
        if (!uPTokenizer.hasMoreElements()) {
            return;
        }
        currentToken = uPTokenizer.nextToken();
        if (currentToken.equals(TARGET_URL_ELEMENT)) {
            if (!uPTokenizer.hasMoreElements()) return;
            this.targetNodeId = uPTokenizer.nextToken();
        }
        this.uPFile_extras = UPFileSpec.sinkTokenization(uPTokenizer, PORTAL_URL_SEPARATOR, currentToken);
    }

    private static String sinkTokenization(StringTokenizer st, String delimiter, String initialValue) {
        StringBuffer sb = initialValue != null ? new StringBuffer(initialValue) : new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            sb.append(delimiter);
            sb.append(token);
        }
        return sb.toString();
    }
}

