/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRenderingBuffer;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.CharacterCacheEntry;
import org.jasig.portal.CharacterCachingChannelIncorporationFilter;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IWorkerRequestProcessor;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.StandaloneChannelRenderer;
import org.jasig.portal.StructureAttributesIncorporationFilter;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeAttributesIncorporationFilter;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.channels.CSelectSystemProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.StatsRecorder;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SAX2DuplicatingFilterImpl;
import org.jasig.portal.utils.SoftHashMap;
import org.jasig.portal.utils.URLUtil;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.helpers.AttributesImpl;

public class UserInstance
implements HttpSessionBindingListener {
    public static final int guestUserId = 1;
    private static final boolean logXMLBeforeStructureTransformation = PropertiesManager.getPropertyAsBoolean((class$org$jasig$portal$UserInstance == null ? (class$org$jasig$portal$UserInstance = UserInstance.class$("org.jasig.portal.UserInstance")) : class$org$jasig$portal$UserInstance).getName() + ".log_xml_before_structure_transformation");
    private static final boolean logXMLBeforeThemeTransformation = PropertiesManager.getPropertyAsBoolean((class$org$jasig$portal$UserInstance == null ? (class$org$jasig$portal$UserInstance = UserInstance.class$("org.jasig.portal.UserInstance")) : class$org$jasig$portal$UserInstance).getName() + ".log_xml_before_theme_transformation");
    private IUserPreferencesManager uPreferencesManager;
    private ChannelManager channelManager;
    private LocaleManager localeManager;
    private static MediaManager mediaM;
    private StandaloneChannelRenderer p_browserMapper = null;
    private Object p_rendering_lock;
    public static final boolean CACHE_ENABLED;
    private static final int SYSTEM_XSLT_CACHE_MIN_SIZE;
    private static final int SYSTEM_CHARACTER_BLOCK_CACHE_MIN_SIZE;
    public static final boolean CHARACTER_CACHE_ENABLED;
    public static final String USER_LAYOUT_ROOT_NODE = "userLayoutRootNode";
    private static final String WORKER_PROPERTIES_FILE_NAME = "/properties/worker.properties";
    private static Properties workerProperties;
    private static final String CHARACTER_SET = "UTF-8";
    final SoftHashMap systemCache = new SoftHashMap(SYSTEM_XSLT_CACHE_MIN_SIZE);
    final SoftHashMap systemCharacterCache = new SoftHashMap(SYSTEM_CHARACTER_BLOCK_CACHE_MIN_SIZE);
    protected IPerson person;
    private IUserLayoutNodeDescription newNodeDescription = null;
    static /* synthetic */ Class class$org$jasig$portal$UserInstance;

    public UserInstance(IPerson person) {
        this.person = person;
        if (mediaM == null) {
            String mediaPropsUrl = this.getClass().getResource("/properties/media.properties").toString();
            String mimePropsUrl = this.getClass().getResource("/properties/mime.properties").toString();
            String serializerPropsUrl = this.getClass().getResource("/properties/serializer.properties").toString();
            mediaM = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl);
        }
    }

    public void writeContent(HttpServletRequest req, HttpServletResponse res) throws PortalException {
        if (this.p_browserMapper != null) {
            try {
                this.p_browserMapper.prepare(req);
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
        if (this.localeManager == null) {
            this.localeManager = new LocaleManager(this.person, req.getHeader("Accept-Language"));
        }
        if (this.uPreferencesManager == null || this.uPreferencesManager.isUserAgentUnmapped()) {
            this.uPreferencesManager = new UserPreferencesManager(req, this.getPerson(), this.localeManager);
        } else {
            this.p_browserMapper = null;
        }
        if (this.uPreferencesManager.isUserAgentUnmapped()) {
            if (this.p_browserMapper == null) {
                this.p_browserMapper = new CSelectSystemProfile();
                this.p_browserMapper.initialize(new Hashtable(), "CSelectSystemProfile", true, true, false, 10000L, this.getPerson());
            }
            try {
                this.p_browserMapper.render(req, res);
            }
            catch (PortalException pe) {
                throw new PortalException(pe);
            }
            catch (Throwable t) {
                LogService.log(LogService.ERROR, "UserInstance::writeContent() : CSelectSystemProfileChannel.render() threw: " + t);
                throw new PortalException("CSelectSystemProfileChannel.render() threw: " + t);
            }
            return;
        }
        if (this.channelManager == null) {
            this.channelManager = new ChannelManager(this.uPreferencesManager);
            this.uPreferencesManager.getUserLayoutManager().addLayoutEventListener(this.channelManager);
            this.p_rendering_lock = new Object();
        }
        this.renderState(req, res, this.channelManager, this.localeManager, this.uPreferencesManager, this.p_rendering_lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderState(HttpServletRequest req, HttpServletResponse res, ChannelManager channelManager, LocaleManager localeManager, IUserPreferencesManager upm, Object rendering_lock) throws PortalException {
        this.uPreferencesManager = upm;
        if (!this.processWorkerDispatch(req, res, channelManager)) {
            Object object = rendering_lock;
            synchronized (object) {
                try {
                    this.uPreferencesManager.processUserPreferencesParameters(req);
                    IUserLayoutNodeDescription rElement = null;
                    UPFileSpec upfs = new UPFileSpec(req);
                    String rootNodeId = upfs.getMethodNodeId();
                    if (rootNodeId == null) {
                        rootNodeId = USER_LAYOUT_ROOT_NODE;
                    }
                    channelManager.setLocaleManager(localeManager);
                    String newRootNodeId = req.getParameter("uP_detach_target");
                    UPFileSpec uPElement = new UPFileSpec(PortalSessionManager.INTERNAL_TAG_VALUE, 0, rootNodeId, null, null);
                    if (newRootNodeId != null) {
                        uPElement.setMethodNodeId(newRootNodeId);
                    }
                    IUserLayoutManager ulm = this.uPreferencesManager.getUserLayoutManager();
                    try {
                        this.processUserLayoutParameters(req, channelManager);
                    }
                    catch (PortalException pe) {
                        LogService.log(LogService.ERROR, "UserInstance.renderState(): processUserLayoutParameters() threw an exception - " + pe.getMessage());
                    }
                    channelManager.startRenderingCycle(req, res, uPElement);
                    UserPreferences userPreferences = this.uPreferencesManager.getUserPreferences();
                    StructureStylesheetDescription ssd = this.uPreferencesManager.getStructureStylesheetDescription();
                    ThemeStylesheetDescription tsd = this.uPreferencesManager.getThemeStylesheetDescription();
                    if (newRootNodeId != null && !newRootNodeId.equals(rootNodeId)) {
                        try {
                            rElement = ulm.getNode(newRootNodeId);
                        }
                        catch (PortalException e) {
                            rElement = null;
                        }
                        if (rElement != null) {
                            String[] skipParams = new String[]{"uP_detach_target"};
                            try {
                                URLUtil.redirect(req, res, newRootNodeId, true, skipParams, CHARACTER_SET);
                            }
                            catch (PortalException pe) {
                                StringBuffer sb = new StringBuffer(128);
                                sb.append("UserInstance::renderState() : ");
                                sb.append("PortalException occurred while ");
                                sb.append("redirecting.");
                                sb.append(pe.toString());
                                LogService.log(LogService.ERROR, sb.toString(), pe);
                            }
                            return;
                        }
                    }
                    if (rootNodeId != null) {
                        try {
                            rElement = ulm.getNode(rootNodeId);
                        }
                        catch (PortalException e) {
                            rElement = null;
                        }
                    }
                    if (rElement == null) {
                        rootNodeId = USER_LAYOUT_ROOT_NODE;
                    }
                    uPElement.setMethodNodeId(rootNodeId);
                    channelManager.setUPElement(uPElement);
                    res.setHeader("pragma", "no-cache");
                    res.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate");
                    res.setDateHeader("Expires", 0L);
                    res.setContentType(tsd.getMimeType() + "; charset=" + CHARACTER_SET);
                    PrintWriter out = res.getWriter();
                    BaseMarkupSerializer markupSerializer = mediaM.getSerializerByName(tsd.getSerializerName(), out);
                    markupSerializer.asContentHandler();
                    boolean ccaching = CHARACTER_CACHE_ENABLED && markupSerializer instanceof CachingSerializer;
                    channelManager.setCharacterCaching(ccaching);
                    CharacterCachingChannelIncorporationFilter cif = new CharacterCachingChannelIncorporationFilter(markupSerializer, channelManager, CACHE_ENABLED && CHARACTER_CACHE_ENABLED);
                    String cacheKey = null;
                    boolean output_produced = false;
                    if (CACHE_ENABLED) {
                        SAX2BufferImpl cachedBuffer;
                        CharacterCacheEntry cCache;
                        boolean ccache_exists = false;
                        cacheKey = this.constructCacheKey(this.getPerson(), rootNodeId);
                        if (ccaching && (cCache = (CharacterCacheEntry)this.systemCharacterCache.get(cacheKey)) != null && cCache.channelIds != null && cCache.systemBuffers != null) {
                            ccache_exists = true;
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : retreived transformation character block cache for a key \"" + cacheKey + "\"");
                            for (int i = 0; i < cCache.channelIds.size(); ++i) {
                                String channelSubscribeId = (String)cCache.channelIds.get(i);
                                if (channelSubscribeId != null) {
                                    try {
                                        channelManager.startChannelRendering(channelSubscribeId);
                                    }
                                    catch (PortalException e) {
                                        LogService.log(LogService.ERROR, "UserInstance::renderState() : unable to start rendering channel (subscribeId=\"" + channelSubscribeId + "\", user=" + this.person.getID() + " layoutId=" + this.uPreferencesManager.getCurrentProfile().getLayoutId() + e.getRecordedException().toString());
                                    }
                                    continue;
                                }
                                LogService.log(LogService.ERROR, "UserInstance::renderState() : channel entry " + Integer.toString(i) + " in character cache is invalid (user=" + this.person.getID() + ")!");
                            }
                            channelManager.commitToRenderingChannelSet();
                            int ccsize = cCache.systemBuffers.size();
                            if (cCache.channelIds.size() != ccsize - 1) {
                                LogService.log(LogService.ERROR, "UserInstance::renderState() : channelIds character cache has invalid size !");
                                LogService.log(LogService.ERROR, "UserInstance::renderState() : ccache cotnains " + cCache.systemBuffers.size() + " system buffers and " + cCache.channelIds.size() + " channel entries");
                            }
                            CachingSerializer cSerializer = (CachingSerializer)((Object)markupSerializer);
                            cSerializer.setDocumentStarted(true);
                            for (int sb = 0; sb < ccsize - 1; ++sb) {
                                cSerializer.printRawCharacters((String)cCache.systemBuffers.get(sb));
                                String channelSubscribeId = (String)cCache.channelIds.get(sb);
                                channelManager.outputChannel(channelSubscribeId, markupSerializer);
                            }
                            cSerializer.printRawCharacters((String)cCache.systemBuffers.get(ccsize - 1));
                            cSerializer.flush();
                            output_produced = true;
                        }
                        if (!(ccaching && ccache_exists || (cachedBuffer = (SAX2BufferImpl)this.systemCache.get(cacheKey)) == null)) {
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : retreived XSLT transformation cache for a key \"" + cacheKey + "\"");
                            ChannelRenderingBuffer crb = new ChannelRenderingBuffer(cachedBuffer, channelManager, ccaching);
                            cif.setParent(crb);
                            crb.setOutputAtDocumentEnd(true);
                            cachedBuffer.outputBuffer(crb);
                            output_produced = true;
                        }
                    }
                    if (!output_produced) {
                        boolean detachMode;
                        TransformerHandler ssth = XSLT.getTransformerHandler(ResourceLoader.getResourceAsURL(class$org$jasig$portal$UserInstance == null ? (class$org$jasig$portal$UserInstance = UserInstance.class$("org.jasig.portal.UserInstance")) : class$org$jasig$portal$UserInstance, ssd.getStylesheetURI()).toString());
                        TransformerHandler tsth = XSLT.getTransformerHandler(tsd.getStylesheetURI(), localeManager.getLocales(), this);
                        Transformer sst = ssth.getTransformer();
                        Transformer tst = tsth.getTransformer();
                        Transformer emptyt = TransformerFactory.newInstance().newTransformer();
                        ChannelRenderingBuffer crb = new ChannelRenderingBuffer(channelManager, ccaching);
                        ssth.setResult(new SAXResult(crb));
                        sst.setParameter("baseActionURL", uPElement.getUPFile());
                        UPFileSpec uPIdempotentElement = new UPFileSpec(uPElement);
                        uPIdempotentElement.setTagId("idempotent");
                        sst.setParameter("baseIdempotentActionURL", uPElement.getUPFile());
                        Hashtable supTable = userPreferences.getStructureStylesheetUserPreferences().getParameterValues();
                        Enumeration e = supTable.keys();
                        while (e.hasMoreElements()) {
                            String pName = (String)e.nextElement();
                            String pValue = (String)supTable.get(pName);
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : setting sparam \"" + pName + "\"=\"" + pValue + "\".");
                            sst.setParameter(pName, pValue);
                        }
                        StructureAttributesIncorporationFilter saif = new StructureAttributesIncorporationFilter(ssth, userPreferences.getStructureStylesheetUserPreferences());
                        StringWriter dbwr1 = null;
                        OutputFormat outputFormat = null;
                        if (logXMLBeforeStructureTransformation) {
                            dbwr1 = new StringWriter();
                            outputFormat = new OutputFormat();
                            outputFormat.setIndenting(true);
                            XMLSerializer dbser1 = new XMLSerializer(dbwr1, outputFormat);
                            SAX2DuplicatingFilterImpl dupl1 = new SAX2DuplicatingFilterImpl(ssth, dbser1);
                            dupl1.setParent(saif);
                        }
                        boolean bl = detachMode = !rootNodeId.equals(USER_LAYOUT_ROOT_NODE);
                        if (detachMode) {
                            saif.startDocument();
                            saif.startElement("", "layout_fragment", "layout_fragment", new AttributesImpl());
                            if (rElement == null) {
                                ulm.getUserLayout(new ChannelSAXStreamFilter(saif));
                            } else {
                                ulm.getUserLayout(rElement.getId(), new ChannelSAXStreamFilter(saif));
                            }
                            saif.endElement("", "layout_fragment", "layout_fragment");
                            saif.endDocument();
                        } else if (rElement == null) {
                            ulm.getUserLayout(saif);
                        } else {
                            ulm.getUserLayout(rElement.getId(), saif);
                        }
                        if (logXMLBeforeStructureTransformation) {
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : XML incoming to the structure transformation :\n\n" + dbwr1.toString() + "\n\n");
                        }
                        tst.setParameter("baseActionURL", uPElement.getUPFile());
                        tst.setParameter("baseIdempotentActionURL", uPIdempotentElement.getUPFile());
                        Hashtable tupTable = userPreferences.getThemeStylesheetUserPreferences().getParameterValues();
                        Enumeration e2 = tupTable.keys();
                        while (e2.hasMoreElements()) {
                            String pName = (String)e2.nextElement();
                            String pValue = (String)tupTable.get(pName);
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : setting tparam \"" + pName + "\"=\"" + pValue + "\".");
                            tst.setParameter(pName, pValue);
                        }
                        ThemeAttributesIncorporationFilter taif = new ThemeAttributesIncorporationFilter(crb, userPreferences.getThemeStylesheetUserPreferences());
                        taif.setAllHandlers(tsth);
                        StringWriter dbwr2 = null;
                        if (logXMLBeforeThemeTransformation) {
                            dbwr2 = new StringWriter();
                            XMLSerializer dbser2 = new XMLSerializer(dbwr2, outputFormat);
                            SAX2DuplicatingFilterImpl dupl2 = new SAX2DuplicatingFilterImpl(tsth, dbser2);
                            dupl2.setParent(taif);
                        }
                        if (CACHE_ENABLED && !ccaching) {
                            SAX2BufferImpl newCache = new SAX2BufferImpl();
                            tsth.setResult(new SAXResult(newCache));
                            cif.setParent(newCache);
                            this.systemCache.put(cacheKey, newCache);
                            newCache.setOutputAtDocumentEnd(true);
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : recorded transformation cache with key \"" + cacheKey + "\"");
                        } else {
                            tsth.setResult(new SAXResult(cif));
                        }
                        crb.stopBuffering();
                        crb.outputBuffer();
                        crb.clearBuffer();
                        if (logXMLBeforeThemeTransformation) {
                            LogService.log(LogService.DEBUG, "UserInstance::renderState() : XML incoming to the theme transformation :\n\n" + dbwr2.toString() + "\n\n");
                        }
                        if (CACHE_ENABLED && ccaching) {
                            CharacterCacheEntry ce = new CharacterCacheEntry();
                            ce.systemBuffers = cif.getSystemCCacheBlocks();
                            ce.channelIds = cif.getChannelIdBlocks();
                            if (ce.systemBuffers == null || ce.channelIds == null) {
                                LogService.log(LogService.ERROR, "UserInstance::renderState() : CharacterCachingChannelIncorporationFilter returned invalid cache entries!");
                            } else {
                                this.systemCharacterCache.put(cacheKey, ce);
                                LogService.log(LogService.DEBUG, "UserInstance::renderState() : recorded transformation character block cache with key \"" + cacheKey + "\"");
                            }
                        }
                    }
                    channelManager.finishedRenderingCycle();
                }
                catch (PortalException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PortalException(e);
                }
            }
        }
    }

    Object getRenderingLock(String sessionId) {
        if (this.p_rendering_lock == null) {
            this.p_rendering_lock = new Object();
        }
        return this.p_rendering_lock;
    }

    private String constructCacheKey(IPerson person, String rootNodeId) throws PortalException {
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append(person.getID()).append(",");
        sbKey.append(rootNodeId).append(",");
        sbKey.append(this.uPreferencesManager.getUserPreferences().getCacheKey());
        sbKey.append(this.uPreferencesManager.getUserLayoutManager().getCacheKey());
        return sbKey.toString();
    }

    public IPerson getPerson() {
        return this.person;
    }

    public void valueUnbound(HttpSessionBindingEvent bindingEvent) {
        if (this.channelManager != null) {
            this.channelManager.finishedSession();
        }
        if (this.uPreferencesManager != null) {
            this.uPreferencesManager.finishedSession(bindingEvent);
        }
        StatsRecorder.recordSessionDestroyed(this.person);
        GroupService.finishedSession(this.person);
    }

    public void valueBound(HttpSessionBindingEvent bindingEvent) {
        StatsRecorder.recordSessionCreated(this.person);
    }

    private synchronized void processUserLayoutParameters(HttpServletRequest req, ChannelManager channelManager) throws PortalException {
        try {
            String param;
            IUserLayoutNodeDescription nodeDesc;
            String value;
            String[] values1;
            String[] values;
            IUserLayoutManager ulm = this.uPreferencesManager.getUserLayoutManager();
            UserPreferences userPrefs = this.uPreferencesManager.getUserPreferences();
            ThemeStylesheetUserPreferences themePrefs = userPrefs.getThemeStylesheetUserPreferences();
            if (this.person.getSecurityContext().isAuthenticated()) {
                themePrefs.putParameterValue("authenticated", "true");
                String userName = this.person.getFullName();
                if (userName != null && userName.trim().length() > 0) {
                    themePrefs.putParameterValue("userName", userName);
                }
                try {
                    if (ChannelStaticData.getAuthorizationPrincipal(this.person).canPublish()) {
                        themePrefs.putParameterValue("channelManager", "true");
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
            }
            if ((values = req.getParameterValues("uP_help_target")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    channelManager.passPortalEvent(values[i], new PortalEvent(4));
                }
            }
            if ((values = req.getParameterValues("uP_about_target")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    channelManager.passPortalEvent(values[i], new PortalEvent(5));
                }
            }
            if ((values = req.getParameterValues("uP_edit_target")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    channelManager.passPortalEvent(values[i], new PortalEvent(3));
                }
            }
            if ((values = req.getParameterValues("uP_detach_target")) != null) {
                channelManager.passPortalEvent(values[0], new PortalEvent(6));
            }
            if ((values = req.getParameterValues("uP_request_move_targets")) != null) {
                if (values[0].trim().length() == 0) {
                    values[0] = null;
                }
                ulm.markMoveTargets(values[0]);
            } else {
                ulm.markMoveTargets(null);
            }
            values = req.getParameterValues("uP_request_add_targets");
            if (values != null) {
                String contentPublishId;
                int nodeType = values[0].equals("folder") ? 2 : 1;
                IUserLayoutNodeDescription nodeDesc2 = ulm.createNodeDescription(nodeType);
                nodeDesc2.setName("Unnamed");
                if (nodeType == 1 && (values1 = req.getParameterValues("contentPublishID")) != null && (contentPublishId = values1[0].trim()).length() > 0) {
                    ((IUserLayoutChannelDescription)nodeDesc2).setChannelPublishId(contentPublishId);
                    themePrefs.putParameterValue("contentPublishID", contentPublishId);
                }
                this.newNodeDescription = nodeDesc2;
                ulm.markAddTargets(this.newNodeDescription);
            } else {
                ulm.markAddTargets(null);
            }
            values = req.getParameterValues("uP_add_target");
            if (values != null) {
                String[] values2;
                value = null;
                int nodeType = values[0].equals("folder") ? 2 : 1;
                values1 = req.getParameterValues("targetNextID");
                if (values1 != null && values1.length > 0) {
                    value = values1[0];
                }
                if ((values2 = req.getParameterValues("targetParentID")) != null && this.newNodeDescription != null) {
                    if (CommonUtils.nvl(value).trim().length() == 0) {
                        value = null;
                    }
                    ulm.addNode(this.newNodeDescription, values2[0], value);
                }
                this.newNodeDescription = null;
            }
            if ((values = req.getParameterValues("uP_move_target")) != null) {
                String[] values2;
                value = null;
                values1 = req.getParameterValues("targetNextID");
                if (values1 != null && values1.length > 0) {
                    value = values1[0];
                }
                if ((values2 = req.getParameterValues("targetParentID")) != null) {
                    if (CommonUtils.nvl(value).trim().length() == 0) {
                        value = null;
                    }
                    ulm.moveNode(values[0], values2[0], value);
                }
            }
            if ((values = req.getParameterValues("uP_rename_target")) != null && (values1 = req.getParameterValues("uP_target_name")) != null && (nodeDesc = ulm.getNode(values[0])) != null) {
                String oldName = nodeDesc.getName();
                nodeDesc.setName(values1[0]);
                if (!ulm.updateNode(nodeDesc)) {
                    nodeDesc.setName(oldName);
                }
            }
            if ((values = req.getParameterValues("uP_remove_target")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    ulm.deleteNode(values[i]);
                }
            }
            if ((param = req.getParameter("uP_cancel_targets")) != null && param.equals("true")) {
                ulm.markAddTargets(null);
                ulm.markMoveTargets(null);
                this.newNodeDescription = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalException(e);
        }
    }

    protected boolean processWorkerDispatch(HttpServletRequest req, HttpServletResponse res, ChannelManager cm) throws PortalException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            try {
                UPFileSpec upfs = new UPFileSpec(req);
                if (upfs.getMethod() != null && upfs.getMethod().equals("worker")) {
                    block16: {
                        String workerName = upfs.getMethodNodeId();
                        if (workerName != null) {
                            String dispatchClassName;
                            if (workerProperties == null) {
                                try {
                                    workerProperties = ResourceLoader.getResourceAsProperties(class$org$jasig$portal$UserInstance == null ? (class$org$jasig$portal$UserInstance = UserInstance.class$("org.jasig.portal.UserInstance")) : class$org$jasig$portal$UserInstance, WORKER_PROPERTIES_FILE_NAME);
                                }
                                catch (IOException ioe) {
                                    LogService.log(LogService.ERROR, "UserInstance::processWorkerDispatch() : Unable to load worker.properties file. " + ioe);
                                }
                                CarResources cRes = CarResources.getInstance();
                                cRes.getWorkers(workerProperties);
                            }
                            if ((dispatchClassName = workerProperties.getProperty(workerName)) == null) {
                                throw new PortalException("UserInstance::processWorkerDispatch() : Unable to find processing class for the worker type \"" + workerName + "\". Please check worker.properties");
                            }
                            try {
                                Object obj = CarResources.getInstance().getClassLoader().loadClass(dispatchClassName).newInstance();
                                IWorkerRequestProcessor wrp = (IWorkerRequestProcessor)obj;
                                try {
                                    wrp.processWorkerDispatch(new PortalControlStructures(req, res, cm, this.uPreferencesManager));
                                    break block16;
                                }
                                catch (PortalException pe) {
                                    throw pe;
                                }
                                catch (RuntimeException re) {
                                    throw new PortalException(re);
                                }
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new PortalException("UserInstance::processWorkerDispatch() : Unable to find processing class (\"" + dispatchClassName + "\") for the worker type \"" + workerName + "\". Please check worker.properties", (Exception)cnfe);
                            }
                            catch (InstantiationException ie) {
                                throw new PortalException("UserInstance::processWorkerDispatch() : Unable to instantiate processing class (\"" + dispatchClassName + "\") for the worker type \"" + workerName + "\". Please check worker.properties", (Exception)ie);
                            }
                            catch (IllegalAccessException iae) {
                                throw new PortalException("UserInstance::processWorkerDispatch() : Unable to access processing class (\"" + dispatchClassName + "\") for the worker type \"" + workerName + "\". Please check worker.properties", (Exception)iae);
                            }
                        }
                        throw new PortalException("UserInstance::processWorkerDispatch() : Unable to determine worker type.  uPFile=\"" + upfs.getUPFile() + "\".");
                    }
                    return true;
                }
                return false;
            }
            catch (IndexOutOfBoundsException iobe) {
                return false;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CACHE_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.cache_enabled");
        SYSTEM_XSLT_CACHE_MIN_SIZE = PropertiesManager.getPropertyAsInt("org.jasig.portal.UserInstance.system_xslt_cache_min_size");
        SYSTEM_CHARACTER_BLOCK_CACHE_MIN_SIZE = PropertiesManager.getPropertyAsInt("org.jasig.portal.UserInstance.system_character_block_cache_min_size");
        CHARACTER_CACHE_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.character_cache_enabled");
    }
}

