/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Enumeration;
import java.util.HashSet;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserProfile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UserPreferences {
    protected UserProfile profile;
    protected StructureStylesheetUserPreferences fsup;
    protected ThemeStylesheetUserPreferences ssup;

    public UserPreferences(UserPreferences up) {
        this.fsup = new StructureStylesheetUserPreferences(up.getStructureStylesheetUserPreferences());
        this.ssup = new ThemeStylesheetUserPreferences(up.getThemeStylesheetUserPreferences());
        this.profile = up.getProfile();
    }

    public void setProfile(UserProfile p) {
        this.profile = p;
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public UserPreferences(UserProfile p) {
        this.profile = p;
    }

    public void setStructureStylesheetUserPreferences(StructureStylesheetUserPreferences up) {
        this.fsup = up;
    }

    public void setThemeStylesheetUserPreferences(ThemeStylesheetUserPreferences up) {
        this.ssup = up;
    }

    public StructureStylesheetUserPreferences getStructureStylesheetUserPreferences() {
        return this.fsup;
    }

    public ThemeStylesheetUserPreferences getThemeStylesheetUserPreferences() {
        return this.ssup;
    }

    public void synchronizeWithUserLayoutXML(Document uLayoutXML) throws PortalException {
        String chID;
        NodeList channelNodes = uLayoutXML.getElementsByTagName("channel");
        HashSet<String> channelSet = new HashSet<String>();
        for (int i = 0; i < channelNodes.getLength(); ++i) {
            Element el = (Element)channelNodes.item(i);
            if (el == null) continue;
            String channelSubscribeId = el.getAttribute("ID");
            if (!this.fsup.hasChannel(channelSubscribeId)) {
                this.fsup.addChannel(channelSubscribeId);
            }
            if (!this.ssup.hasChannel(channelSubscribeId)) {
                this.ssup.addChannel(channelSubscribeId);
            }
            channelSet.add(channelSubscribeId);
        }
        NodeList folderNodes = uLayoutXML.getElementsByTagName("folder");
        HashSet<String> folderSet = new HashSet<String>();
        for (int i = 0; i < folderNodes.getLength(); ++i) {
            Element el = (Element)folderNodes.item(i);
            if (el == null) continue;
            String caID = el.getAttribute("ID");
            if (!this.fsup.hasFolder(caID)) {
                this.fsup.addFolder(caID);
            }
            folderSet.add(caID);
        }
        Enumeration e = this.fsup.getChannels();
        while (e.hasMoreElements()) {
            chID = (String)e.nextElement();
            if (channelSet.contains(chID)) continue;
            this.fsup.removeChannel(chID);
        }
        e = this.fsup.getFolders();
        while (e.hasMoreElements()) {
            String caID = (String)e.nextElement();
            if (folderSet.contains(caID)) continue;
            this.fsup.removeFolder(caID);
        }
        e = this.ssup.getChannels();
        while (e.hasMoreElements()) {
            chID = (String)e.nextElement();
            if (channelSet.contains(chID)) continue;
            this.ssup.removeChannel(chID);
        }
    }

    public String getCacheKey() {
        String key = null;
        key = this.profile.isSystemProfile() ? "system " + Integer.toString(this.profile.getProfileId()) : Integer.toString(this.profile.getProfileId());
        key = key.concat(this.fsup.getCacheKey());
        key = key.concat(this.ssup.getCacheKey());
        return key;
    }
}

