/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.UserPreferences;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.jasig.portal.ChannelRegistryManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.StructureAttributesIncorporationFilter;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channels.UserPreferences.BaseState;
import org.jasig.portal.channels.UserPreferences.CUserPreferences;
import org.jasig.portal.i18n.LocaleAwareXSLT;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.UserLayoutChannelDescription;
import org.jasig.portal.layout.UserLayoutFolderDescription;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class TabColumnPrefsState
extends BaseState {
    protected ChannelStaticData staticData;
    protected ChannelRuntimeData runtimeData;
    private static final String sslLocation = "/org/jasig/portal/channels/CUserPreferences/tab-column/tab-column.ssl";
    private IUserLayoutManager ulm;
    private PortalControlStructures pcs;
    private UserPreferences userPrefs;
    private UserProfile editedUserProfile;
    private static IUserLayoutStore ulStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    private StylesheetSet set;
    private String action = "none";
    private String activeTab = "none";
    private String elementID = "none";
    protected static String BLANK_TAB_NAME = "My Tab";
    protected static String SKINS_PATH = "media/org/jasig/portal/layout/tab-column/nested-tables";
    private String errorMessage = "Nothing is wrong!";
    private static final String errorMessageSetActiveTab = "Problem trying to set the active tab";
    private static final String errorMessageRenameTab = "Problem trying to rename tab";
    private static final String errorMessageMoveTab = "Problem trying to move the tab";
    private static final String errorMessageAddTab = "Problem trying to add a new tab";
    private static final String errorMessageDeleteTab = "Problem trying to delete tab";
    private static final String errorMessageLockTab = "Problem trying to lock tab";
    private static final String errorMessageUnlockTab = "Problem trying to unlock tab";
    private static final String errorMessageChangeColumnWidths = "Problem changing column widths";
    private static final String errorMessageMoveColumn = "Problem trying to move column";
    private static final String errorMessageNewColumn = "Problem trying to add a new column";
    private static final String errorMessageDeleteColumn = "Problem trying to delete column";
    private static final String errorMessageNewChannel = "Problem trying to add a new channel";
    private static final String errorMessageModChannelParams = "Problem trying to modify channel parameters";
    private static final String errorMessageMoveChannel = "Problem trying to move channel";
    private static final String errorMessageDeleteChannel = "Problem trying to delete channel";

    public TabColumnPrefsState() throws PortalException {
        this.internalState = new DefaultState(this);
        this.set = new StylesheetSet(ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation));
    }

    public TabColumnPrefsState(CUserPreferences context) throws PortalException {
        super(context);
        this.internalState = new DefaultState(this);
        this.set = new StylesheetSet(ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation));
    }

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;
        this.internalState.setStaticData(sd);
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        String action = rd.getParameter("action");
        if (action != null) {
            if (action.equals("newChannel")) {
                if (!(this.internalState instanceof NewChannelState)) {
                    this.internalState = new NewChannelState(this);
                    this.internalState.setStaticData(this.staticData);
                }
            } else if (action.equals("manageSkins")) {
                if (!(this.internalState instanceof SelectSkinsState)) {
                    this.internalState = new SelectSkinsState(this);
                    this.internalState.setStaticData(this.staticData);
                }
            } else if (action.equals("resetLayout")) {
                if (!(this.internalState instanceof ResetLayoutState)) {
                    this.internalState = new ResetLayoutState(this);
                    this.internalState.setStaticData(this.staticData);
                }
            } else if (action.equals("managePreferences")) {
                this.internalState = new DefaultState(this);
                this.internalState.setStaticData(this.staticData);
            }
        }
        this.internalState.setRuntimeData(rd);
        try {
            this.editedUserProfile = this.context.getEditedUserProfile();
            this.ulm = this.getUserLayoutManager();
            this.userPrefs = this.context.getUserPreferencesFromStore(this.editedUserProfile);
        }
        catch (Exception e) {
            throw new GeneralRenderingException(e.getMessage());
        }
    }

    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        this.pcs = pcs;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        if (this.internalState != null) {
            this.internalState.renderXML(out);
        } else {
            LogService.log(LogService.ERROR, "TabColumnPrefsState::renderXML() : No internal state!");
        }
    }

    private final IUserLayoutManager getUserLayoutManager() throws Exception {
        IUserPreferencesManager upm = this.context.getUserPreferencesManager();
        IUserLayoutManager lm = null;
        lm = this.modifyingCurrentUserLayout() ? upm.getUserLayoutManager() : UserLayoutManagerFactory.getUserLayoutManager(upm.getPerson(), this.context.getCurrentUserPreferences().getProfile());
        return lm;
    }

    private final String getActiveTab() {
        String activeTab = "none";
        try {
            UserPreferences userPrefsFromStore = this.context.getUserPreferencesFromStore(this.context.getCurrentUserPreferences().getProfile());
            activeTab = userPrefsFromStore.getStructureStylesheetUserPreferences().getParameterValue("activeTab");
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "TabColumnPrefsState::getAcctiveTab : Unable to retrieve active tab.");
        }
        return activeTab;
    }

    private final void setActiveTab(String activeTab) throws Exception {
        StructureStylesheetUserPreferences ssup = this.userPrefs.getStructureStylesheetUserPreferences();
        ssup.putParameterValue("activeTab", activeTab);
        int profileId = this.editedUserProfile.getProfileId();
        ulStore.setStructureStylesheetUserPreferences(this.staticData.getPerson(), profileId, ssup);
    }

    private final void renameTab(String tabId, String tabName) throws PortalException {
        IUserLayoutFolderDescription tab = (IUserLayoutFolderDescription)this.ulm.getNode(tabId);
        if (this.ulm.canUpdateNode(this.ulm.getNode(tabId))) {
            if (tabName == null || tabName.trim().length() == 0) {
                tab.setName(BLANK_TAB_NAME);
            } else {
                tab.setName(tabName);
            }
        } else {
            throw new PortalException("Attempt to rename immutable tab " + tabId + "has failed");
        }
        this.ulm.updateNode(tab);
    }

    private final void moveTab(String sourceTabId, String method, String destinationTabId) throws PortalException {
        String rootNodeId = this.ulm.getParentId(sourceTabId);
        if (this.ulm.canMoveNode(sourceTabId, rootNodeId, destinationTabId)) {
            if (method.equals("insertBefore")) {
                this.ulm.moveNode(sourceTabId, rootNodeId, destinationTabId);
            } else {
                this.ulm.moveNode(sourceTabId, rootNodeId, null);
            }
        }
    }

    private final void addTab(String tabName, String method, String destinationTabId) throws PortalException {
        IUserLayoutFolderDescription newTab = this.createFolder(tabName);
        if (tabName == null || tabName.trim().length() == 0) {
            newTab.setName(BLANK_TAB_NAME);
        }
        String siblingId = null;
        if (method.equals("insertBefore")) {
            siblingId = destinationTabId;
        }
        this.ulm.addNode(newTab, this.ulm.getRootFolderId(), siblingId);
        IUserLayoutFolderDescription newColumn = this.createFolder("Column");
        this.ulm.addNode(newColumn, newTab.getId(), null);
    }

    private final void addColumn(String method, String destinationElementId) throws Exception {
        IUserLayoutFolderDescription newColumn = this.createFolder("Column");
        if (this.isTab(destinationElementId)) {
            this.ulm.addNode(newColumn, destinationElementId, null);
        } else if (this.isColumn(destinationElementId)) {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationElementId;
            }
            this.ulm.addNode(newColumn, this.ulm.getParentId(destinationElementId), siblingId);
        }
    }

    private final void changeColumnWidths(HashMap columnWidths) throws Exception {
        StructureStylesheetUserPreferences ssup = this.userPrefs.getStructureStylesheetUserPreferences();
        Set sColWidths = columnWidths.keySet();
        Iterator iterator = sColWidths.iterator();
        while (iterator.hasNext()) {
            String folderId = (String)iterator.next();
            String newWidth = (String)columnWidths.get(folderId);
            boolean widthIsValid = true;
            try {
                Integer.parseInt(newWidth.endsWith("%") ? newWidth.substring(0, newWidth.indexOf("%")) : newWidth);
            }
            catch (NumberFormatException nfe) {
                widthIsValid = false;
            }
            if (widthIsValid) {
                ssup.setFolderAttributeValue(folderId, "width", newWidth);
                continue;
            }
            LogService.log(LogService.DEBUG, "User id " + this.staticData.getPerson().getID() + " entered invalid column width: " + newWidth);
        }
        this.saveUserPreferences();
    }

    private final void moveColumn(String sourceId, String method, String destinationId) throws PortalException {
        String siblingId = null;
        if (method.equals("insertBefore")) {
            siblingId = destinationId;
        }
        this.ulm.moveNode(sourceId, this.ulm.getParentId(destinationId), siblingId);
    }

    private final void moveChannel(String sourceChannelSubscribeId, String method, String destinationElementId) throws PortalException {
        if (this.isTab(destinationElementId)) {
            IUserLayoutNodeDescription newColumn = this.ulm.addNode(this.createFolder("Column"), destinationElementId, null);
            this.ulm.moveNode(sourceChannelSubscribeId, newColumn.getId(), null);
        } else if (this.isColumn(destinationElementId)) {
            this.ulm.moveNode(sourceChannelSubscribeId, destinationElementId, null);
        } else {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationElementId;
            }
            this.ulm.moveNode(sourceChannelSubscribeId, this.ulm.getParentId(destinationElementId), siblingId);
        }
    }

    private final void addChannel(Element newChannel, String position, String destinationElementId) throws PortalException {
        UserLayoutChannelDescription channel = new UserLayoutChannelDescription(newChannel);
        if (this.isTab(destinationElementId)) {
            IUserLayoutNodeDescription newColumn = this.ulm.addNode(this.createFolder("Column"), destinationElementId, null);
            this.ulm.addNode(channel, newColumn.getId(), null);
        } else if (this.isColumn(destinationElementId)) {
            this.ulm.addNode(channel, destinationElementId, null);
        } else {
            String siblingId = null;
            if (position.equals("before")) {
                siblingId = destinationElementId;
            }
            this.ulm.addNode(channel, this.ulm.getParentId(destinationElementId), siblingId);
        }
        this.pcs.getChannelManager().instantiateChannel(channel.getId());
        this.ulm.saveUserLayout();
    }

    private final void addChannel(String selectedChannelSubscribeId, String position, String destinationElementId) throws Exception {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry(this.staticData.getPerson());
        Element newChannel = channelRegistry.getElementById(selectedChannelSubscribeId);
        this.addChannel(newChannel, position, destinationElementId);
    }

    private final void deleteChannel(String channelSubscribeId) throws Exception {
        this.pcs.getChannelManager().removeChannel(channelSubscribeId);
        this.deleteElement(channelSubscribeId);
    }

    private final void deleteElement(String elementId) throws Exception {
        this.ulm.deleteNode(elementId);
    }

    private final void updateTabLock(String elementId, boolean locked) throws Exception {
    }

    private final boolean isTab(String folderId) throws PortalException {
        return this.ulm.getRootFolderId().equals(this.ulm.getParentId(folderId));
    }

    private final boolean isColumn(String folderId) throws PortalException {
        return this.isTab(this.ulm.getParentId(folderId));
    }

    private final IUserLayoutFolderDescription createFolder(String name) {
        String id = "tbd";
        UserLayoutFolderDescription folder = new UserLayoutFolderDescription();
        folder.setName(name);
        folder.setId(id);
        folder.setFolderType(0);
        folder.setHidden(false);
        folder.setUnremovable(false);
        folder.setImmutable(false);
        return folder;
    }

    private final List getOverridableChannelParams(String channelPublishId) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry(this.staticData.getPerson());
        Element channel = channelRegistry.getElementById(channelPublishId.startsWith("chan") ? channelPublishId : "chan" + channelPublishId);
        ArrayList<Element> overridableParams = null;
        if (channel != null) {
            overridableParams = new ArrayList<Element>();
            NodeList params = channel.getElementsByTagName("parameter");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                String override = param.getAttribute("override");
                if (override == null || !override.equals("yes")) continue;
                overridableParams.add(param);
            }
        } else {
            throw new PortalException("Channel " + channelPublishId + " is missing from the channel registry");
        }
        return overridableParams;
    }

    private void saveLayout(boolean channelsAdded) throws PortalException {
        this.ulm.saveUserLayout();
    }

    private void saveUserPreferences() throws PortalException {
        this.userPrefs.getStructureStylesheetUserPreferences().putParameterValue("userLayoutRoot", this.staticData.getChannelSubscribeId());
        IUserPreferencesManager upm = this.context.getUserPreferencesManager();
        if (this.modifyingCurrentUserLayout()) {
            upm.setNewUserLayoutAndUserPreferences(null, this.userPrefs);
        } else {
            try {
                ulStore.putUserPreferences(this.staticData.getPerson(), this.userPrefs);
            }
            catch (Exception e) {
                throw new PortalException(e.getMessage(), e);
            }
        }
    }

    private boolean modifyingCurrentUserLayout() throws PortalException {
        return this.context.getUserPreferencesManager().getCurrentProfile().getProfileId() == this.editedUserProfile.getProfileId() && this.context.getUserPreferencesManager().getCurrentProfile().isSystemProfile() == this.editedUserProfile.isSystemProfile();
    }

    protected class ParametersState
    extends BaseState {
        protected TabColumnPrefsState context;
        protected BaseState previousState;
        private List overridableChanParams;
        private Element registryChannel;
        private String position;
        private String destinationElementId;
        private boolean error = false;

        public ParametersState(TabColumnPrefsState context, BaseState previousState, List overridableChanParams, Element registryChannel) {
            this.context = context;
            this.previousState = previousState;
            this.overridableChanParams = overridableChanParams;
            this.registryChannel = registryChannel;
        }

        public ParametersState(TabColumnPrefsState context, BaseState previousState, List overridableChanParams, Element registryChannel, String position, String destinationElementId) {
            this(context, previousState, overridableChanParams, registryChannel);
            this.position = position;
            this.destinationElementId = destinationElementId;
        }

        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            TabColumnPrefsState.this.runtimeData = rd;
            String action = TabColumnPrefsState.this.runtimeData.getParameter("uPTCUP_action");
            if (action != null) {
                if (action.equals("back")) {
                    this.context.setState(this.previousState);
                } else if (action.equals("finished")) {
                    this.applyChanges();
                    this.returnToDefaultState();
                } else if (action.equals("cancel")) {
                    this.returnToDefaultState();
                }
            }
        }

        public void renderXML(ContentHandler out) throws PortalException {
            XSLT xslt = XSLT.getTransformer(this, TabColumnPrefsState.this.runtimeData.getLocales());
            xslt.setXML(this.getParametersDoc());
            xslt.setXSL(TabColumnPrefsState.sslLocation, "parameters", TabColumnPrefsState.this.runtimeData.getBrowserInfo());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("baseActionURL", TabColumnPrefsState.this.runtimeData.getBaseActionURL());
            if (this.error) {
                xslt.setStylesheetParameter("errorMessage", TabColumnPrefsState.this.errorMessage);
            }
            xslt.transform();
        }

        private void returnToDefaultState() throws PortalException {
            TabColumnPrefsState.this.elementID = "none";
            this.position = "none";
            TabColumnPrefsState.this.action = "none";
            DefaultState defaultState = new DefaultState(this.context);
            defaultState.setStaticData(TabColumnPrefsState.this.staticData);
            this.context.setState(defaultState);
        }

        private void applyChanges() {
            try {
                if (this.previousState instanceof NewChannelState) {
                    this.processParams(this.registryChannel);
                    this.context.addChannel(this.registryChannel, this.position, this.destinationElementId);
                } else if (this.previousState instanceof DefaultState) {
                    this.updateParams((IUserLayoutChannelDescription)TabColumnPrefsState.this.ulm.getNode(TabColumnPrefsState.this.elementID));
                }
            }
            catch (Exception e) {
                this.error = true;
                TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageModChannelParams;
            }
        }

        private void updateParams(IUserLayoutChannelDescription cd) throws PortalException {
            Iterator iter = this.overridableChanParams.iterator();
            while (iter.hasNext()) {
                Element parameterE = (Element)iter.next();
                String paramName = parameterE.getAttribute("name");
                String paramValue = TabColumnPrefsState.this.runtimeData.getParameter(paramName);
                cd.setParameterValue(paramName, paramValue);
            }
            TabColumnPrefsState.this.ulm.updateNode(cd);
        }

        private void processParams(Element channel) {
            Iterator iter = this.overridableChanParams.iterator();
            block0: while (iter.hasNext()) {
                Element parameterE = (Element)iter.next();
                String paramName = parameterE.getAttribute("name");
                String paramValue = TabColumnPrefsState.this.runtimeData.getParameter(paramName);
                NodeList params = channel.getElementsByTagName("parameter");
                for (int i = 0; i < params.getLength(); ++i) {
                    Element paramE = (Element)params.item(i);
                    if (!paramE.getAttribute("name").equals(paramName)) continue;
                    paramE.setAttribute("value", paramValue);
                    continue block0;
                }
            }
        }

        private Document getParametersDoc() throws PortalException {
            Document doc = DocumentFactory.getNewDocument();
            Element userPrefParamsE = doc.createElement("userPrefParams");
            if (this.previousState instanceof NewChannelState) {
                userPrefParamsE.appendChild(doc.importNode(this.registryChannel, true));
            } else if (this.previousState instanceof DefaultState) {
                IUserLayoutNodeDescription node = TabColumnPrefsState.this.ulm.getNode(TabColumnPrefsState.this.elementID);
                userPrefParamsE.appendChild(node.getXML(doc));
            }
            Document cpd = ChannelRegistryManager.getCPD(this.registryChannel.getAttribute("typeID"));
            if (cpd != null) {
                userPrefParamsE.appendChild(doc.importNode(cpd.getDocumentElement(), true));
            }
            doc.appendChild(userPrefParamsE);
            return doc;
        }
    }

    protected class NewChannelState
    extends BaseState {
        protected TabColumnPrefsState context;
        private String position = "none";
        private String catID = "top";

        public NewChannelState(TabColumnPrefsState context) {
            this.context = context;
        }

        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            block14: {
                TabColumnPrefsState.this.runtimeData = rd;
                String action = TabColumnPrefsState.this.runtimeData.getParameter("action");
                if (action != null) {
                    if (action.equals("cancel")) {
                        this.returnToDefaultState();
                    } else if (TabColumnPrefsState.this.runtimeData.getParameter("channelMoreInfo") != null) {
                        String selectedChannel = TabColumnPrefsState.this.runtimeData.getParameter("selectedChannel");
                    } else if (TabColumnPrefsState.this.runtimeData.getParameter("addChannel") != null) {
                        String selectedChannel = TabColumnPrefsState.this.runtimeData.getParameter("selectedChannel");
                        if (selectedChannel != null) {
                            try {
                                List overridableChanParams = TabColumnPrefsState.this.getOverridableChannelParams(selectedChannel);
                                if (overridableChanParams.isEmpty()) {
                                    TabColumnPrefsState.this.addChannel(selectedChannel, this.position, TabColumnPrefsState.this.elementID);
                                    this.returnToDefaultState();
                                    break block14;
                                }
                                Document channelRegistry = ChannelRegistryManager.getChannelRegistry(TabColumnPrefsState.this.staticData.getPerson());
                                Element channel = channelRegistry.getElementById(selectedChannel);
                                this.context.internalState = new ParametersState(this.context, this, overridableChanParams, channel, this.position, TabColumnPrefsState.this.elementID);
                                this.context.internalState.setStaticData(TabColumnPrefsState.this.staticData);
                            }
                            catch (Exception e) {
                                TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageNewChannel;
                            }
                        }
                    } else {
                        String selectedCategory;
                        String passedPosition = TabColumnPrefsState.this.runtimeData.getParameter("position");
                        String passedElementID = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                        if (passedPosition != null) {
                            this.position = passedPosition;
                        }
                        if (passedElementID != null) {
                            TabColumnPrefsState.this.elementID = passedElementID;
                        }
                        if ((selectedCategory = TabColumnPrefsState.this.runtimeData.getParameter("selectedCategory")) != null && selectedCategory.trim().length() > 0) {
                            this.catID = selectedCategory;
                        }
                    }
                }
            }
        }

        public void renderXML(ContentHandler out) throws PortalException {
            Document doc = ChannelRegistryManager.getChannelRegistry(TabColumnPrefsState.this.staticData.getPerson());
            XSLT xslt = XSLT.getTransformer(this, TabColumnPrefsState.this.runtimeData.getLocales());
            xslt.setXML(doc);
            xslt.setXSL(TabColumnPrefsState.sslLocation, "newChannel", TabColumnPrefsState.this.runtimeData.getBrowserInfo());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("baseActionURL", TabColumnPrefsState.this.runtimeData.getBaseActionURL());
            xslt.setStylesheetParameter("elementID", TabColumnPrefsState.this.elementID);
            xslt.setStylesheetParameter("position", this.position);
            xslt.setStylesheetParameter("catID", this.catID);
            xslt.setStylesheetParameter("errorMessage", TabColumnPrefsState.this.errorMessage);
            xslt.transform();
        }

        private void returnToDefaultState() throws PortalException {
            TabColumnPrefsState.this.elementID = "none";
            this.position = "none";
            TabColumnPrefsState.this.action = "none";
            DefaultState defaultState = new DefaultState(this.context);
            defaultState.setStaticData(TabColumnPrefsState.this.staticData);
            this.context.setState(defaultState);
        }
    }

    protected class SelectSkinsState
    extends BaseState {
        protected TabColumnPrefsState context;

        public SelectSkinsState(TabColumnPrefsState context) {
            this.context = context;
        }

        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            TabColumnPrefsState.this.runtimeData = rd;
            String action = TabColumnPrefsState.this.runtimeData.getParameter("action");
            if (action != null) {
                if (TabColumnPrefsState.this.runtimeData.getParameter("submitSave") != null) {
                    String skinName = TabColumnPrefsState.this.runtimeData.getParameter("skinName");
                    TabColumnPrefsState.this.userPrefs.getThemeStylesheetUserPreferences().putParameterValue("skin", skinName);
                    TabColumnPrefsState.this.saveUserPreferences();
                } else if (TabColumnPrefsState.this.runtimeData.getParameter("submitCancel") != null) {
                    DefaultState df = new DefaultState(this.context);
                    df.setStaticData(TabColumnPrefsState.this.staticData);
                    this.context.setState(df);
                }
            }
        }

        public void renderXML(ContentHandler out) throws PortalException {
            InputStream xmlStream = PortalSessionManager.getResourceAsStream(SKINS_PATH + "/skinList.xml");
            String currentSkin = TabColumnPrefsState.this.userPrefs.getThemeStylesheetUserPreferences().getParameterValue("skin");
            XSLT xslt = XSLT.getTransformer(this, TabColumnPrefsState.this.runtimeData.getLocales());
            xslt.setXML(xmlStream);
            xslt.setXSL(TabColumnPrefsState.sslLocation, "skinList", TabColumnPrefsState.this.runtimeData.getBrowserInfo());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("skinsPath", SKINS_PATH);
            xslt.setStylesheetParameter("baseActionURL", TabColumnPrefsState.this.runtimeData.getBaseActionURL());
            if (currentSkin != null) {
                xslt.setStylesheetParameter("currentSkin", currentSkin);
            }
            xslt.transform();
        }
    }

    protected class ResetLayoutState
    extends BaseState {
        protected TabColumnPrefsState context;

        public ResetLayoutState(TabColumnPrefsState context) {
            this.context = context;
        }

        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            try {
                TabColumnPrefsState.this.editedUserProfile.setLayoutId(0);
                ulStore.updateUserProfile(TabColumnPrefsState.this.staticData.getPerson(), TabColumnPrefsState.this.editedUserProfile);
                TabColumnPrefsState.this.ulm.loadUserLayout();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            DefaultState df = new DefaultState(this.context);
            df.setStaticData(TabColumnPrefsState.this.staticData);
            this.context.setState(df);
        }
    }

    protected class DefaultState
    extends BaseState {
        private static final boolean printXMLToLog = false;
        protected TabColumnPrefsState context;

        public DefaultState(TabColumnPrefsState context) {
            this.context = context;
        }

        public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
            block75: {
                TabColumnPrefsState.this.runtimeData = rd;
                if (TabColumnPrefsState.this.activeTab.equals("none")) {
                    TabColumnPrefsState.this.activeTab = TabColumnPrefsState.this.getActiveTab();
                }
                TabColumnPrefsState.this.action = TabColumnPrefsState.this.runtimeData.getParameter("action");
                if (TabColumnPrefsState.this.action != null) {
                    if (TabColumnPrefsState.this.action.equals("selectTab")) {
                        TabColumnPrefsState.this.activeTab = TabColumnPrefsState.this.runtimeData.getParameter("activeTab");
                    } else if (TabColumnPrefsState.this.action.equals("setActiveTab")) {
                        try {
                            TabColumnPrefsState.this.setActiveTab(TabColumnPrefsState.this.activeTab);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageSetActiveTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("renameTab")) {
                        try {
                            String tabId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            String tabName = TabColumnPrefsState.this.runtimeData.getParameter("tabName");
                            TabColumnPrefsState.this.renameTab(tabId, tabName);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageRenameTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("moveTab")) {
                        try {
                            String methodAndID = TabColumnPrefsState.this.runtimeData.getParameter("method_ID");
                            if (methodAndID != null) {
                                String sourceTabId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                                int indexOf_ = methodAndID.indexOf("_");
                                String method = methodAndID.substring(0, indexOf_);
                                String destinationTabId = methodAndID.substring(indexOf_ + 1);
                                TabColumnPrefsState.this.moveTab(sourceTabId, method, destinationTabId);
                                break block75;
                            }
                            TabColumnPrefsState.this.action = "selectTab";
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageMoveTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("addTab")) {
                        try {
                            String tabName = TabColumnPrefsState.this.runtimeData.getParameter("tabName");
                            String methodAndID = TabColumnPrefsState.this.runtimeData.getParameter("method_ID");
                            if (methodAndID != null) {
                                int indexOf_ = methodAndID.indexOf("_");
                                String method = methodAndID.substring(0, indexOf_);
                                String destinationTabId = methodAndID.substring(indexOf_ + 1);
                                TabColumnPrefsState.this.addTab(tabName, method, destinationTabId);
                                break block75;
                            }
                            TabColumnPrefsState.this.action = "newTab";
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageAddTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("deleteTab")) {
                        try {
                            String tabId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            TabColumnPrefsState.this.deleteElement(tabId);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageDeleteTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("lockTab")) {
                        try {
                            String tabId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            TabColumnPrefsState.this.updateTabLock(tabId, true);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageLockTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("unlockTab")) {
                        try {
                            String tabId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            TabColumnPrefsState.this.updateTabLock(tabId, false);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageUnlockTab;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("selectColumn")) {
                        TabColumnPrefsState.this.elementID = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                    } else if (TabColumnPrefsState.this.action.equals("columnWidth")) {
                        try {
                            HashMap<String, String> columnWidths = new HashMap<String, String>();
                            Enumeration eParams = TabColumnPrefsState.this.runtimeData.getParameterNames();
                            while (eParams.hasMoreElements()) {
                                String prefix;
                                String param = (String)eParams.nextElement();
                                if (!param.startsWith(prefix = "columnWidth_")) continue;
                                String folderId = param.substring(prefix.length());
                                String newWidth = TabColumnPrefsState.this.runtimeData.getParameter(prefix + folderId);
                                columnWidths.put(folderId, newWidth);
                            }
                            TabColumnPrefsState.this.changeColumnWidths(columnWidths);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageChangeColumnWidths;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("moveColumn")) {
                        String activeTabParam = TabColumnPrefsState.this.runtimeData.getParameter("activeTab");
                        if (activeTabParam != null) {
                            TabColumnPrefsState.this.activeTab = activeTabParam;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("moveColumnHere")) {
                        try {
                            String sourceId = TabColumnPrefsState.this.runtimeData.getParameter("sourceID");
                            if (sourceId != null) {
                                TabColumnPrefsState.this.elementID = sourceId;
                            }
                            String method = TabColumnPrefsState.this.runtimeData.getParameter("method");
                            String destinationId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            TabColumnPrefsState.this.moveColumn(TabColumnPrefsState.this.elementID, method, destinationId);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageMoveColumn;
                        }
                    } else if (TabColumnPrefsState.this.action.equals("newColumn")) {
                        try {
                            String method = TabColumnPrefsState.this.runtimeData.getParameter("method");
                            TabColumnPrefsState.this.elementID = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            String destinationColumnId = TabColumnPrefsState.this.elementID;
                            TabColumnPrefsState.this.addColumn(method, destinationColumnId);
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, e);
                            TabColumnPrefsState.this.action = "error";
                            TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageNewColumn;
                        }
                    } else if (!TabColumnPrefsState.this.action.equals("addColumn")) {
                        if (TabColumnPrefsState.this.action.equals("deleteColumn")) {
                            try {
                                String columnId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                                TabColumnPrefsState.this.deleteElement(columnId);
                            }
                            catch (Exception e) {
                                LogService.log(LogService.ERROR, e);
                                TabColumnPrefsState.this.action = "error";
                                TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageDeleteColumn;
                            }
                        } else if (TabColumnPrefsState.this.action.equals("selectChannel")) {
                            TabColumnPrefsState.this.elementID = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                            String subAction = TabColumnPrefsState.this.runtimeData.getParameter("subAction");
                            if (subAction != null && subAction.equals("modifyChannelParams")) {
                                IUserLayoutChannelDescription layoutChannel = (IUserLayoutChannelDescription)TabColumnPrefsState.this.ulm.getNode(TabColumnPrefsState.this.elementID);
                                String channelPublishId = layoutChannel.getChannelPublishId();
                                Document channelRegistry = ChannelRegistryManager.getChannelRegistry(TabColumnPrefsState.this.staticData.getPerson());
                                Element channel = channelRegistry.getElementById("chan" + channelPublishId);
                                List overridableChanParams = TabColumnPrefsState.this.getOverridableChannelParams(channelPublishId);
                                this.context.internalState = new ParametersState(this.context, this, overridableChanParams, channel);
                                this.context.internalState.setStaticData(TabColumnPrefsState.this.staticData);
                            }
                        } else if (TabColumnPrefsState.this.action.equals("moveChannel")) {
                            String activeTabParam = TabColumnPrefsState.this.runtimeData.getParameter("activeTab");
                            if (activeTabParam != null) {
                                TabColumnPrefsState.this.activeTab = activeTabParam;
                            }
                        } else if (TabColumnPrefsState.this.action.equals("moveChannelHere")) {
                            try {
                                String sourceId = TabColumnPrefsState.this.runtimeData.getParameter("sourceID");
                                if (sourceId != null) {
                                    TabColumnPrefsState.this.elementID = sourceId;
                                }
                                String method = TabColumnPrefsState.this.runtimeData.getParameter("method");
                                String destinationId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                                TabColumnPrefsState.this.moveChannel(TabColumnPrefsState.this.elementID, method, destinationId);
                                TabColumnPrefsState.this.elementID = null;
                            }
                            catch (Exception e) {
                                LogService.log(LogService.ERROR, e);
                                TabColumnPrefsState.this.action = "error";
                                TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageMoveChannel;
                            }
                        } else if (TabColumnPrefsState.this.action.equals("deleteChannel")) {
                            try {
                                String channelSubscribeId = TabColumnPrefsState.this.runtimeData.getParameter("elementID");
                                TabColumnPrefsState.this.deleteChannel(channelSubscribeId);
                            }
                            catch (Exception e) {
                                LogService.log(LogService.ERROR, e);
                                TabColumnPrefsState.this.action = "error";
                                TabColumnPrefsState.this.errorMessage = TabColumnPrefsState.errorMessageDeleteChannel;
                            }
                        } else if (TabColumnPrefsState.this.action.equals("cancel")) {
                            TabColumnPrefsState.this.elementID = "none";
                        }
                    }
                } else {
                    TabColumnPrefsState.this.action = "none";
                }
            }
        }

        public void renderXML(ContentHandler out) throws PortalException {
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                if (tFactory instanceof SAXTransformerFactory) {
                    SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
                    Transformer emptytr = tFactory.newTransformer();
                    String xslURI = TabColumnPrefsState.this.set.getStylesheetURI("default", TabColumnPrefsState.this.runtimeData.getBrowserInfo());
                    xslURI = LocaleAwareXSLT.getLocaleAwareXslUri(xslURI, TabColumnPrefsState.this.runtimeData.getLocales(), this);
                    TransformerHandler th = saxTFactory.newTransformerHandler(XSLT.getTemplates(ResourceLoader.getResourceAsURLString(this.getClass(), xslURI)));
                    th.setResult(new SAXResult(out));
                    Transformer sstr = th.getTransformer();
                    sstr.setParameter("baseActionURL", TabColumnPrefsState.this.runtimeData.getBaseActionURL());
                    sstr.setParameter("activeTab", TabColumnPrefsState.this.activeTab);
                    sstr.setParameter("action", TabColumnPrefsState.this.action);
                    sstr.setParameter("elementID", TabColumnPrefsState.this.elementID != null ? TabColumnPrefsState.this.elementID : "none");
                    sstr.setParameter("errorMessage", TabColumnPrefsState.this.errorMessage);
                    StructureStylesheetUserPreferences ssup = TabColumnPrefsState.this.userPrefs.getStructureStylesheetUserPreferences();
                    StructureAttributesIncorporationFilter saif = new StructureAttributesIncorporationFilter(th, ssup);
                    Object sw = null;
                    Object outputFormat = null;
                    if (TabColumnPrefsState.this.action.equals("newChannel")) {
                        Element channelRegistry = ChannelRegistryManager.getChannelRegistry(TabColumnPrefsState.this.staticData.getPerson()).getDocumentElement();
                        saif.startDocument();
                        TabColumnPrefsState.this.ulm.getUserLayout(new ChannelSAXStreamFilter(saif));
                        emptytr.transform(new DOMSource(channelRegistry), new SAXResult(new ChannelSAXStreamFilter(saif)));
                        saif.endDocument();
                    } else {
                        TabColumnPrefsState.this.ulm.getUserLayout(saif);
                    }
                } else {
                    LogService.log(LogService.ERROR, "TablColumnPrefsState::renderXML() : Unable to obtain SAX Transformer Factory ! Check your TRAX configuration.");
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
                throw new GeneralRenderingException(e.getMessage());
            }
        }
    }
}

