/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.permissionsmanager;

import java.util.HashMap;
import org.jasig.portal.ChannelRegistryManager;
import org.jasig.portal.IPermissible;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PermissibleSubscribeChannels
implements IPermissible {
    protected HashMap activities = new HashMap();
    protected HashMap targets = new HashMap();

    public PermissibleSubscribeChannels() {
        try {
            this.activities.put("SUBSCRIBE", "Subscribe to Channel");
            Document chanregistry = ChannelRegistryManager.getChannelRegistry();
            NodeList chans = chanregistry.getElementsByTagName("channel");
            IEntityNameFinder chanf = EntityNameFinderService.instance().getNameFinder(Class.forName("org.jasig.portal.ChannelDefinition"));
            for (int i = 0; i < chans.getLength(); ++i) {
                Element chan = (Element)chans.item(i);
                String chanID = chan.getAttribute("ID");
                if (chanID.indexOf("chan") == 0) {
                    chanID = chanID.substring(4);
                }
                this.targets.put("CHAN_ID." + chanID, chanf.getName(chanID));
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public String[] getActivityTokens() {
        return this.activities.keySet().toArray(new String[0]);
    }

    public String getActivityName(String token) {
        return (String)this.activities.get(token);
    }

    public String[] getTargetTokens() {
        return this.targets.keySet().toArray(new String[0]);
    }

    public String getTargetName(String token) {
        return (String)this.targets.get(token);
    }

    public String getOwnerToken() {
        return "UP_FRAMEWORK";
    }

    public String getOwnerName() {
        return "uPortal Channel Subscription";
    }
}

