/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.util.Date;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.IEntityLockService;
import org.jasig.portal.concurrency.LockingException;

public class EntityLockImpl
implements IEntityLock {
    private Class entityType;
    private String entityKey;
    private String lockOwner;
    private Date expirationTime;
    private int lockType;
    private IEntityLockService service;

    protected EntityLockImpl(Class newEntityType, String newEntityKey, int newLockType, Date newExpirationTime, String newLockOwner) {
        this.setEntityType(newEntityType);
        this.setEntityKey(newEntityKey);
        this.setLockType(newLockType);
        this.setExpirationTime(newExpirationTime);
        this.setLockOwner(newLockOwner);
    }

    protected EntityLockImpl(Class newEntityType, String newEntityKey, int newLockType, Date newExpirationTime, String newLockOwner, IEntityLockService newService) {
        this.setEntityType(newEntityType);
        this.setEntityKey(newEntityKey);
        this.setLockType(newLockType);
        this.setExpirationTime(newExpirationTime);
        this.setLockOwner(newLockOwner);
        this.setService(newService);
    }

    public void convert(int newType) throws LockingException {
        this.getService().convert(this, newType);
    }

    public void convert(int newType, int duration) throws LockingException {
        this.getService().convert(this, newType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityLockImpl)) {
            return false;
        }
        IEntityLock candidate = (IEntityLock)obj;
        return this.getEntityType().equals(candidate.getEntityType()) && this.getEntityKey().equals(candidate.getEntityKey()) && this.getLockOwner().equals(candidate.getLockOwner()) && this.getLockType() == candidate.getLockType() && this.getExpirationTime().equals(candidate.getExpirationTime());
    }

    protected void expire() {
        this.setExpirationTime(new Date(0L));
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public Class getEntityType() {
        return this.entityType;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public int getLockType() {
        return this.lockType;
    }

    protected IEntityLockService getService() {
        return this.service;
    }

    public int hashCode() {
        return this.getEntityType().hashCode() + this.getEntityKey().hashCode() + this.getLockOwner().hashCode();
    }

    public boolean isLocked() {
        return this.getExpirationTime().after(new Date());
    }

    public boolean isValid() throws LockingException {
        return this.getService().isValid(this);
    }

    public void release() throws LockingException {
        this.getService().release(this);
    }

    public void renew() throws LockingException {
        this.getService().renew(this);
    }

    public void renew(int duration) throws LockingException {
        this.getService().renew(this, duration);
    }

    private void setEntityKey(String newEntityKey) {
        this.entityKey = newEntityKey;
    }

    private void setEntityType(Class newEntityType) {
        this.entityType = newEntityType;
    }

    void setExpirationTime(Date newExpirationTime) {
        this.expirationTime = newExpirationTime;
    }

    private void setLockOwner(String newLockOwner) {
        this.lockOwner = newLockOwner;
    }

    void setLockType(int newLockType) {
        this.lockType = newLockType;
    }

    private void setService(IEntityLockService newService) {
        this.service = newService;
    }

    public String toString() {
        return "EntityLockImpl for " + this.getEntityType().getName() + "(" + this.getEntityKey() + ")" + " type " + this.getLockType() + " owner " + this.getLockOwner() + " " + this.getExpirationTime();
    }
}

