/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserLayoutStore;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.ALChannel;
import org.jasig.portal.layout.ALChannelDescription;
import org.jasig.portal.layout.ALFolder;
import org.jasig.portal.layout.ALFolderDescription;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.AggregatedLayout;
import org.jasig.portal.layout.AggregatedLayoutManager;
import org.jasig.portal.layout.IALChannelDescription;
import org.jasig.portal.layout.IALFolderDescription;
import org.jasig.portal.layout.IALNodeDescription;
import org.jasig.portal.layout.IAggregatedLayout;
import org.jasig.portal.layout.IAggregatedUserLayoutStore;
import org.jasig.portal.layout.UserLayoutNodeDescription;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.jasig.portal.layout.restrictions.PriorityRestriction;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;
import org.jasig.portal.layout.restrictions.UserLayoutRestrictionFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CommonUtils;

public class AggregatedUserLayoutStore
extends RDBMUserLayoutStore
implements IAggregatedUserLayoutStore {
    private static final int LOST_FOLDER_ID = -1;
    protected static final String FRAGMENT_UPDATE_SQL = "UPDATE UP_FRAGMENTS SET NEXT_NODE_ID=?,PREV_NODE_ID=?,CHLD_NODE_ID=?,PRNT_NODE_ID=?,EXTERNAL_ID=?,CHAN_ID=?,NAME=?,TYPE=?,HIDDEN=?,IMMUTABLE=?,UNREMOVABLE=?,GROUP_KEY=?,PRIORITY=? WHERE FRAGMENT_ID=? AND NODE_ID=?";
    protected static final String LAYOUT_UPDATE_SQL = "UPDATE UP_LAYOUT_STRUCT_AGGR SET NEXT_NODE_ID=?,PREV_NODE_ID=?,CHLD_NODE_ID=?,PRNT_NODE_ID=?,EXTERNAL_ID=?,CHAN_ID=?,NAME=?,TYPE=?,HIDDEN=?,IMMUTABLE=?,UNREMOVABLE=?,GROUP_KEY=?,PRIORITY=?,FRAGMENT_ID=?,FRAGMENT_NODE_ID=? WHERE LAYOUT_ID=? AND USER_ID=? AND NODE_ID=?";
    protected static final String FRAGMENT_RESTRICTION_UPDATE_SQL = "UPDATE UP_FRAGMENT_RESTRICTIONS SET RESTRICTION_VALUE=? WHERE FRAGMENT_ID=? AND NODE_ID=? AND RESTRICTION_TYPE=? AND RESTRICTION_TREE_PATH=?";
    protected static final String LAYOUT_RESTRICTION_UPDATE_SQL = "UPDATE UP_LAYOUT_RESTRICTIONS SET RESTRICTION_VALUE=? WHERE LAYOUT_ID=? AND USER_ID=? AND NODE_ID=? AND RESTRICTION_TYPE=? AND RESTRICTION_TREE_PATH=?";
    protected static final String CHANNEL_PARAM_UPDATE_SQL = "UPDATE UP_CHANNEL_PARAM SET CHAN_PARM_DESC=?,CHAN_PARM_VAL=?,CHAN_PARM_OVRD=? WHERE CHAN_ID=? AND CHAN_PARM_NM=?";
    protected static final String CHANNEL_UPDATE_SQL = "UPDATE UP_CHANNEL SET CHAN_TITLE=?,CHAN_NAME=?,CHAN_DESC=?,CHAN_CLASS=?,CHAN_TYPE_ID=?,CHAN_PUBL_ID=?,CHAN_PUBL_DT=?,CHAN_APVL_ID=?,CHAN_APVL_DT=?,CHAN_TIMEOUT=?,CHAN_EDITABLE=?,CHAN_HAS_HELP=?,CHAN_HAS_ABOUT=?,CHAN_FNAME=?,CHAN_SECURE=? WHERE CHAN_ID=?";
    protected static final String FRAGMENT_ADD_SQL = "INSERT INTO UP_FRAGMENTS (FRAGMENT_ID,NODE_ID,NEXT_NODE_ID,PREV_NODE_ID,CHLD_NODE_ID,PRNT_NODE_ID,EXTERNAL_ID,CHAN_ID,NAME,TYPE,HIDDEN,IMMUTABLE,UNREMOVABLE,GROUP_KEY,PRIORITY) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String LAYOUT_ADD_SQL = "INSERT INTO UP_LAYOUT_STRUCT_AGGR (LAYOUT_ID,USER_ID,NODE_ID,NEXT_NODE_ID,PREV_NODE_ID,CHLD_NODE_ID,PRNT_NODE_ID,EXTERNAL_ID,CHAN_ID,NAME,TYPE,HIDDEN,IMMUTABLE,UNREMOVABLE,GROUP_KEY,PRIORITY,FRAGMENT_ID,FRAGMENT_NODE_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String FRAGMENT_RESTRICTION_ADD_SQL = "INSERT INTO UP_FRAGMENT_RESTRICTIONS (RESTRICTION_TYPE,NODE_ID,FRAGMENT_ID,RESTRICTION_VALUE,RESTRICTION_TREE_PATH) VALUES (?,?,?,?,?)";
    protected static final String LAYOUT_RESTRICTION_ADD_SQL = "INSERT INTO UP_LAYOUT_RESTRICTIONS (RESTRICTION_TYPE,LAYOUT_ID,USER_ID,NODE_ID,RESTRICTION_VALUE,RESTRICTION_TREE_PATH) VALUES (?,?,?,?,?,?)";
    protected static final String CHANNEL_PARAM_ADD_SQL = "INSERT INTO UP_CHANNEL_PARAM (CHAN_ID,CHAN_PARM_NM,CHAN_PARM_DESC,CHAN_PARM_VAL,CHAN_PARM_OVRD) VALUES (?,?,?,?,?)";
    protected static final String CHANNEL_ADD_SQL = "INSERT INTO UP_CHANNEL (CHAN_ID,CHAN_TITLE,CHAN_NAME,CHAN_DESC,CHAN_CLASS,CHAN_TYPE_ID,CHAN_PUBL_ID,CHAN_PUBL_DT,CHAN_APVL_ID,CHAN_APVL_DT,CHAN_TIMEOUT,CHAN_EDITABLE,CHAN_HAS_HELP,CHAN_HAS_ABOUT,CHAN_FNAME,CHAN_SECURE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String fragmentJoinQuery = "";

    public AggregatedUserLayoutStore() throws Exception {
        RDBMServices.supportsOuterJoins = false;
        if (RDBMServices.supportsOuterJoins) {
            if (RDBMServices.joinQuery instanceof RDBMServices.JdbcDb) {
                RDBMServices.joinQuery.addQuery("layout_aggr", "{oj UP_LAYOUT_STRUCT_AGGR ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.NODE_ID = USP.STRUCT_ID} WHERE");
                fragmentJoinQuery = "{oj UP_FRAGMENTS UF LEFT OUTER JOIN UP_FRAGMENT_PARAM UFP ON UF.NODE_ID = UFP.NODE_ID AND UF.FRAGMENT_ID = UFP.FRAGMENT_ID} WHERE";
            } else if (RDBMServices.joinQuery instanceof RDBMServices.PostgreSQLDb) {
                RDBMServices.joinQuery.addQuery("layout_aggr", "UP_LAYOUT_STRUCT_AGGR ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.NODE_ID = USP.STRUCT_ID WHERE");
                fragmentJoinQuery = "UP_FRAGMENTS UF LEFT OUTER JOIN UP_FRAGMENT_PARAM UFP ON UF.NODE_ID = UFP.NODE_ID AND UF.FRAGMENT_ID = UFP.FRAGMENT_ID WHERE";
            } else if (RDBMServices.joinQuery instanceof RDBMServices.OracleDb) {
                RDBMServices.joinQuery.addQuery("layout_aggr", "UP_LAYOUT_STRUCT_AGGR ULS, UP_LAYOUT_PARAM USP WHERE ULS.NODE_ID = USP.STRUCT_ID(+) AND ULS.USER_ID = USP.USER_ID AND");
                fragmentJoinQuery = "UP_FRAGMENTS UF, UP_FRAGMENT_PARAM UFP WHERE UF.NODE_ID = UFP.NODE_ID(+) AND UF.FRAGMENT_ID = UFP.FRAGMENT_ID AND";
            } else {
                throw new Exception("Unknown database!");
            }
        }
    }

    protected String getStructId(int structId, int chanId) {
        return structId + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStructureStylesheetUserPreferences(IPerson person, int profileId, StructureStylesheetUserPreferences ssup) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            int stylesheetId = ssup.getStylesheetId();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                ResultSet rs;
                String sQuery;
                String pValue;
                String pName;
                Enumeration attre;
                Enumeration e = ssup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName2 = (String)e.nextElement();
                    String sQuery2 = "SELECT PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_NAME='" + pName2 + "'";
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery2);
                    ResultSet rs2 = stmt.executeQuery(sQuery2);
                    sQuery2 = rs2.next() ? "UPDATE UP_SS_USER_PARM SET PARAM_VAL='" + ssup.getParameterValue(pName2) + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_NAME='" + pName2 + "'" : "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1,'" + pName2 + "','" + ssup.getParameterValue(pName2) + "')";
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery2);
                    stmt.executeUpdate(sQuery2);
                }
                e = ssup.getFolders();
                while (e.hasMoreElements()) {
                    String folderId = (String)e.nextElement();
                    attre = ssup.getFolderAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedFolderAttributeValue(folderId, pName);
                        if (pValue == null) continue;
                        sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + folderId + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=2";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + folderId + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=2" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1," + folderId + ",'" + pName + "',2,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                e = ssup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    attre = ssup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedChannelAttributeValue(channelId, pName);
                        if (pValue == null) continue;
                        sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + channelId + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + channelId + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1," + channelId + ",'" + pName + "',3,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThemeStylesheetUserPreferences(IPerson person, int profileId, ThemeStylesheetUserPreferences tsup) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            int stylesheetId = tsup.getStylesheetId();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                Enumeration e = tsup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName = (String)e.nextElement();
                    String sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_NAME='" + pName + "'";
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                    ResultSet rs = stmt.executeQuery(sQuery);
                    sQuery = rs.next() ? "UPDATE UP_SS_USER_PARM SET PARAM_VAL='" + tsup.getParameterValue(pName) + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_NAME='" + pName + "'" : "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",2,'" + pName + "','" + tsup.getParameterValue(pName) + "')";
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = tsup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    Enumeration attre = tsup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        String pName = (String)attre.nextElement();
                        String pValue = tsup.getDefinedChannelAttributeValue(channelId, pName);
                        if (pValue == null) continue;
                        String sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                        ResultSet rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",2," + channelId.substring(1) + ",'" + pName + "',3,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ALNode addUserLayoutNode(IPerson person, UserProfile profile, ALNode node) throws PortalException {
        Connection con = RDBMServices.getConnection();
        try {
            IALChannelDescription channelDesc;
            int publishId;
            ResultSet rs;
            RDBMServices.setAutoCommit(con, false);
            int nodeId = 0;
            int layoutId = 0;
            int userId = person.getID();
            IALNodeDescription nodeDesc = node.getNodeDescription();
            int fragmentId = CommonUtils.parseInt(nodeDesc.getFragmentId());
            int fragmentNodeId = CommonUtils.parseInt(nodeDesc.getFragmentNodeId());
            Statement stmt = con.createStatement();
            if (fragmentId > 0 && fragmentNodeId <= 0) {
                rs = stmt.executeQuery("SELECT MAX(NODE_ID) FROM UP_FRAGMENTS WHERE FRAGMENT_ID=" + fragmentId);
                nodeId = rs.next() ? rs.getInt(1) + 1 : 1;
                if (rs != null) {
                    rs.close();
                }
            } else {
                String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
                LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::addUserLayoutNode(): " + subSelectString);
                rs = stmt.executeQuery(subSelectString);
                try {
                    rs.next();
                    layoutId = rs.getInt(1);
                    if (rs.wasNull()) {
                        layoutId = 0;
                    }
                }
                finally {
                    rs.close();
                }
                String sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::addUserLayoutNode(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    rs.next();
                    nodeId = rs.getInt(1) + 1;
                }
                finally {
                    rs.close();
                }
                sQuery = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nodeId + " WHERE USER_ID=" + userId;
                stmt.executeUpdate(sQuery);
            }
            nodeDesc.setId(nodeId + "");
            PreparedStatement psAddNode = fragmentId > 0 && fragmentNodeId <= 0 ? con.prepareStatement(FRAGMENT_ADD_SQL) : con.prepareStatement(LAYOUT_ADD_SQL);
            PreparedStatement psAddRestriction = fragmentId > 0 ? con.prepareStatement(FRAGMENT_RESTRICTION_ADD_SQL) : con.prepareStatement(LAYOUT_RESTRICTION_ADD_SQL);
            Statement psAddChannelParam = null;
            Statement psAddChannel = null;
            if (node.getNodeType() == 1 && (publishId = CommonUtils.parseInt((channelDesc = (IALChannelDescription)nodeDesc).getChannelPublishId())) > 0) {
                rs = stmt.executeQuery("SELECT CHAN_NAME FROM UP_CHANNEL WHERE CHAN_ID=" + publishId);
                try {
                    if (rs.next()) {
                        channelDesc.setName(rs.getString(1));
                        this.fillChannelDescription(channelDesc);
                    }
                }
                finally {
                    rs.close();
                }
            }
            ALNode resultNode = this.addUserLayoutNode(userId, layoutId, node, psAddNode, psAddRestriction, null, null);
            if (psAddNode != null) {
                psAddNode.close();
            }
            if (psAddRestriction != null) {
                psAddRestriction.close();
            }
            if (psAddChannel != null) {
                psAddChannel.close();
            }
            if (psAddChannelParam != null) {
                psAddChannelParam.close();
            }
            stmt.close();
            RDBMServices.commit(con);
            con.close();
            return resultNode;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            try {
                RDBMServices.rollback(con);
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle.toString());
                errorMessage = errorMessage + ":" + sqle.getMessage();
            }
            throw new PortalException(errorMessage);
        }
    }

    private ALNode addUserLayoutNode(int userId, int layoutId, ALNode node, PreparedStatement psAddNode, PreparedStatement psAddRestriction, PreparedStatement psAddChannel, PreparedStatement psAddChannelParam) throws PortalException {
        IALNodeDescription nodeDesc = node.getNodeDescription();
        boolean isFolder = node.getNodeType() == 2;
        int fragmentId = CommonUtils.parseInt(nodeDesc.getFragmentId());
        int fragmentNodeId = CommonUtils.parseInt(nodeDesc.getFragmentNodeId());
        int nodeId = CommonUtils.parseInt(nodeDesc.getId());
        int tmpValue = -1;
        try {
            IALChannelDescription channelDesc;
            int publishId;
            if (fragmentId > 0 && fragmentNodeId <= 0) {
                psAddNode.setInt(1, fragmentId);
                psAddNode.setInt(2, nodeId);
                tmpValue = CommonUtils.parseInt(node.getNextNodeId());
                if (tmpValue > 0) {
                    psAddNode.setInt(3, tmpValue);
                } else {
                    psAddNode.setNull(3, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getPreviousNodeId());
                if (tmpValue > 0) {
                    psAddNode.setInt(4, tmpValue);
                } else {
                    psAddNode.setNull(4, 4);
                }
                int n = tmpValue = isFolder ? CommonUtils.parseInt(((ALFolder)node).getFirstChildNodeId()) : -1;
                if (tmpValue > 0) {
                    psAddNode.setInt(5, tmpValue);
                } else {
                    psAddNode.setNull(5, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getParentNodeId());
                if (tmpValue > 0) {
                    psAddNode.setInt(6, tmpValue);
                } else {
                    psAddNode.setNull(6, 4);
                }
                psAddNode.setNull(7, 12);
                int n2 = tmpValue = !isFolder ? CommonUtils.parseInt(((IALChannelDescription)nodeDesc).getChannelPublishId()) : -1;
                if (tmpValue > 0) {
                    psAddNode.setInt(8, tmpValue);
                } else {
                    psAddNode.setNull(8, 4);
                }
                psAddNode.setString(9, nodeDesc.getName());
                if (isFolder) {
                    IALFolderDescription folderDesc = (IALFolderDescription)nodeDesc;
                    int type = folderDesc.getFolderType();
                    switch (type) {
                        case 1: {
                            psAddNode.setString(10, "header");
                            break;
                        }
                        case 2: {
                            psAddNode.setString(10, "footer");
                            break;
                        }
                        default: {
                            psAddNode.setString(10, "regular");
                            break;
                        }
                    }
                } else {
                    psAddNode.setNull(10, 12);
                }
                psAddNode.setString(11, nodeDesc.isHidden() ? "Y" : "N");
                psAddNode.setString(12, nodeDesc.isImmutable() ? "Y" : "N");
                psAddNode.setString(13, nodeDesc.isUnremovable() ? "Y" : "N");
                psAddNode.setString(14, nodeDesc.getGroup());
                psAddNode.setInt(15, node.getPriority());
                psAddNode.executeUpdate();
            } else {
                psAddNode.setInt(1, layoutId);
                psAddNode.setInt(2, userId);
                psAddNode.setInt(3, nodeId);
                tmpValue = CommonUtils.parseInt(node.getNextNodeId());
                if (tmpValue > 0) {
                    psAddNode.setInt(4, tmpValue);
                } else {
                    psAddNode.setNull(4, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getPreviousNodeId());
                if (tmpValue > 0) {
                    psAddNode.setInt(5, tmpValue);
                } else {
                    psAddNode.setNull(5, 4);
                }
                int n = tmpValue = isFolder ? CommonUtils.parseInt(((ALFolder)node).getFirstChildNodeId()) : -1;
                if (tmpValue > 0) {
                    psAddNode.setInt(6, tmpValue);
                } else {
                    psAddNode.setNull(6, 4);
                }
                String parentId = node.getParentNodeId();
                if (!"userLayoutRootNode".equals(parentId)) {
                    psAddNode.setInt(7, CommonUtils.parseInt(parentId, -1));
                } else {
                    psAddNode.setNull(7, 4);
                }
                psAddNode.setNull(8, 12);
                int n3 = tmpValue = !isFolder ? CommonUtils.parseInt(((IALChannelDescription)nodeDesc).getChannelPublishId()) : -1;
                if (tmpValue > 0) {
                    psAddNode.setInt(9, tmpValue);
                } else {
                    psAddNode.setNull(9, 4);
                }
                psAddNode.setString(10, nodeDesc.getName());
                if (isFolder) {
                    IALFolderDescription folderDesc = (IALFolderDescription)nodeDesc;
                    int type = folderDesc.getFolderType();
                    switch (type) {
                        case 1: {
                            psAddNode.setString(11, "header");
                            break;
                        }
                        case 2: {
                            psAddNode.setString(11, "footer");
                            break;
                        }
                        default: {
                            psAddNode.setString(11, "regular");
                            break;
                        }
                    }
                } else {
                    psAddNode.setNull(11, 12);
                }
                psAddNode.setString(12, nodeDesc.isHidden() ? "Y" : "N");
                psAddNode.setString(13, nodeDesc.isImmutable() ? "Y" : "N");
                psAddNode.setString(14, nodeDesc.isUnremovable() ? "Y" : "N");
                psAddNode.setString(15, nodeDesc.getGroup());
                psAddNode.setInt(16, node.getPriority());
                if (fragmentId > 0) {
                    psAddNode.setInt(17, fragmentId);
                } else {
                    psAddNode.setNull(17, 4);
                }
                if (fragmentNodeId > 0) {
                    psAddNode.setInt(18, fragmentNodeId);
                } else {
                    psAddNode.setNull(18, 4);
                }
                psAddNode.executeUpdate();
            }
            Hashtable restrHash = nodeDesc.getRestrictions();
            if (restrHash != null) {
                Object psRestr = null;
                if (fragmentId <= 0) {
                    Enumeration restrictions = restrHash.elements();
                    while (restrictions.hasMoreElements()) {
                        IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.nextElement();
                        psAddRestriction.setInt(1, restriction.getRestrictionType());
                        psAddRestriction.setInt(2, layoutId);
                        psAddRestriction.setInt(3, userId);
                        psAddRestriction.setInt(4, nodeId);
                        psAddRestriction.setString(5, restriction.getRestrictionExpression());
                        String path = restriction.getRestrictionPath();
                        psAddRestriction.setString(6, path);
                        psAddRestriction.executeUpdate();
                    }
                }
            }
            if (!isFolder && psAddChannel != null && psAddChannelParam != null && (publishId = CommonUtils.parseInt((channelDesc = (IALChannelDescription)nodeDesc).getChannelPublishId())) > 0) {
                Enumeration paramNames = channelDesc.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    String paramValue = channelDesc.getParameterValue(paramName);
                    psAddChannelParam.setInt(1, publishId);
                    psAddChannelParam.setString(2, paramName);
                    if (channelDesc.getDescription() != null) {
                        psAddChannelParam.setString(3, channelDesc.getDescription());
                    } else {
                        psAddChannelParam.setNull(3, 12);
                    }
                    psAddChannelParam.setString(4, paramValue);
                    psAddChannelParam.setString(5, channelDesc.canOverrideParameter(paramName) ? "Y" : "N");
                    psAddChannelParam.executeUpdate();
                }
                psAddChannel.setInt(1, publishId);
                psAddChannel.setString(2, channelDesc.getTitle());
                psAddChannel.setString(3, channelDesc.getName());
                if (channelDesc.getDescription() != null) {
                    psAddChannel.setString(4, channelDesc.getDescription());
                } else {
                    psAddChannel.setNull(4, 12);
                }
                psAddChannel.setString(5, channelDesc.getClassName());
                tmpValue = CommonUtils.parseInt(channelDesc.getChannelTypeId());
                if (tmpValue > 0) {
                    psAddChannel.setInt(6, tmpValue);
                } else {
                    psAddChannel.setNull(6, 4);
                }
                tmpValue = CommonUtils.parseInt(channelDesc.getChannelPublishId());
                if (tmpValue > 0) {
                    psAddChannel.setInt(7, tmpValue);
                } else {
                    psAddChannel.setNull(7, 4);
                }
                Timestamp timestamp = new Timestamp(new Date().getTime());
                psAddChannel.setTimestamp(8, timestamp);
                psAddChannel.setInt(9, 0);
                psAddChannel.setTimestamp(10, timestamp);
                psAddChannel.setInt(11, (int)channelDesc.getTimeout());
                psAddChannel.setString(12, channelDesc.isEditable() ? "Y" : "N");
                psAddChannel.setString(13, channelDesc.hasHelp() ? "Y" : "N");
                psAddChannel.setString(14, channelDesc.hasAbout() ? "Y" : "N");
                psAddChannel.setString(15, channelDesc.getFunctionalName());
                psAddChannel.executeUpdate();
            }
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            throw new PortalException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserLayoutNode(IPerson person, UserProfile profile, ALNode node) throws PortalException {
        Connection con = RDBMServices.getConnection();
        try {
            int layoutId;
            RDBMServices.setAutoCommit(con, false);
            int userId = person.getID();
            int nodeId = CommonUtils.parseInt(node.getId());
            IALNodeDescription nodeDesc = node.getNodeDescription();
            Statement stmt = con.createStatement();
            String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
            ResultSet rs = stmt.executeQuery(subSelectString);
            try {
                rs.next();
                layoutId = rs.getInt(1);
                if (rs.wasNull()) {
                    layoutId = 0;
                }
            }
            finally {
                rs.close();
            }
            int fragmentId = CommonUtils.parseInt(nodeDesc.getFragmentId());
            int fragmentNodeId = CommonUtils.parseInt(nodeDesc.getFragmentNodeId());
            PreparedStatement psUpdateNode = fragmentId > 0 && fragmentNodeId <= 0 ? con.prepareStatement(FRAGMENT_UPDATE_SQL) : con.prepareStatement(LAYOUT_UPDATE_SQL);
            PreparedStatement psUpdateRestriction = fragmentId > 0 ? con.prepareStatement(FRAGMENT_RESTRICTION_UPDATE_SQL) : con.prepareStatement(LAYOUT_RESTRICTION_UPDATE_SQL);
            PreparedStatement psUpdateChannelParam = con.prepareStatement(CHANNEL_PARAM_UPDATE_SQL);
            PreparedStatement psUpdateChannel = con.prepareStatement(CHANNEL_UPDATE_SQL);
            boolean result = this.updateUserLayoutNode(userId, layoutId, node, psUpdateNode, psUpdateRestriction, null, null);
            if (psUpdateNode != null) {
                psUpdateNode.close();
            }
            if (psUpdateRestriction != null) {
                psUpdateRestriction.close();
            }
            if (psUpdateChannel != null) {
                psUpdateChannel.close();
            }
            if (psUpdateChannelParam != null) {
                psUpdateChannelParam.close();
            }
            RDBMServices.commit(con);
            stmt.close();
            con.close();
            return result;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            try {
                RDBMServices.rollback(con);
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle.toString());
                errorMessage = errorMessage + ":" + sqle.getMessage();
            }
            throw new PortalException(errorMessage);
        }
    }

    private boolean updateUserLayoutNode(int userId, int layoutId, ALNode node, PreparedStatement psUpdateNode, PreparedStatement psUpdateRestriction, PreparedStatement psUpdateChannel, PreparedStatement psUpdateChannelParam) throws PortalException {
        int count = 0;
        boolean isFolder = node.getNodeType() == 2;
        IALNodeDescription nodeDesc = node.getNodeDescription();
        int nodeId = CommonUtils.parseInt(nodeDesc.getId());
        int fragmentId = CommonUtils.parseInt(nodeDesc.getFragmentId());
        int fragmentNodeId = CommonUtils.parseInt(nodeDesc.getFragmentNodeId());
        int tmpValue = -1;
        try {
            if (fragmentId > 0 && fragmentNodeId <= 0) {
                tmpValue = CommonUtils.parseInt(node.getNextNodeId());
                if (tmpValue > 0) {
                    psUpdateNode.setInt(1, tmpValue);
                } else {
                    psUpdateNode.setNull(1, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getPreviousNodeId());
                if (tmpValue > 0) {
                    psUpdateNode.setInt(2, tmpValue);
                } else {
                    psUpdateNode.setNull(2, 4);
                }
                int n = tmpValue = isFolder ? CommonUtils.parseInt(((ALFolder)node).getFirstChildNodeId()) : -1;
                if (tmpValue > 0) {
                    psUpdateNode.setInt(3, tmpValue);
                } else {
                    psUpdateNode.setNull(3, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getParentNodeId());
                if (tmpValue > 0) {
                    psUpdateNode.setInt(4, tmpValue);
                } else {
                    psUpdateNode.setNull(4, 4);
                }
                psUpdateNode.setNull(5, 12);
                int n2 = tmpValue = !isFolder ? CommonUtils.parseInt(((IALChannelDescription)nodeDesc).getChannelPublishId()) : -1;
                if (tmpValue > 0) {
                    psUpdateNode.setInt(6, tmpValue);
                } else {
                    psUpdateNode.setNull(6, 4);
                }
                psUpdateNode.setString(7, nodeDesc.getName());
                if (isFolder) {
                    IALFolderDescription folderDesc = (IALFolderDescription)nodeDesc;
                    int type = folderDesc.getFolderType();
                    switch (type) {
                        case 1: {
                            psUpdateNode.setString(8, "header");
                            break;
                        }
                        case 2: {
                            psUpdateNode.setString(8, "footer");
                            break;
                        }
                        default: {
                            psUpdateNode.setString(8, "regular");
                            break;
                        }
                    }
                } else {
                    psUpdateNode.setNull(8, 12);
                }
                psUpdateNode.setString(9, nodeDesc.isHidden() ? "Y" : "N");
                psUpdateNode.setString(10, nodeDesc.isImmutable() ? "Y" : "N");
                psUpdateNode.setString(11, nodeDesc.isUnremovable() ? "Y" : "N");
                psUpdateNode.setString(12, nodeDesc.getGroup());
                psUpdateNode.setInt(13, node.getPriority());
                psUpdateNode.setInt(14, nodeId);
                psUpdateNode.setInt(15, fragmentId);
                count += psUpdateNode.executeUpdate();
            } else {
                tmpValue = CommonUtils.parseInt(node.getNextNodeId());
                if (tmpValue > 0) {
                    psUpdateNode.setInt(1, tmpValue);
                } else {
                    psUpdateNode.setNull(1, 4);
                }
                tmpValue = CommonUtils.parseInt(node.getPreviousNodeId());
                if (tmpValue > 0) {
                    psUpdateNode.setInt(2, tmpValue);
                } else {
                    psUpdateNode.setNull(2, 4);
                }
                int n = tmpValue = isFolder ? CommonUtils.parseInt(((ALFolder)node).getFirstChildNodeId()) : -1;
                if (tmpValue > 0) {
                    psUpdateNode.setInt(3, tmpValue);
                } else {
                    psUpdateNode.setNull(3, 4);
                }
                String parentId = node.getParentNodeId();
                if (!"userLayoutRootNode".equals(parentId)) {
                    psUpdateNode.setInt(4, CommonUtils.parseInt(parentId, -1));
                } else {
                    psUpdateNode.setNull(4, 4);
                }
                psUpdateNode.setNull(5, 12);
                int n3 = tmpValue = !isFolder ? CommonUtils.parseInt(((IALChannelDescription)nodeDesc).getChannelPublishId()) : -1;
                if (tmpValue > 0) {
                    psUpdateNode.setInt(6, tmpValue);
                } else {
                    psUpdateNode.setNull(6, 4);
                }
                psUpdateNode.setString(7, nodeDesc.getName());
                if (isFolder) {
                    IALFolderDescription folderDesc = (IALFolderDescription)nodeDesc;
                    int type = folderDesc.getFolderType();
                    switch (type) {
                        case 1: {
                            psUpdateNode.setString(8, "header");
                            break;
                        }
                        case 2: {
                            psUpdateNode.setString(8, "footer");
                            break;
                        }
                        default: {
                            psUpdateNode.setString(8, "regular");
                            break;
                        }
                    }
                } else {
                    psUpdateNode.setNull(8, 12);
                }
                psUpdateNode.setString(9, nodeDesc.isHidden() ? "Y" : "N");
                psUpdateNode.setString(10, nodeDesc.isImmutable() ? "Y" : "N");
                psUpdateNode.setString(11, nodeDesc.isUnremovable() ? "Y" : "N");
                psUpdateNode.setString(12, nodeDesc.getGroup());
                psUpdateNode.setInt(13, node.getPriority());
                if (fragmentId > 0) {
                    psUpdateNode.setInt(14, fragmentId);
                } else {
                    psUpdateNode.setNull(14, 4);
                }
                if (fragmentNodeId > 0) {
                    psUpdateNode.setInt(15, fragmentNodeId);
                } else {
                    psUpdateNode.setNull(15, 4);
                }
                psUpdateNode.setInt(16, layoutId);
                psUpdateNode.setInt(17, userId);
                psUpdateNode.setInt(18, nodeId);
                count += psUpdateNode.executeUpdate();
            }
            Hashtable restrHash = nodeDesc.getRestrictions();
            if (restrHash != null && fragmentId <= 0) {
                Enumeration restrictions = restrHash.elements();
                while (restrictions.hasMoreElements()) {
                    IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.nextElement();
                    psUpdateRestriction.setString(1, restriction.getRestrictionExpression());
                    psUpdateRestriction.setInt(2, layoutId);
                    psUpdateRestriction.setInt(3, userId);
                    psUpdateRestriction.setInt(4, nodeId);
                    psUpdateRestriction.setInt(5, restriction.getRestrictionType());
                    String path = restriction.getRestrictionPath();
                    psUpdateRestriction.setString(6, path);
                    count += psUpdateRestriction.executeUpdate();
                }
            }
            return count > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            throw new PortalException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUserLayoutNode(IPerson person, UserProfile profile, ALNode node) throws PortalException {
        Connection con = RDBMServices.getConnection();
        try {
            int layoutId;
            RDBMServices.setAutoCommit(con, false);
            int count = 0;
            int userId = person.getID();
            int nodeId = CommonUtils.parseInt(node.getId());
            IALNodeDescription nodeDesc = node.getNodeDescription();
            Statement stmt = con.createStatement();
            String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::deleteUserLayoutNode(): " + subSelectString);
            ResultSet rs = stmt.executeQuery(subSelectString);
            try {
                rs.next();
                layoutId = rs.getInt(1);
                if (rs.wasNull()) {
                    layoutId = 0;
                }
            }
            finally {
                rs.close();
            }
            boolean isFolder = node.getNodeType() == 2;
            int fragmentId = CommonUtils.parseInt(nodeDesc.getFragmentId());
            int fragmentNodeId = CommonUtils.parseInt(nodeDesc.getFragmentNodeId());
            int tmpValue = -1;
            Hashtable restrHash = nodeDesc.getRestrictions();
            if (restrHash != null) {
                if (fragmentId > 0) {
                    PreparedStatement psFragmentRestr = con.prepareStatement("DELETE FROM UP_FRAGMENT_RESTRICTIONS WHERE FRAGMENT_ID=? AND NODE_ID=? AND RESTRICTION_TYPE=? AND RESTRICTION_TREE_PATH=?");
                    Enumeration restrictions = restrHash.elements();
                    while (restrictions.hasMoreElements()) {
                        IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.nextElement();
                        psFragmentRestr.setInt(1, fragmentId);
                        psFragmentRestr.setInt(2, nodeId);
                        psFragmentRestr.setInt(3, restriction.getRestrictionType());
                        String path = restriction.getRestrictionPath();
                        psFragmentRestr.setString(4, path);
                        count += psFragmentRestr.executeUpdate();
                    }
                    psFragmentRestr.close();
                } else {
                    PreparedStatement psRestr = con.prepareStatement("DELETE FROM UP_LAYOUT_RESTRICTIONS WHERE LAYOUT_ID=? AND USER_ID=? AND NODE_ID=? AND RESTRICTION_TYPE=? AND RESTRICTION_TREE_PATH=?");
                    Enumeration restrictions = restrHash.elements();
                    while (restrictions.hasMoreElements()) {
                        IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.nextElement();
                        psRestr.setInt(1, layoutId);
                        psRestr.setInt(2, userId);
                        psRestr.setInt(3, nodeId);
                        psRestr.setInt(4, restriction.getRestrictionType());
                        String path = restriction.getRestrictionPath();
                        psRestr.setString(5, path);
                        count += psRestr.executeUpdate();
                    }
                    psRestr.close();
                }
            }
            if (fragmentId > 0 && fragmentNodeId <= 0) {
                PreparedStatement psFragment = con.prepareStatement("DELETE FROM UP_FRAGMENTS WHERE NODE_ID=? AND FRAGMENT_ID=?");
                psFragment.setInt(1, nodeId);
                psFragment.setInt(2, fragmentId);
                count += psFragment.executeUpdate();
                psFragment.close();
            } else {
                PreparedStatement psLayout = con.prepareStatement("DELETE FROM UP_LAYOUT_STRUCT_AGGR WHERE LAYOUT_ID=? AND USER_ID=? AND NODE_ID=?");
                psLayout.setInt(1, layoutId);
                psLayout.setInt(2, userId);
                psLayout.setInt(3, nodeId);
                count += psLayout.executeUpdate();
                psLayout.close();
            }
            stmt.close();
            RDBMServices.commit(con);
            con.close();
            return count > 0;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            try {
                RDBMServices.rollback(con);
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle.toString());
                errorMessage = errorMessage + ":" + sqle.getMessage();
            }
            throw new PortalException(errorMessage);
        }
    }

    public ALNode getUserLayoutNode(IPerson person, UserProfile profile, String nodeId) throws PortalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregatedLayout(IPerson person, UserProfile profile, IAggregatedLayout layoutImpl) throws Exception {
        if (!(layoutImpl instanceof AggregatedLayout)) {
            throw new PortalException("The user layout object should have \"AggregatedLayout\" type");
        }
        AggregatedLayout layout = (AggregatedLayout)layoutImpl;
        int userId = person.getID();
        int profileId = profile.getProfileId();
        Connection con = RDBMServices.getConnection();
        RDBMServices.setAutoCommit(con, false);
        try {
            Statement stmt = con.createStatement();
            String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
            int layoutId = 0;
            ResultSet rs = stmt.executeQuery(subSelectString);
            try {
                if (rs.next()) {
                    layoutId = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
            String sQuery = "SELECT INIT_NODE_ID FROM UP_USER_LAYOUT_AGGR WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId;
            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setAggregatedLayout(): " + sQuery);
            String firstNodeId = layout.getLayoutFolder(layout.getRootId()).getFirstChildNodeId();
            rs = stmt.executeQuery(sQuery);
            sQuery = !rs.next() ? "INSERT INTO UP_USER_LAYOUT_AGGR (LAYOUT_ID,USER_ID,LAYOUT_TITLE,INIT_NODE_ID) VALUES (" + layoutId + "," + userId + ",'" + person.getFullName() + " layout'," + firstNodeId + ")" : "UPDATE UP_USER_LAYOUT_AGGR SET INIT_NODE_ID=" + firstNodeId + " WHERE LAYOUT_ID=" + layoutId + " AND USER_ID=" + userId;
            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::setAggregatedLayout(): " + sQuery);
            stmt.executeUpdate(sQuery);
            if (rs != null) {
                rs.close();
            }
            PreparedStatement psDeleteLayout = con.prepareStatement("DELETE FROM UP_LAYOUT_STRUCT_AGGR WHERE USER_ID=? AND LAYOUT_ID=?");
            psDeleteLayout.setInt(1, userId);
            psDeleteLayout.setInt(2, layoutId);
            psDeleteLayout.executeUpdate();
            PreparedStatement psDeleteLayoutRestriction = con.prepareStatement("DELETE FROM UP_LAYOUT_RESTRICTIONS WHERE USER_ID=? AND LAYOUT_ID=?");
            psDeleteLayoutRestriction.setInt(1, userId);
            psDeleteLayoutRestriction.setInt(2, layoutId);
            psDeleteLayoutRestriction.executeUpdate();
            PreparedStatement psUpdateFragmentRestriction = con.prepareStatement(FRAGMENT_RESTRICTION_UPDATE_SQL);
            PreparedStatement psUpdateLayoutNode = con.prepareStatement(LAYOUT_UPDATE_SQL);
            PreparedStatement psUpdateLayoutRestriction = con.prepareStatement(LAYOUT_RESTRICTION_UPDATE_SQL);
            PreparedStatement psUpdateChannelParam = con.prepareStatement(CHANNEL_PARAM_UPDATE_SQL);
            PreparedStatement psUpdateChannel = con.prepareStatement(CHANNEL_UPDATE_SQL);
            PreparedStatement psAddFragmentNode = con.prepareStatement(FRAGMENT_ADD_SQL);
            PreparedStatement psAddFragmentRestriction = con.prepareStatement(FRAGMENT_RESTRICTION_ADD_SQL);
            PreparedStatement psAddLayoutNode = con.prepareStatement(LAYOUT_ADD_SQL);
            PreparedStatement psAddLayoutRestriction = con.prepareStatement(LAYOUT_RESTRICTION_ADD_SQL);
            PreparedStatement psAddChannelParam = con.prepareStatement(CHANNEL_PARAM_ADD_SQL);
            PreparedStatement psAddChannel = con.prepareStatement(CHANNEL_ADD_SQL);
            PreparedStatement psLayout = con.prepareStatement("SELECT NODE_ID FROM UP_LAYOUT_STRUCT_AGGR WHERE NODE_ID=? AND USER_ID=? AND LAYOUT_ID=?");
            Enumeration nodeIds = layout.getNodeIds();
            while (nodeIds.hasMoreElements()) {
                String strNodeId = nodeIds.nextElement().toString();
                if (strNodeId.equals("userLayoutRootNode") || strNodeId.equals("lost_folder")) continue;
                ALNode node = layout.getNode(strNodeId);
                int nodeId = CommonUtils.parseInt(node.getId());
                int fragmentId = CommonUtils.parseInt(node.getFragmentId());
                int fragmentNodeId = CommonUtils.parseInt(node.getFragmentNodeId());
                if (fragmentId > 0 && fragmentNodeId <= 0) continue;
                psLayout.setInt(1, nodeId);
                psLayout.setInt(2, userId);
                psLayout.setInt(3, layoutId);
                rs = psLayout.executeQuery();
                if (rs.next()) {
                    this.updateUserLayoutNode(userId, layoutId, node, psUpdateLayoutNode, fragmentNodeId > 0 ? psUpdateFragmentRestriction : psUpdateLayoutRestriction, psUpdateChannel, psUpdateChannelParam);
                } else {
                    boolean channelParamsExist = false;
                    if (node.getNodeType() == 1) {
                        int publishId = CommonUtils.parseInt(((IALChannelDescription)node.getNodeDescription()).getChannelPublishId());
                        ResultSet rsChan = stmt.executeQuery("SELECT CHAN_ID FROM UP_CHANNEL WHERE CHAN_ID=" + publishId);
                        try {
                            if (rsChan.next()) {
                                channelParamsExist = true;
                            }
                        }
                        finally {
                            rsChan.close();
                        }
                    }
                    if (channelParamsExist) {
                        this.addUserLayoutNode(userId, layoutId, node, psAddLayoutNode, fragmentNodeId > 0 ? psAddFragmentRestriction : psAddLayoutRestriction, null, null);
                    } else {
                        this.addUserLayoutNode(userId, layoutId, node, psAddLayoutNode, fragmentNodeId > 0 ? psAddFragmentRestriction : psAddLayoutRestriction, psAddChannel, psAddChannelParam);
                    }
                }
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            RDBMServices.commit(con);
            if (psLayout != null) {
                psLayout.close();
            }
            if (psUpdateLayoutNode != null) {
                psUpdateLayoutNode.close();
            }
            if (psUpdateLayoutRestriction != null) {
                psUpdateLayoutRestriction.close();
            }
            if (psDeleteLayout != null) {
                psDeleteLayout.close();
            }
            if (psDeleteLayoutRestriction != null) {
                psDeleteLayoutRestriction.close();
            }
            if (psAddLayoutNode != null) {
                psAddLayoutNode.close();
            }
            if (psAddLayoutRestriction != null) {
                psAddLayoutRestriction.close();
            }
            if (psUpdateChannel != null) {
                psUpdateChannel.close();
            }
            if (psUpdateChannelParam != null) {
                psUpdateChannelParam.close();
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            try {
                RDBMServices.rollback(con);
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle.toString());
                errorMessage = errorMessage + ":" + sqle.getMessage();
            }
            throw new PortalException(errorMessage);
        }
    }

    public Map getFragments(IPerson person) throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<String, String> fragments = new Hashtable<String, String>();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT FRAGMENT_ID, FRAGMENT_NAME FROM UP_OWNER_FRAGMENT WHERE OWNER_ID=" + person.getID());
        while (rs.next()) {
            fragments.put(rs.getInt(1) + "", rs.getString(2));
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (con != null) {
            con.close();
        }
        return fragments;
    }

    public void setFragment(IPerson person, String fragmentId, IAggregatedLayout layoutImpl) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        if (!(layoutImpl instanceof AggregatedLayout)) {
            throw new PortalException("The user layout object has an incorrect type!");
        }
        AggregatedLayout layout = (AggregatedLayout)layoutImpl;
        RDBMServices.setAutoCommit(con, false);
        try {
            Statement stmt = con.createStatement();
            boolean isOwner = false;
            ResultSet rs = stmt.executeQuery("SELECT OWNER_ID FROM UP_OWNER_FRAGMENT WHERE FRAGMENT_ID=" + fragmentId);
            if (rs.next() && rs.getInt(1) == userId) {
                isOwner = true;
            }
            if (rs != null) {
                rs.close();
            }
            if (!isOwner) {
                throw new PortalException("The user is not an owner of that fragment");
            }
            stmt.executeUpdate("DELETE FROM UP_FRAGMENTS WHERE FRAGMENT_ID=" + fragmentId);
            stmt.executeUpdate("DELETE FROM UP_FRAGMENT_RESTRICTIONS WHERE FRAGMENT_ID=" + fragmentId);
            PreparedStatement psAddFragmentNode = con.prepareStatement(FRAGMENT_ADD_SQL);
            PreparedStatement psAddFragmentRestriction = con.prepareStatement(FRAGMENT_RESTRICTION_ADD_SQL);
            Enumeration nodeIds = layout.getNodeIds();
            while (nodeIds.hasMoreElements()) {
                String strNodeId = nodeIds.nextElement().toString();
                if (strNodeId.equals("userLayoutRootNode") || strNodeId.equals("lost_folder")) continue;
                ALNode node = layout.getNode(strNodeId);
                int nodeId = CommonUtils.parseInt(node.getId());
                int fragmentNodeId = CommonUtils.parseInt(node.getFragmentNodeId());
                if (CommonUtils.parseInt(node.getFragmentId()) <= 0 || fragmentNodeId > 0) continue;
                this.addUserLayoutNode(userId, 0, node, psAddFragmentNode, psAddFragmentRestriction, null, null);
            }
            if (stmt != null) {
                stmt.close();
            }
            RDBMServices.commit(con);
            if (psAddFragmentNode != null) {
                psAddFragmentNode.close();
            }
            if (psAddFragmentRestriction != null) {
                psAddFragmentRestriction.close();
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            try {
                RDBMServices.rollback(con);
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle.toString());
                errorMessage = errorMessage + ":" + sqle.getMessage();
            }
            throw new PortalException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAggregatedLayout getAggregatedLayout(IPerson person, UserProfile profile) throws PortalException {
        int userId;
        int realUserId = userId = person.getID();
        Connection con = null;
        AggregatedLayout layout = null;
        Hashtable<String, ALNode> layoutData = null;
        ALFolder rootNode = new ALFolder();
        Hashtable<String, String> pushFragmentRoots = null;
        String pushFragmentIds = null;
        try {
            Statement stmt;
            block99: {
                EntityIdentifier personIdentifier = person.getEntityIdentifier();
                IGroupMember groupPerson = GroupService.getGroupMember(personIdentifier);
                con = RDBMServices.getConnection();
                RDBMServices.setAutoCommit(con, false);
                layoutData = new Hashtable<String, ALNode>(50);
                Iterator containingGroups = groupPerson.getAllContainingGroups();
                if (containingGroups.hasNext()) {
                    PreparedStatement psGroups = con.prepareStatement("SELECT UOF.FRAGMENT_ID, UOF.FRAGMENT_ROOT_ID FROM UP_GROUP_FRAGMENT UPG, UP_OWNER_FRAGMENT UOF WHERE UPG.GROUP_KEY=? AND UPG.FRAGMENT_ID = UOF.FRAGMENT_ID AND UOF.PUSHED_FRAGMENT='Y'");
                    pushFragmentRoots = new Hashtable<String, String>();
                    while (containingGroups.hasNext()) {
                        int fragmentId;
                        IEntityGroup entityGroup = (IEntityGroup)containingGroups.next();
                        psGroups.setString(1, entityGroup.getKey());
                        ResultSet rsGroups = psGroups.executeQuery();
                        if (rsGroups.next()) {
                            fragmentId = rsGroups.getInt(1);
                            pushFragmentIds = pushFragmentIds == null ? fragmentId + "" : pushFragmentIds + "," + fragmentId;
                            pushFragmentRoots.put("" + fragmentId, rsGroups.getInt(2) + "");
                        }
                        while (rsGroups.next()) {
                            fragmentId = rsGroups.getInt(1);
                            pushFragmentIds = pushFragmentIds + "," + fragmentId;
                            pushFragmentRoots.put("" + fragmentId, rsGroups.getInt(2) + "");
                        }
                        if (rsGroups == null) continue;
                        rsGroups.close();
                    }
                    if (psGroups != null) {
                        psGroups.close();
                    }
                }
                stmt = con.createStatement();
                Statement insertStmt = con.createStatement();
                try {
                    String key;
                    int firstStructId;
                    String restrFragmentSQL;
                    String restrLayoutSQL;
                    ResultSet rs;
                    int layoutId;
                    long startTime;
                    block96: {
                        startTime = System.currentTimeMillis();
                        String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + subSelectString);
                        layoutId = 0;
                        rs = stmt.executeQuery(subSelectString);
                        try {
                            if (rs.next()) {
                                layoutId = rs.getInt(1);
                            }
                        }
                        finally {
                            rs.close();
                        }
                        if (layoutId == 0) {
                            String sQuery = "SELECT USER_DFLT_USR_ID, USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=" + userId;
                            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + sQuery);
                            rs = stmt.executeQuery(sQuery);
                            try {
                                if (rs.next()) {
                                    userId = rs.getInt(1);
                                    layoutId = rs.getInt(2);
                                }
                            }
                            finally {
                                rs.close();
                            }
                            sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + sQuery);
                            int nextStructId = 0;
                            rs = stmt.executeQuery(sQuery);
                            try {
                                if (rs.next()) {
                                    nextStructId = rs.getInt(1);
                                }
                            }
                            finally {
                                rs.close();
                            }
                            sQuery = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nextStructId + " WHERE USER_ID=" + realUserId;
                            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + sQuery);
                            stmt.executeUpdate(sQuery);
                            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID=" + realUserId;
                            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + sQuery);
                            stmt.executeUpdate(sQuery);
                            sQuery = " SELECT " + realUserId + ", PROFILE_ID, SS_ID, SS_TYPE, STRUCT_ID, PARAM_NAME, PARAM_TYPE, PARAM_VAL " + " FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId;
                            rs = stmt.executeQuery(sQuery);
                            while (rs.next()) {
                                String Insert = "INSERT INTO UP_SS_USER_ATTS (USER_ID, PROFILE_ID, SS_ID, SS_TYPE, STRUCT_ID, PARAM_NAME, PARAM_TYPE, PARAM_VAL) VALUES(" + realUserId + "," + rs.getInt("PROFILE_ID") + "," + rs.getInt("SS_ID") + "," + rs.getInt("SS_TYPE") + "," + rs.getString("STRUCT_ID") + "," + "'" + rs.getString("PARAM_NAME") + "'," + rs.getInt("PARAM_TYPE") + "," + "'" + rs.getString("PARAM_VAL") + "')";
                                LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + Insert);
                                insertStmt.executeUpdate(Insert);
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            RDBMServices.commit(con);
                        }
                        stmt.executeUpdate("DELETE FROM UP_LAYOUT_STRUCT_AGGR WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND PRNT_NODE_ID=" + -1);
                        layout = new AggregatedLayout(layoutId + "");
                        restrLayoutSQL = "SELECT RESTRICTION_TYPE, RESTRICTION_VALUE, RESTRICTION_TREE_PATH FROM UP_LAYOUT_RESTRICTIONS WHERE LAYOUT_ID=" + layoutId + " AND USER_ID=" + userId + " AND NODE_ID=?";
                        restrFragmentSQL = "SELECT RESTRICTION_TYPE, RESTRICTION_VALUE, RESTRICTION_TREE_PATH FROM UP_FRAGMENT_RESTRICTIONS WHERE FRAGMENT_ID=? AND NODE_ID=?";
                        firstStructId = -1;
                        String sQuery = "SELECT INIT_NODE_ID FROM UP_USER_LAYOUT_AGGR WHERE USER_ID=" + userId + " AND LAYOUT_ID = " + layoutId;
                        LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + sQuery);
                        rs = stmt.executeQuery(sQuery);
                        try {
                            if (rs.next()) {
                                firstStructId = rs.getInt(1);
                                break block96;
                            }
                            throw new PortalException("AggregatedUserLayoutStore::getAggregatedLayout(): No INIT_NODE_ID in UP_USER_LAYOUT_AGGR for " + userId + " and LAYOUT_ID " + layoutId);
                        }
                        finally {
                            rs.close();
                        }
                    }
                    rootNode = ALFolder.createRootFolder();
                    rootNode.setFirstChildNodeId(firstStructId + "");
                    layoutData.put("userLayoutRootNode", rootNode);
                    layoutData.put("lost_folder", ALFolder.createLostFolder());
                    String sqlLayout = "SELECT ULS.NODE_ID,ULS.NEXT_NODE_ID,ULS.CHLD_NODE_ID,ULS.PREV_NODE_ID,ULS.PRNT_NODE_ID,ULS.CHAN_ID,ULS.NAME,ULS.TYPE,ULS.HIDDEN,ULS.UNREMOVABLE,ULS.IMMUTABLE,ULS.PRIORITY,ULS.FRAGMENT_ID,ULS.FRAGMENT_NODE_ID";
                    sqlLayout = RDBMServices.supportsOuterJoins ? sqlLayout + ",USP.STRUCT_PARM_NM,USP.STRUCT_PARM_VAL FROM " + RDBMServices.joinQuery.getQuery("layout_aggr") : sqlLayout + " FROM UP_LAYOUT_STRUCT_AGGR ULS WHERE ";
                    sqlLayout = sqlLayout + " ULS.USER_ID=" + userId + " AND ULS.LAYOUT_ID=" + layoutId;
                    LogService.log(LogService.DEBUG, sqlLayout);
                    String sqlFragment = "SELECT DISTINCT UF.NODE_ID,UF.NEXT_NODE_ID,UF.CHLD_NODE_ID,UF.PREV_NODE_ID,UF.PRNT_NODE_ID,UF.CHAN_ID,UF.NAME,UF.TYPE,UF.HIDDEN,UF.UNREMOVABLE,UF.IMMUTABLE,UF.PRIORITY,UF.FRAGMENT_ID";
                    sqlFragment = RDBMServices.supportsOuterJoins ? sqlFragment + ",UFP.PARAM_NAME,UFP.PARAM_VALUE FROM UP_LAYOUT_STRUCT_AGGR ULS, " + fragmentJoinQuery : sqlFragment + " FROM UP_FRAGMENTS UF, UP_LAYOUT_STRUCT_AGGR ULS WHERE ";
                    sqlFragment = sqlFragment + " ULS.FRAGMENT_ID=UF.FRAGMENT_ID" + (pushFragmentIds != null ? " OR UF.FRAGMENT_ID IN (" + pushFragmentIds + ")" : "");
                    LogService.log(LogService.DEBUG, sqlFragment);
                    Hashtable<String, ALNode> fragmentNodes = new Hashtable<String, ALNode>();
                    String sql = sqlLayout;
                    for (int count = 0; count < 2; ++count) {
                        block98: {
                            int structId;
                            StringBuffer structParms;
                            List<String> chanIds;
                            block97: {
                                chanIds = Collections.synchronizedList(new ArrayList());
                                structParms = new StringBuffer();
                                rs = stmt.executeQuery(sql);
                                try {
                                    int lastStructId = 0;
                                    String sepChar = "";
                                    if (!rs.next()) break block97;
                                    structId = rs.getInt(1);
                                    while (true) {
                                        PriorityRestriction priorityRestriction;
                                        int index;
                                        String parentId;
                                        ALNode node;
                                        if (DEBUG > 1) {
                                            System.err.println("Found layout structureID " + structId);
                                        }
                                        int nextId = rs.getInt(2);
                                        int childId = rs.getInt(3);
                                        int prevId = rs.getInt(4);
                                        int prntId = rs.getInt(5);
                                        int chanId = rs.getInt(6);
                                        int fragmentId = rs.getInt(13);
                                        int fragmentNodeId = sql.equals(sqlLayout) ? rs.getInt(14) : 0;
                                        UserLayoutNodeDescription nodeDesc = null;
                                        String childIdStr = null;
                                        if (chanId <= 0 && fragmentId <= 0 || fragmentId > 0 && (childId > 0 || fragmentNodeId > 0)) {
                                            node = new ALFolder();
                                            ALFolderDescription folderDesc = new ALFolderDescription();
                                            if (childId > 0) {
                                                childIdStr = fragmentId > 0 && fragmentNodeId <= 0 ? fragmentId + ":" + childId : childId + "";
                                            }
                                            ((ALFolder)node).setFirstChildNodeId(childIdStr);
                                            String type = rs.getString(8);
                                            int intType = "header".equalsIgnoreCase(type) ? 1 : ("footer".equalsIgnoreCase(type) ? 2 : 0);
                                            folderDesc.setFolderType(intType);
                                            nodeDesc = folderDesc;
                                        } else {
                                            node = new ALChannel();
                                            ALChannelDescription channelDesc = new ALChannelDescription();
                                            channelDesc.setChannelPublishId(rs.getString(6));
                                            nodeDesc = channelDesc;
                                        }
                                        if (node.getNodeType() == 2) {
                                            nodeDesc.setName(rs.getString(7));
                                        }
                                        nodeDesc.setHidden("Y".equalsIgnoreCase(rs.getString(9)));
                                        nodeDesc.setImmutable("Y".equalsIgnoreCase(rs.getString(11)));
                                        nodeDesc.setUnremovable("Y".equalsIgnoreCase(rs.getString(10)));
                                        node.setPriority(rs.getInt(12));
                                        nodeDesc.setFragmentId(fragmentId > 0 ? fragmentId + "" : null);
                                        if (sql.equals(sqlLayout)) {
                                            nodeDesc.setFragmentNodeId(fragmentNodeId > 0 ? fragmentNodeId + "" : null);
                                        }
                                        if (fragmentId > 0 && fragmentNodeId <= 0) {
                                            nodeDesc.setId(fragmentId + ":" + structId);
                                        } else {
                                            nodeDesc.setId(structId != -1 ? structId + "" : "lost_folder");
                                        }
                                        if (nextId != 0) {
                                            String nextIdStr = fragmentId > 0 && fragmentNodeId <= 0 ? fragmentId + ":" + nextId : nextId + "";
                                            node.setNextNodeId(nextIdStr);
                                        }
                                        switch (prntId) {
                                            case 0: {
                                                parentId = "userLayoutRootNode";
                                                break;
                                            }
                                            case -1: {
                                                parentId = "lost_folder";
                                                break;
                                            }
                                            default: {
                                                parentId = fragmentId > 0 && fragmentNodeId <= 0 ? fragmentId + ":" + prntId : prntId + "";
                                            }
                                        }
                                        node.setParentNodeId(parentId);
                                        if (prevId != 0) {
                                            String prevIdStr = fragmentId > 0 && fragmentNodeId <= 0 ? fragmentId + ":" + prevId : prevId + "";
                                            node.setPreviousNodeId(prevIdStr);
                                        }
                                        lastStructId = structId;
                                        String fragmentNodeIdStr = nodeDesc.getFragmentNodeId();
                                        String fragmentIdStr = nodeDesc.getFragmentId();
                                        String nodeIdStr = structId + "";
                                        String key2 = fragmentId + ":" + structId;
                                        node.setNodeDescription((IALNodeDescription)((Object)nodeDesc));
                                        if (fragmentNodeIdStr != null) {
                                            fragmentNodes.put(fragmentIdStr + ":" + fragmentNodeIdStr, node);
                                        } else if (fragmentIdStr != null && fragmentNodes.containsKey(key2)) {
                                            ALNode fragNode = (ALNode)fragmentNodes.get(key2);
                                            nodeDesc.setId(fragNode.getId());
                                            nodeDesc.setFragmentNodeId(fragNode.getFragmentNodeId());
                                            fragNode.setNodeDescription((IALNodeDescription)((Object)nodeDesc));
                                            if (fragNode.getNodeType() == 2) {
                                                ((ALFolder)fragNode).setFirstChildNodeId(childIdStr);
                                            }
                                            layoutData.put(nodeDesc.getId(), fragNode);
                                        } else {
                                            layoutData.put(nodeDesc.getId(), node);
                                        }
                                        IALChannelDescription channelDesc = null;
                                        if (node.getNodeType() == 1) {
                                            channelDesc = (IALChannelDescription)((Object)nodeDesc);
                                            chanIds.add(nodeDesc.getId());
                                        }
                                        PreparedStatement psRestr = null;
                                        if (sql.equals(sqlLayout) && fragmentNodeId <= 0) {
                                            psRestr = con.prepareStatement(restrLayoutSQL);
                                            psRestr.setInt(1, structId);
                                        } else {
                                            psRestr = con.prepareStatement(restrFragmentSQL);
                                            psRestr.setInt(1, fragmentId);
                                            psRestr.setInt(2, fragmentNodeId > 0 ? fragmentNodeId : structId);
                                        }
                                        ResultSet rsRestr = psRestr.executeQuery();
                                        while (rsRestr.next()) {
                                            int restrType = rsRestr.getInt(1);
                                            String restrExp = rsRestr.getString(2);
                                            String restrPath = rsRestr.getString(3);
                                            if (restrPath == null || restrPath.trim().length() == 0) {
                                                restrPath = UserLayoutRestriction.LOCAL_RESTRICTION;
                                            }
                                            IUserLayoutRestriction restriction = UserLayoutRestrictionFactory.createRestriction(restrType, restrExp, restrPath);
                                            nodeDesc.addRestriction(restriction);
                                        }
                                        rsRestr.close();
                                        if (psRestr != null) {
                                            psRestr.close();
                                        }
                                        int n = index = sql.equals(sqlLayout) ? 15 : 14;
                                        if (RDBMServices.supportsOuterJoins) {
                                            do {
                                                String name = rs.getString(index);
                                                String value = rs.getString(index + 1);
                                                if (name != null && channelDesc != null) {
                                                    channelDesc.setParameterValue(name, value);
                                                }
                                                if (!rs.next()) {
                                                    break block97;
                                                }
                                                structId = rs.getInt(1);
                                                if (!rs.wasNull()) continue;
                                                structId = 0;
                                            } while (structId == lastStructId);
                                        } else {
                                            if (node.getNodeType() == 1) {
                                                structParms.append(sepChar + chanId);
                                                sepChar = ",";
                                            }
                                            if (!rs.next()) break;
                                            structId = rs.getInt(1);
                                            if (rs.wasNull()) {
                                                structId = 0;
                                            }
                                        }
                                        if ((priorityRestriction = AggregatedLayoutManager.getPriorityRestriction(node)) == null) continue;
                                        int priority = node.getPriority();
                                        int[] range = priorityRestriction.getRange();
                                        int newPriority = priority;
                                        if (range[0] > priority) {
                                            newPriority = range[0];
                                        } else if (range[1] < priority) {
                                            newPriority = range[1];
                                        }
                                        if (newPriority == priority) continue;
                                        node.setPriority(newPriority);
                                    }
                                }
                                finally {
                                    rs.close();
                                }
                            }
                            if (chanIds.size() > 0) {
                                for (int i = 0; i < chanIds.size(); ++i) {
                                    key = (String)chanIds.get(i);
                                    ALNode node = (ALNode)layoutData.get(key);
                                    this.fillChannelDescription((IALChannelDescription)node.getNodeDescription());
                                }
                                chanIds.clear();
                            }
                            if (!RDBMServices.supportsOuterJoins && structParms.length() > 0) {
                                String paramSql = "SELECT STRUCT_ID, STRUCT_PARM_NM,STRUCT_PARM_VAL FROM UP_LAYOUT_PARAM WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND STRUCT_ID IN (" + structParms.toString() + ") ORDER BY STRUCT_ID";
                                LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): " + paramSql);
                                Statement st = con.createStatement();
                                rs = st.executeQuery(paramSql);
                                try {
                                    ALNode node;
                                    if (!rs.next()) break block98;
                                    structId = rs.getInt(1);
                                    while ((node = (ALNode)layoutData.get(structId + "")) != null) {
                                        IALChannelDescription channelDesc = (IALChannelDescription)node.getNodeDescription();
                                        int lastStructId = structId;
                                        do {
                                            String name = rs.getString(2);
                                            String value = rs.getString(3);
                                            channelDesc.setParameterValue(name, value);
                                            if (rs.next()) continue;
                                            break block98;
                                        } while ((structId = rs.getInt(1)) == lastStructId);
                                    }
                                }
                                finally {
                                    rs.close();
                                    st.close();
                                }
                            }
                        }
                        sql = sqlFragment;
                    }
                    ALNode lastNode = null;
                    ALNode prevNode = null;
                    String nextId = rootNode.getFirstChildNodeId();
                    while (nextId != null) {
                        lastNode = (ALNode)layoutData.get(nextId);
                        if (lastNode == null) {
                            if (prevNode == null) break;
                            prevNode.setNextNodeId(null);
                            lastNode = prevNode;
                            break;
                        }
                        nextId = lastNode.getNextNodeId();
                        prevNode = lastNode;
                    }
                    if (pushFragmentRoots != null) {
                        Enumeration fragmentIds = pushFragmentRoots.keys();
                        while (fragmentIds.hasMoreElements()) {
                            String strFragmentId = fragmentIds.nextElement().toString();
                            String strFragmentRootId = pushFragmentRoots.get(strFragmentId).toString();
                            String key3 = strFragmentId + ":" + strFragmentRootId;
                            ALNode node = (ALNode)layoutData.get(key3);
                            if (node == null) continue;
                            IALNodeDescription nodeDesc = node.getNodeDescription();
                            String newId = this.getNextStructId(person, "");
                            nodeDesc.setId(newId);
                            nodeDesc.setFragmentNodeId(strFragmentRootId);
                            layoutData.remove(key3);
                            layoutData.put(newId, node);
                            if (lastNode != null) {
                                lastNode.setNextNodeId(newId);
                                node.setPreviousNodeId(lastNode.getId());
                            } else {
                                rootNode.setFirstChildNodeId(newId);
                            }
                            if (node.getNodeType() == 2) {
                                String nextIdStr = ((ALFolder)node).getFirstChildNodeId();
                                while (nextIdStr != null) {
                                    ALNode child = (ALNode)layoutData.get(nextIdStr);
                                    child.setParentNodeId(newId);
                                    nextIdStr = child.getNextNodeId();
                                }
                            }
                            node.setParentNodeId("userLayoutRootNode");
                            lastNode = node;
                        }
                    }
                    Enumeration fragmentNodesEnum = fragmentNodes.keys();
                    while (fragmentNodesEnum.hasMoreElements()) {
                        key = fragmentNodesEnum.nextElement().toString();
                        ALNode node = (ALNode)fragmentNodes.get(key);
                        if (node.getNodeType() != 2) continue;
                        String parentId = node.getId();
                        String nextIdStr = ((ALFolder)node).getFirstChildNodeId();
                        while (nextIdStr != null) {
                            ALNode child = (ALNode)layoutData.get(nextIdStr);
                            child.setParentNodeId(parentId);
                            nextIdStr = child.getNextNodeId();
                        }
                    }
                    long stopTime = System.currentTimeMillis();
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to create");
                    Object var61_91 = null;
                    if (insertStmt == null) break block99;
                }
                catch (Throwable throwable) {
                    Object var61_92 = null;
                    if (insertStmt != null) {
                        insertStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                insertStmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                LogService.log(LogService.ERROR, e);
                throw new PortalException(e);
            }
            catch (Throwable throwable) {
                RDBMServices.releaseConnection(con);
                throw throwable;
            }
        }
        RDBMServices.releaseConnection(con);
        layout.setLayoutData(layoutData);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAggregatedLayout getFragment(IPerson person, String fragmentIdStr) throws PortalException {
        int userId = person.getID();
        int fragmentId = CommonUtils.parseInt(fragmentIdStr);
        int realUserId = userId;
        AggregatedLayout layout = new AggregatedLayout(fragmentIdStr);
        Connection con = null;
        Hashtable<String, ALNode> layoutData = null;
        ALFolder rootNode = new ALFolder();
        try {
            PreparedStatement psFragment;
            long startTime;
            Statement stmt;
            block49: {
                int structId;
                StringBuffer structParms;
                List<String> chanIds;
                ResultSet rs;
                block48: {
                    con = RDBMServices.getConnection();
                    RDBMServices.setAutoCommit(con, false);
                    stmt = con.createStatement();
                    layoutData = new Hashtable<String, ALNode>();
                    startTime = System.currentTimeMillis();
                    String restrFragmentSQL = "SELECT RESTRICTION_TYPE, RESTRICTION_VALUE, RESTRICTION_TREE_PATH FROM UP_FRAGMENT_RESTRICTIONS WHERE FRAGMENT_ID=? AND NODE_ID=?";
                    int firstStructId = -1;
                    String sQuery = "SELECT FRAGMENT_ROOT_ID FROM UP_OWNER_FRAGMENT WHERE FRAGMENT_ID=" + fragmentId + " AND OWNER_ID = " + userId;
                    rs = stmt.executeQuery(sQuery);
                    try {
                        rs.next();
                        firstStructId = rs.getInt(1);
                    }
                    finally {
                        rs.close();
                    }
                    rootNode = ALFolder.createRootFolder();
                    rootNode.setFirstChildNodeId(firstStructId + "");
                    layoutData.put("userLayoutRootNode", rootNode);
                    layoutData.put("lost_folder", ALFolder.createLostFolder());
                    String sqlFragment = "SELECT DISTINCT UF.NODE_ID,UF.NEXT_NODE_ID,UF.CHLD_NODE_ID,UF.PREV_NODE_ID,UF.PRNT_NODE_ID,UF.CHAN_ID,UF.NAME,UF.TYPE,UF.HIDDEN,UF.UNREMOVABLE,UF.IMMUTABLE,UF.PRIORITY,UF.FRAGMENT_ID";
                    sqlFragment = RDBMServices.supportsOuterJoins ? sqlFragment + ",UFP.PARAM_NAME,UFP.PARAM_VALUE FROM UP_OWNER_FRAGMENT UOF, " + fragmentJoinQuery : sqlFragment + " FROM UP_FRAGMENTS UF, UP_OWNER_FRAGMENT UOF WHERE ";
                    sqlFragment = sqlFragment + " UF.FRAGMENT_ID=UOF.FRAGMENT_ID AND UOF.OWNER_ID=? AND UOF.FRAGMENT_ID=?";
                    LogService.log(LogService.DEBUG, sqlFragment);
                    psFragment = con.prepareStatement(sqlFragment);
                    psFragment.setInt(1, userId);
                    psFragment.setInt(2, fragmentId);
                    chanIds = Collections.synchronizedList(new ArrayList());
                    structParms = new StringBuffer();
                    rs = psFragment.executeQuery();
                    try {
                        int lastStructId = 0;
                        String sepChar = "";
                        if (!rs.next()) break block48;
                        structId = rs.getInt(1);
                        while (true) {
                            PriorityRestriction priorityRestriction;
                            String parentId;
                            ALNode node;
                            int nextId = rs.getInt(2);
                            int childId = rs.getInt(3);
                            int prevId = rs.getInt(4);
                            int prntId = rs.getInt(5);
                            int chanId = rs.getInt(6);
                            boolean fragmentNodeId = false;
                            UserLayoutNodeDescription nodeDesc = null;
                            Object childIdStr = null;
                            if (childId > 0) {
                                node = new ALFolder();
                                ALFolderDescription folderDesc = new ALFolderDescription();
                                ((ALFolder)node).setFirstChildNodeId(childId + "");
                                String type = rs.getString(8);
                                int intType = "header".equalsIgnoreCase(type) ? 1 : ("footer".equalsIgnoreCase(type) ? 2 : 0);
                                folderDesc.setFolderType(intType);
                                nodeDesc = folderDesc;
                            } else {
                                node = new ALChannel();
                                ALChannelDescription channelDesc = new ALChannelDescription();
                                channelDesc.setChannelPublishId(rs.getString(6));
                                nodeDesc = channelDesc;
                            }
                            if (node.getNodeType() == 2) {
                                nodeDesc.setName(rs.getString(7));
                            }
                            nodeDesc.setHidden("Y".equalsIgnoreCase(rs.getString(9)));
                            nodeDesc.setImmutable("Y".equalsIgnoreCase(rs.getString(11)));
                            nodeDesc.setUnremovable("Y".equalsIgnoreCase(rs.getString(10)));
                            node.setPriority(rs.getInt(12));
                            nodeDesc.setFragmentId(fragmentIdStr);
                            nodeDesc.setId(structId + "");
                            if (nextId != 0) {
                                node.setNextNodeId(nextId + "");
                            }
                            switch (prntId) {
                                case 0: {
                                    parentId = "userLayoutRootNode";
                                    break;
                                }
                                case -1: {
                                    parentId = "lost_folder";
                                    break;
                                }
                                default: {
                                    parentId = prntId + "";
                                }
                            }
                            node.setParentNodeId(parentId);
                            if (prevId != 0) {
                                node.setPreviousNodeId(prevId + "");
                            }
                            lastStructId = structId;
                            node.setNodeDescription((IALNodeDescription)((Object)nodeDesc));
                            layoutData.put(nodeDesc.getId(), node);
                            IALChannelDescription channelDesc = null;
                            if (node.getNodeType() == 1) {
                                channelDesc = (IALChannelDescription)((Object)nodeDesc);
                                chanIds.add(nodeDesc.getId());
                            }
                            PreparedStatement psRestr = null;
                            psRestr = con.prepareStatement(restrFragmentSQL);
                            psRestr.setInt(1, fragmentId);
                            psRestr.setInt(2, structId);
                            ResultSet rsRestr = psRestr.executeQuery();
                            while (rsRestr.next()) {
                                int restrType = rsRestr.getInt(1);
                                String restrExp = rsRestr.getString(2);
                                String restrPath = rsRestr.getString(3);
                                if (restrPath == null || restrPath.trim().length() == 0) {
                                    restrPath = UserLayoutRestriction.LOCAL_RESTRICTION;
                                }
                                IUserLayoutRestriction restriction = UserLayoutRestrictionFactory.createRestriction(restrType, restrExp, restrPath);
                                nodeDesc.addRestriction(restriction);
                            }
                            rsRestr.close();
                            if (psRestr != null) {
                                psRestr.close();
                            }
                            if (RDBMServices.supportsOuterJoins) {
                                do {
                                    String name = rs.getString(14);
                                    String value = rs.getString(15);
                                    if (name != null && channelDesc != null) {
                                        channelDesc.setParameterValue(name, value);
                                    }
                                    if (!rs.next()) {
                                        break block48;
                                    }
                                    structId = rs.getInt(1);
                                    if (!rs.wasNull()) continue;
                                    structId = 0;
                                } while (structId == lastStructId);
                            } else {
                                if (node.getNodeType() == 1) {
                                    structParms.append(sepChar + chanId);
                                    sepChar = ",";
                                }
                                if (!rs.next()) break;
                                structId = rs.getInt(1);
                                if (rs.wasNull()) {
                                    structId = 0;
                                }
                            }
                            if ((priorityRestriction = AggregatedLayoutManager.getPriorityRestriction(node)) == null) continue;
                            int priority = node.getPriority();
                            int[] range = priorityRestriction.getRange();
                            int newPriority = priority;
                            if (range[0] > priority) {
                                newPriority = range[0];
                            } else if (range[1] < priority) {
                                newPriority = range[1];
                            }
                            if (newPriority == priority) continue;
                            node.setPriority(newPriority);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                if (chanIds.size() > 0) {
                    for (int i = 0; i < chanIds.size(); ++i) {
                        String key = (String)chanIds.get(i);
                        ALNode node = (ALNode)layoutData.get(key);
                        this.fillChannelDescription((IALChannelDescription)node.getNodeDescription());
                    }
                    chanIds.clear();
                }
                if (!RDBMServices.supportsOuterJoins && structParms.length() > 0) {
                    String sql = "SELECT NODE_ID, PARAM_NAME, PARAM_VALUE FROM UP_FRAGMENT_PARAM WHERE FRAGMENT_ID=" + fragmentId + " AND NODE_ID IN (" + structParms.toString() + ") ORDER BY NODE_ID";
                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getFragment(): " + sql);
                    Statement st = con.createStatement();
                    rs = st.executeQuery(sql);
                    try {
                        if (!rs.next()) break block49;
                        structId = rs.getInt(1);
                        while (true) {
                            ALNode node;
                            if ((node = (ALNode)layoutData.get(structId + "")) == null || node.getNodeType() != 1) {
                                continue;
                            }
                            IALChannelDescription channelDesc = (IALChannelDescription)node.getNodeDescription();
                            int lastStructId = structId;
                            do {
                                String name = rs.getString(2);
                                String value = rs.getString(3);
                                channelDesc.setParameterValue(name, value);
                                if (rs.next()) continue;
                                break block49;
                            } while ((structId = rs.getInt(1)) == lastStructId);
                        }
                    }
                    finally {
                        rs.close();
                        st.close();
                    }
                }
            }
            if (psFragment != null) {
                psFragment.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            long stopTime = System.currentTimeMillis();
            LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getFragment(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to create");
        }
        catch (Exception e) {
            e.printStackTrace();
            LogService.log(LogService.ERROR, e);
            throw new PortalException(e);
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        layout.setLayoutData(layoutData);
        return layout;
    }

    private void fillChannelDescription(IALChannelDescription channelDesc) throws Exception {
        ChannelDefinition channelDef;
        String publishId = channelDesc.getChannelPublishId();
        if (publishId != null && (channelDef = this.crs.getChannelDefinition(CommonUtils.parseInt(publishId))) != null) {
            channelDesc.setChannelTypeId(channelDef.getTypeId() + "");
            channelDesc.setClassName(channelDef.getJavaClass());
            channelDesc.setDescription(channelDef.getDescription());
            channelDesc.setEditable(channelDef.isEditable());
            channelDesc.setFunctionalName(CommonUtils.nvl(channelDef.getFName()));
            channelDesc.setHasAbout(channelDef.hasAbout());
            channelDesc.setHasHelp(channelDef.hasHelp());
            channelDesc.setIsSecure(channelDef.isSecure());
            channelDesc.setName(channelDef.getName());
            channelDesc.setTitle(channelDef.getTitle());
            channelDesc.setChannelPublishId(channelDef.getId() + "");
            ChannelParameter[] channelParams = channelDef.getParameters();
            for (int j = 0; j < channelParams.length; ++j) {
                String paramName = channelParams[j].getName();
                if (channelDesc.getParameterValue(paramName) != null) continue;
                channelDesc.setParameterOverride(paramName, channelParams[j].getOverride());
                channelDesc.setParameterValue(paramName, channelParams[j].getValue());
            }
            channelDesc.setTimeout(channelDef.getTimeout());
            channelDesc.setTitle(channelDef.getTitle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getNextFragmentId() throws PortalException {
        int attemptsNumber = 20;
        Statement stmt = null;
        try {
            Connection con;
            block13: {
                String string;
                block11: {
                    block12: {
                        con = RDBMServices.getConnection();
                        try {
                            RDBMServices.setAutoCommit(con, false);
                            stmt = con.createStatement();
                            String sQuery = "SELECT SEQUENCE_VALUE FROM UP_SEQUENCE WHERE SEQUENCE_NAME='UP_FRAGMENT'";
                            for (int i = 0; i < attemptsNumber; ++i) {
                                try {
                                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getNextFragmentId(): " + sQuery);
                                    ResultSet rs = stmt.executeQuery(sQuery);
                                    int currentId = 0;
                                    rs.next();
                                    currentId = rs.getInt(1);
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    String sUpdate = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=" + (currentId + 1) + " WHERE SEQUENCE_NAME='UP_FRAGMENT'";
                                    LogService.log(LogService.DEBUG, "AggregatedUserLayoutStore::getNextFragmentId(): " + sUpdate);
                                    stmt.executeUpdate(sUpdate);
                                    RDBMServices.commit(con);
                                    string = new String(currentId + 1 + "");
                                }
                                catch (Exception sqle) {
                                    RDBMServices.rollback(con);
                                    Thread.sleep(500L);
                                    continue;
                                }
                                Object var11_12 = null;
                                if (stmt == null) break block11;
                                break block12;
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            if (stmt != null) {
                                stmt.close();
                            }
                            RDBMServices.releaseConnection(con);
                            throw throwable;
                        }
                    }
                    stmt.close();
                }
                RDBMServices.releaseConnection(con);
                return string;
            }
            Object var11_13 = null;
            if (stmt != null) {
                stmt.close();
            }
            RDBMServices.releaseConnection(con);
            throw new PortalException("Unable to generate a new next fragment node id!");
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeStylesheetUserPreferences getThemeStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        ThemeStylesheetUserPreferences tsup;
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String pName;
                ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(stylesheetId);
                String sQuery = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences(): " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        tsd.setStylesheetParameterDefaultValue(rs.getString(1), rs.getString(2));
                    }
                }
                finally {
                    rs.close();
                }
                tsup = new ThemeStylesheetUserPreferences();
                tsup.setStylesheetId(stylesheetId);
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.putParameterValue(pName, tsd.getStylesheetParameterDefaultValue(pName));
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.addChannelAttribute(pName, tsd.getChannelAttributeDefaultValue(pName));
                }
                sQuery = "SELECT PARAM_TYPE, PARAM_NAME, PARAM_VAL, ULS.NODE_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT_AGGR ULS WHERE UUSA.USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND UUSA.STRUCT_ID = ULS.NODE_ID AND UUSA.USER_ID = ULS.USER_ID";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        int param_type = rs.getInt(1);
                        if (rs.wasNull()) {
                            param_type = 0;
                        }
                        int structId = rs.getInt(4);
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type == 1) {
                            LogService.log(LogService.ERROR, "AggregatedUserLayoutStore::getThemeStylesheetUserPreferences() :  stylesheet global params should be specified in the user defaults table ! UP_SS_USER_ATTS is corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 2) {
                            LogService.log(LogService.ERROR, "AggregatedUserLayoutStore::getThemeStylesheetUserPreferences() :  folder attribute specified for the theme stylesheet! UP_SS_USER_ATTS corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 3) {
                            tsup.setChannelAttributeValue(this.getStructId(structId, chanId), rs.getString(2), rs.getString(3));
                            continue;
                        }
                        LogService.log(LogService.ERROR, "AggregatedUserLayoutStore::getThemeStylesheetUserPreferences() : unknown param type encountered! DB corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return tsup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureStylesheetUserPreferences getStructureStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        StructureStylesheetUserPreferences ssup;
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String pName;
                String sQuery;
                int layoutId;
                StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(stylesheetId);
                String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + subSelectString);
                ResultSet rs = stmt.executeQuery(subSelectString);
                try {
                    rs.next();
                    layoutId = rs.getInt(1);
                    if (rs.wasNull()) {
                        layoutId = 0;
                    }
                }
                finally {
                    rs.close();
                }
                if (layoutId == 0) {
                    sQuery = "SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID=" + userId;
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                    rs = stmt.executeQuery(sQuery);
                    try {
                        rs.next();
                        userId = rs.getInt(1);
                    }
                    finally {
                        rs.close();
                    }
                }
                sQuery = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ssd.setStylesheetParameterDefaultValue(rs.getString(1), rs.getString(2));
                    }
                }
                finally {
                    rs.close();
                }
                ssup = new StructureStylesheetUserPreferences();
                ssup.setStylesheetId(stylesheetId);
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.putParameterValue(pName, ssd.getStylesheetParameterDefaultValue(pName));
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addChannelAttribute(pName, ssd.getChannelAttributeDefaultValue(pName));
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addFolderAttribute(pName, ssd.getFolderAttributeDefaultValue(pName));
                }
                sQuery = "SELECT PARAM_NAME, PARAM_VAL, PARAM_TYPE, ULS.NODE_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT_AGGR ULS WHERE UUSA.USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND UUSA.STRUCT_ID = ULS.NODE_ID AND UUSA.USER_ID = ULS.USER_ID";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        String temp1 = rs.getString(1);
                        String temp2 = rs.getString(2);
                        int param_type = rs.getInt(3);
                        int structId = rs.getInt(4);
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type == 1) {
                            LogService.log(LogService.ERROR, "AggregatedUserLayoutStore::getStructureStylesheetUserPreferences() :  stylesheet global params should be specified in the user defaults table ! UP_SS_USER_ATTS is corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + temp1 + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 2) {
                            ssup.setFolderAttributeValue(this.getStructId(structId, chanId), temp1, temp2);
                            continue;
                        }
                        if (param_type == 3) {
                            ssup.setChannelAttributeValue(this.getStructId(structId, chanId), temp1, temp2);
                            continue;
                        }
                        LogService.log(LogService.ERROR, "AggregatedUserLayoutStore::getStructureStylesheetUserPreferences() : unknown param type encountered! DB corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + temp1 + "\", param_type=" + Integer.toString(param_type));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return ssup;
    }

    public Enumeration getIncorrectPushedFragmentNodes(IPerson person, UserProfile profile) throws PortalException {
        int userId = person.getID();
        int layoutId = profile.getLayoutId();
        Vector<String> incorrectIds = new Vector<String>();
        Connection con = RDBMServices.getConnection();
        try {
            IGroupMember groupPerson = null;
            String query1 = "SELECT ULS.FRAGMENT_ID,ULS.NODE_ID,UGF.GROUP_KEY FROM UP_LAYOUT_STRUCT_AGGR ULS,UP_OWNER_FRAGMENT UOF,UP_GROUP_FRAGMENT UGF WHERE UOF.PUSHED_FRAGMENT='Y' AND ULS.USER_ID=" + userId + " AND ULS.LAYOUT_ID=" + layoutId + " AND ULS.FRAGMENT_ID=UOF.FRAGMENT_ID AND ULS.FRAGMENT_ID=UGF.FRAGMENT_ID";
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query1);
            Object fragmentIds = null;
            HashSet<String> groupKeys = new HashSet<String>();
            while (rs.next()) {
                if (groupPerson == null) {
                    EntityIdentifier personIdentifier = person.getEntityIdentifier();
                    groupPerson = GroupService.getGroupMember(personIdentifier);
                }
                int fragmentId = rs.getInt(1);
                int nodeId = rs.getInt(2);
                String groupKey = rs.getString(3);
                if (groupKeys.contains(groupKey)) {
                    incorrectIds.add(nodeId + "");
                    continue;
                }
                IEntityGroup group = GroupService.findGroup(groupKey);
                if (group != null && groupPerson.isDeepMemberOf(group)) continue;
                incorrectIds.add(nodeId + "");
                groupKeys.add(groupKey);
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return incorrectIds.elements();
    }
}

