/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCachingService;
import org.jasig.portal.concurrency.IEntityCachingServiceFactory;
import org.jasig.portal.services.LogService;

public class EntityCachingService {
    private static EntityCachingService instance = null;
    private IEntityCachingService cache = null;

    private EntityCachingService() throws CachingException {
        this.initialize();
    }

    public void add(IBasicEntity ent) throws CachingException {
        this.cache.add(ent);
    }

    public IBasicEntity get(Class type, String key) throws CachingException {
        return this.cache.get(type, key);
    }

    public IBasicEntity get(EntityIdentifier entityID) throws CachingException {
        return this.cache.get(entityID.getType(), entityID.getKey());
    }

    private void initialize() throws CachingException {
        String eMsg = null;
        String factoryName = PropertiesManager.getProperty("org.jasig.portal.concurrency.IEntityCachingServiceFactory");
        if (factoryName == null) {
            eMsg = "EntityCachingService.initialize(): No entry for org.jasig.portal.concurrency.caching.IEntityCachingServiceFactory in portal.properties.";
            LogService.log(LogService.ERROR, eMsg);
            throw new CachingException(eMsg);
        }
        try {
            IEntityCachingServiceFactory cachingServiceFactory = (IEntityCachingServiceFactory)Class.forName(factoryName).newInstance();
            this.cache = cachingServiceFactory.newCachingService();
        }
        catch (Exception e) {
            eMsg = "EntityCachingService.initialize(): Problem creating entity caching service... " + e.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new CachingException(eMsg);
        }
    }

    public static synchronized EntityCachingService instance() throws CachingException {
        if (instance == null) {
            instance = new EntityCachingService();
        }
        return instance;
    }

    public void remove(Class type, String key) throws CachingException {
        this.cache.remove(type, key);
    }

    public void remove(EntityIdentifier entityID) throws CachingException {
        this.remove(entityID.getType(), entityID.getKey());
    }

    public void remove(IBasicEntity ent) throws CachingException {
        this.remove(ent.getEntityIdentifier());
    }

    public static synchronized EntityCachingService start() throws CachingException {
        return EntityCachingService.instance();
    }

    public void update(IBasicEntity ent) throws CachingException {
        this.cache.update(ent);
    }
}

