/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.stats.IStatsRecorder;
import org.jasig.portal.services.stats.IStatsRecorderFactory;
import org.jasig.portal.services.stats.RecordChannelAddedToLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordChannelDefinitionModifiedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelDefinitionPublishedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelDefinitionRemovedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelInstantiatedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelMovedInLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordChannelRemovedFromLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordChannelRenderedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelTargetedWorkerTask;
import org.jasig.portal.services.stats.RecordChannelUpdatedInLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordFolderAddedToLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordFolderMovedInLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordFolderRemovedFromLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordFolderUpdatedInLayoutWorkerTask;
import org.jasig.portal.services.stats.RecordLoginWorkerTask;
import org.jasig.portal.services.stats.RecordLogoutWorkerTask;
import org.jasig.portal.services.stats.RecordSessionCreatedWorkerTask;
import org.jasig.portal.services.stats.RecordSessionDestroyedWorkerTask;
import org.jasig.portal.services.stats.StatsRecorderLayoutEventListener;
import org.jasig.portal.services.stats.StatsRecorderSettings;
import org.jasig.portal.utils.threading.BoundedThreadPool;
import org.jasig.portal.utils.threading.ThreadPool;
import org.jasig.portal.utils.threading.WorkTracker;

public class StatsRecorder {
    protected static StatsRecorder statsRecorderInstance;
    protected StatsRecorderSettings statsRecorderSettings;
    protected IStatsRecorder statsRecorder;
    protected ThreadPool threadPool;

    private StatsRecorder() {
        try {
            String statsRecorderFactoryName = PropertiesManager.getProperty("org.jasig.portal.services.stats.StatsRecorderFactory.implementation");
            IStatsRecorderFactory statsRecorderFactory = (IStatsRecorderFactory)Class.forName(statsRecorderFactoryName).newInstance();
            this.statsRecorder = statsRecorderFactory.getStatsRecorder();
            this.statsRecorderSettings = StatsRecorderSettings.instance();
            String prefix = this.getClass().getName() + ".threadPool_";
            int initialThreads = PropertiesManager.getPropertyAsInt(prefix + "initialThreads");
            int maxThreads = PropertiesManager.getPropertyAsInt(prefix + "maxThreads");
            int threadPriority = PropertiesManager.getPropertyAsInt(prefix + "threadPriority");
            this.threadPool = new BoundedThreadPool(initialThreads, maxThreads, threadPriority);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    private static final synchronized StatsRecorder instance() {
        if (statsRecorderInstance == null) {
            statsRecorderInstance = new StatsRecorder();
        }
        return statsRecorderInstance;
    }

    public static final StatsRecorderLayoutEventListener newLayoutEventListener(IPerson person, UserProfile profile) {
        return new StatsRecorderLayoutEventListener(person, profile);
    }

    public static boolean get(int setting) {
        return StatsRecorder.instance().statsRecorderSettings.get(setting);
    }

    public static void set(int setting, boolean newValue) {
        StatsRecorder.instance().statsRecorderSettings.set(setting, newValue);
    }

    public static void recordLogin(IPerson person) {
        if (StatsRecorder.instance().statsRecorderSettings.get(0)) {
            RecordLoginWorkerTask task = new RecordLoginWorkerTask(person);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordLogout(IPerson person) {
        if (StatsRecorder.instance().statsRecorderSettings.get(1)) {
            RecordLogoutWorkerTask task = new RecordLogoutWorkerTask(person);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordSessionCreated(IPerson person) {
        if (StatsRecorder.instance().statsRecorderSettings.get(2)) {
            RecordSessionCreatedWorkerTask task = new RecordSessionCreatedWorkerTask(person);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordSessionDestroyed(IPerson person) {
        if (StatsRecorder.instance().statsRecorderSettings.get(3)) {
            RecordSessionDestroyedWorkerTask task = new RecordSessionDestroyedWorkerTask(person);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelDefinitionPublished(IPerson person, ChannelDefinition channelDef) {
        if (StatsRecorder.instance().statsRecorderSettings.get(4)) {
            RecordChannelDefinitionPublishedWorkerTask task = new RecordChannelDefinitionPublishedWorkerTask(person, channelDef);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelDefinitionModified(IPerson person, ChannelDefinition channelDef) {
        if (StatsRecorder.instance().statsRecorderSettings.get(5)) {
            RecordChannelDefinitionModifiedWorkerTask task = new RecordChannelDefinitionModifiedWorkerTask(person, channelDef);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelDefinitionRemoved(IPerson person, ChannelDefinition channelDef) {
        if (StatsRecorder.instance().statsRecorderSettings.get(6)) {
            RecordChannelDefinitionRemovedWorkerTask task = new RecordChannelDefinitionRemovedWorkerTask(person, channelDef);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelAddedToLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(7)) {
            RecordChannelAddedToLayoutWorkerTask task = new RecordChannelAddedToLayoutWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelUpdatedInLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(8)) {
            RecordChannelUpdatedInLayoutWorkerTask task = new RecordChannelUpdatedInLayoutWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelMovedInLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(9)) {
            RecordChannelMovedInLayoutWorkerTask task = new RecordChannelMovedInLayoutWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelRemovedFromLayout(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(10)) {
            RecordChannelRemovedFromLayoutWorkerTask task = new RecordChannelRemovedFromLayoutWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordFolderAddedToLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(11)) {
            RecordFolderAddedToLayoutWorkerTask task = new RecordFolderAddedToLayoutWorkerTask(person, profile, folderDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordFolderUpdatedInLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(12)) {
            RecordFolderUpdatedInLayoutWorkerTask task = new RecordFolderUpdatedInLayoutWorkerTask(person, profile, folderDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordFolderMovedInLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(13)) {
            RecordFolderMovedInLayoutWorkerTask task = new RecordFolderMovedInLayoutWorkerTask(person, profile, folderDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordFolderRemovedFromLayout(IPerson person, UserProfile profile, IUserLayoutFolderDescription folderDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(14)) {
            RecordFolderRemovedFromLayoutWorkerTask task = new RecordFolderRemovedFromLayoutWorkerTask(person, profile, folderDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelInstantiated(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(15)) {
            RecordChannelInstantiatedWorkerTask task = new RecordChannelInstantiatedWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelRendered(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(16)) {
            RecordChannelRenderedWorkerTask task = new RecordChannelRenderedWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }

    public static void recordChannelTargeted(IPerson person, UserProfile profile, IUserLayoutChannelDescription channelDesc) {
        if (StatsRecorder.instance().statsRecorderSettings.get(17)) {
            RecordChannelTargetedWorkerTask task = new RecordChannelTargetedWorkerTask(person, profile, channelDesc);
            task.setStatsRecorder(StatsRecorder.instance().statsRecorder);
            WorkTracker workTracker = StatsRecorder.instance().threadPool.execute(task);
        }
    }
}

