/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

public class XMLEscaper {
    public static String escape(String source) {
        String result = null;
        if (source != null) {
            StringBuffer sb = new StringBuffer(source.length() + 256);
            for (int i = 0; i < source.length(); ++i) {
                sb.append(XMLEscaper.escape(source.charAt(i)));
            }
            result = sb.toString();
        }
        return result;
    }

    public static String escape(char ch) {
        StringBuffer sb = new StringBuffer(10);
        String charRef = XMLEscaper.getEntityRef(ch);
        if (charRef != null) {
            sb.append('&');
            sb.append(charRef);
            sb.append(';');
        } else if (ch >= ' ' && ch <= '~' && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
            sb.append(ch);
        } else {
            sb.append("&#");
            sb.append(Integer.toString(ch));
            sb.append(';');
        }
        return sb.toString();
    }

    private static String getEntityRef(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: XMLEscaper \"<string to escape>\"");
        } else {
            String before = args[0];
            String after = XMLEscaper.escape(before);
            System.out.println("Before escaping: " + before);
            System.out.println(" After escaping: " + after);
        }
    }
}

