/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.slide.util.TxLRUObjectCache;
import org.apache.slide.util.logger.Logger;

public class ByteSizeLimitedObjectCache
extends TxLRUObjectCache {
    protected static final int MAX_FREEING_TRIES = 10;
    protected long globalByteSize;
    protected int txCacheSize;
    protected long txByteSize;
    protected long maxByteSizePerEntry;

    public ByteSizeLimitedObjectCache(int globalCacheSize, int txCacheSize, long globalByteSize, long txByteSize, long maxByteSizePerEntry, String name, Logger logger, boolean noGlobalCachingInsideTx) {
        super(globalCacheSize, name, logger, noGlobalCachingInsideTx);
        this.globalCache = new SizeCountingLRUMap(globalCacheSize, globalByteSize, maxByteSizePerEntry);
        this.globalByteSize = globalByteSize;
        this.txCacheSize = txCacheSize;
        this.txByteSize = txByteSize;
        this.maxByteSizePerEntry = maxByteSizePerEntry;
        this.logChannel = "ByteSizeLimitedObjectCache";
        if (name != null) {
            this.logChannel = this.logChannel + "." + name;
        }
    }

    public synchronized void clear() {
        super.clear();
    }

    public synchronized boolean canCache(Object txId, long byteSize) {
        long maxSize = txId != null ? this.globalByteSize : this.txByteSize;
        return maxSize >= byteSize && this.maxByteSizePerEntry >= byteSize;
    }

    public synchronized void put(Object txId, Object key, Object value, long byteSize) {
        if (key == null) {
            this.logger.log(txId + " adding null key with byte size " + byteSize, this.logChannel, 4);
        }
        if (txId != null) {
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            deleteCache.remove(key);
            SizeCountingLRUMap changeCache = (SizeCountingLRUMap)((Object)this.txChangeCaches.get(txId));
            changeCache.put(key, value, byteSize);
            if (this.loggingEnabled) {
                this.logger.log(txId + " added '" + key + "' with byte size " + byteSize, this.logChannel, 7);
            }
        } else {
            ((SizeCountingLRUMap)((Object)this.globalCache)).put(key, value, byteSize);
            if (this.loggingEnabled) {
                this.logger.log("Added '" + key + "' with byte size " + byteSize, this.logChannel, 7);
            }
        }
    }

    public synchronized void start(Object txId) {
        if (txId != null) {
            this.txChangeCaches.put(txId, new SizeCountingLRUMap(this.txCacheSize, this.txByteSize, this.maxByteSizePerEntry, txId));
            this.txDeleteCaches.put(txId, new HashSet());
        }
    }

    public synchronized void commit(Object txId) {
        if (txId != null) {
            SizeCountingLRUMap changeCache = (SizeCountingLRUMap)((Object)this.txChangeCaches.get(txId));
            Iterator it = changeCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                long byteSize = changeCache.getByteSize(entry.getKey());
                if (byteSize == -1L) {
                    this.globalCache.put(entry.getKey(), entry.getValue());
                    continue;
                }
                ((SizeCountingLRUMap)((Object)this.globalCache)).put(entry.getKey(), entry.getValue(), byteSize);
            }
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            Iterator it2 = deleteCache.iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                this.globalCache.remove(key);
            }
            if (this.loggingEnabled) {
                this.logger.log(txId + " committed " + changeCache.size() + " changes and " + deleteCache.size() + " scheduled deletes", this.logChannel, 7);
            }
            this.forget(txId);
        }
    }

    protected class SizeCountingLRUMap
    extends LRUMap {
        private Map shadowSizes = new HashMap();
        private long globalSize = 0L;
        private long maxByteSize;
        private long maxByteSizePerEntry;
        private Object txId;

        public SizeCountingLRUMap(int size, long maxByteSize, long maxByteSizePerEntry, Object txId) {
            this(size, maxByteSize, maxByteSizePerEntry);
            this.txId = txId;
        }

        public SizeCountingLRUMap(int size, long maxByteSize, long maxByteSizePerEntry) {
            super(size);
            this.maxByteSize = maxByteSize;
            this.maxByteSizePerEntry = maxByteSizePerEntry;
        }

        public Object put(Object key, Object value, long byteSize) {
            if (byteSize > this.maxByteSizePerEntry || byteSize > this.maxByteSize) {
                if (ByteSizeLimitedObjectCache.this.loggingEnabled) {
                    ByteSizeLimitedObjectCache.this.logger.log(this.txId + " for '" + key + "' is too big to be cached", ByteSizeLimitedObjectCache.this.logChannel, 7);
                }
                Object oldValue = this.get(key);
                this.invalidate(key);
                return oldValue;
            }
            this.freeBytes(key);
            for (int i = 0; this.globalSize + byteSize > this.maxByteSize && i < 10; ++i) {
                if (ByteSizeLimitedObjectCache.this.loggingEnabled) {
                    ByteSizeLimitedObjectCache.this.logger.log(this.txId + " for '" + key + "' needs " + Long.toString(this.globalSize + byteSize - this.maxByteSize) + " bytes more to be cached. Freeing bytes!", ByteSizeLimitedObjectCache.this.logChannel, 7);
                }
                this.removeLRU();
            }
            if (this.globalSize + byteSize <= this.maxByteSize) {
                this.shadowSizes.put(key, new Long(byteSize));
                this.globalSize += byteSize;
                return super.put(key, value);
            }
            Object oldValue = this.get(key);
            this.invalidate(key);
            return oldValue;
        }

        public long getByteSize(Object key) {
            Long lSize = (Long)this.shadowSizes.get(key);
            if (lSize != null) {
                return lSize;
            }
            return -1L;
        }

        protected void freeBytes(Object key) {
            Long lSize = (Long)this.shadowSizes.remove(key);
            if (lSize != null) {
                long size = lSize;
                this.globalSize -= size;
            }
        }

        protected void invalidate(Object key) {
            this.freeBytes(key);
            ByteSizeLimitedObjectCache.this.remove(this.txId, key);
            if (ByteSizeLimitedObjectCache.this.loggingEnabled) {
                ByteSizeLimitedObjectCache.this.logger.log(this.txId + " invalidated '" + key + "'", ByteSizeLimitedObjectCache.this.logChannel, 7);
            }
        }

        protected void processRemovedLRU(Object key, Object value) {
            this.invalidate(key);
        }
    }
}

