/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import org.apache.slide.util.HashMapEntryIterator;
import org.apache.slide.util.HashMapKeyIterator;
import org.apache.slide.util.Iterator;

public class HashMap {
    public static final int DEFAULT_SIZE = 17;
    private Bucket[] table = null;
    private int elementCount = 0;

    public HashMap() {
        this(17);
    }

    public HashMap(int size) {
        if (size <= 0) {
            size = 17;
        }
        this.table = new Bucket[size];
        for (int i = 0; i < size; ++i) {
            this.table[i] = new Bucket();
        }
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i].size = 0;
            this.table[i].entry = null;
        }
        this.elementCount = 0;
    }

    public boolean containsKey(Object key) {
        if (this.elementCount == 0) {
            return false;
        }
        return this.findEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        if (this.elementCount == 0) {
            return false;
        }
        boolean nullValue = value == null;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i].entry;
            while (entry != null) {
                if (nullValue ? entry.getValue() == null : value.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Iterator entries() {
        return new HashMapEntryIterator(this.table);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HashMap) {
            HashMap map = (HashMap)object;
            if (map.size() != this.size()) {
                return false;
            }
            Iterator iter = map.entries();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                if (entry.equals(this.findEntry(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Entry entry = this.findEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public int hashCode() {
        int value = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i].entry;
            while (entry != null) {
                value += entry.hashCode();
                entry = entry.next;
            }
        }
        return value;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator keys() {
        return new HashMapKeyIterator(this.table);
    }

    public void put(Object key, Object value) {
        Entry entry = this.findEntry(key);
        if (entry == null) {
            this.addEntry(key, value);
        } else {
            entry.setValue(value);
        }
    }

    public Object remove(Object key) {
        boolean nullKey;
        if (this.elementCount == 0) {
            return null;
        }
        int hash = this.hashCode(key);
        Bucket bucket = this.table[hash % this.table.length];
        Entry entry = bucket.entry;
        boolean bl = nullKey = key == null;
        while (entry != null) {
            if (nullKey) {
                if (entry.getKey() == null) {
                    break;
                }
            } else {
                if (hash < entry.hash) {
                    return null;
                }
                if (entry.getKey().equals(key)) break;
            }
            entry = entry.next;
        }
        Object value = null;
        if (entry != null) {
            if (entry.prev != null) {
                entry.prev.next = entry.next;
            } else {
                bucket.entry = entry.next;
            }
            if (entry.next != null) {
                entry.next.prev = entry.prev;
            }
            value = entry.getValue();
            --bucket.size;
            --this.elementCount;
        }
        return value;
    }

    public int size() {
        return this.elementCount;
    }

    private int hashCode(Object key) {
        int hash;
        int n = hash = key == null ? 0 : key.hashCode();
        if (hash < 0) {
            hash = -hash;
        }
        return hash;
    }

    private void addEntry(Object key, Object value) {
        int hash = this.hashCode(key);
        Entry newEntry = new Entry(hash, key, value);
        Bucket bucket = this.table[hash % this.table.length];
        if (bucket.entry == null) {
            bucket.entry = newEntry;
        } else {
            Entry current = bucket.entry;
            while (current != null) {
                if (hash <= current.hash) {
                    if (current.prev != null) {
                        current.prev.next = newEntry;
                        newEntry.prev = current.prev;
                    } else {
                        bucket.entry = newEntry;
                    }
                    newEntry.next = current;
                    break;
                }
                if (current.next == null) {
                    current.next = newEntry;
                    newEntry.prev = current;
                    break;
                }
                current = current.next;
            }
        }
        ++bucket.size;
        ++this.elementCount;
    }

    private Entry findEntry(Object key) {
        if (this.elementCount == 0) {
            return null;
        }
        return this.findEntry(key, this.hashCode(key));
    }

    private Entry findEntry(Object key, int hash) {
        boolean nullKey;
        if (this.elementCount == 0) {
            return null;
        }
        int index = hash % this.table.length;
        Entry entry = this.table[index].entry;
        boolean bl = nullKey = key == null;
        while (entry != null) {
            if (nullKey) {
                if (entry.getKey() == null) {
                    return entry;
                }
            } else if (hash == entry.hash) {
                if (entry.getKey().equals(key)) {
                    return entry;
                }
            } else if (hash < entry.hash) break;
            entry = entry.next;
        }
        return null;
    }

    class Entry {
        int hash = 0;
        Object key = null;
        Object value = null;
        Entry next = null;
        Entry prev = null;

        public Entry(int hashCode, Object key, Object value) {
            this.hash = hashCode;
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                if (this.key == null) {
                    if (entry.getKey() != null) {
                        return false;
                    }
                    if (!this.key.equals(entry.getKey())) {
                        return false;
                    }
                }
                if (this.value == null) {
                    return entry.getValue() == null;
                }
                return this.value.equals(entry.getValue());
            }
            return false;
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valHash;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    class Bucket {
        int size = 0;
        Entry entry = null;

        Bucket() {
        }
    }
}

