/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.LDAPUnbindRequest;
import com.novell.ldap.LDAPUnsolicitedNotificationListener;
import com.novell.ldap.Message;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.MessageVector;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

final class Connection {
    private Object writeSemaphore = new Object();
    private int writeSemaphoreOwner = 0;
    private int writeSemaphoreCount = 0;
    private int ephemeralId = -1;
    private BindProperties bindProperties = null;
    private int bindSemaphoreId = 0;
    private Thread reader = null;
    private Thread deadReader = null;
    private IOException deadReaderException = null;
    private LBEREncoder encoder = new LBEREncoder();
    private LBERDecoder decoder = new LBERDecoder();
    private Socket socket = null;
    private Socket nonTLSBackup = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean clientActive = true;
    private boolean unsolSvrShutDnNotification = false;
    private static final int CONTINUE_READING = -99;
    private static final int STOP_READING = -98;
    private int stopReaderMessageID = -99;
    private MessageVector messages = new MessageVector(5, 5);
    private ReferralInfo activeReferral = null;
    private Vector unsolicitedListeners = new Vector(3, 3);
    private static LDAPSocketFactory socketFactory = null;
    private LDAPSocketFactory mySocketFactory;
    private String host = null;
    private int port = 0;
    private int cloneCount = 0;
    private String name = "";
    private static Object nameLock = new Object();
    private static int connNum = 0;
    static String sdk = new String("3.5");
    static Integer protocol = new Integer(3);
    static String security = "simple";

    Connection(LDAPSocketFactory lDAPSocketFactory) {
        if (lDAPSocketFactory != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSetFactory();
            }
            this.mySocketFactory = lDAPSocketFactory;
        } else {
            this.mySocketFactory = socketFactory;
        }
    }

    Object copy() {
        Connection connection = new Connection(this.mySocketFactory);
        connection.host = this.host;
        connection.port = this.port;
        return connection;
    }

    final int acquireWriteSemaphore() {
        return this.acquireWriteSemaphore(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int acquireWriteSemaphore(int n) {
        int n2 = n;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (n2 == 0) {
                n2 = this.ephemeralId = this.ephemeralId == Integer.MIN_VALUE ? (this.ephemeralId = -1) : (this.ephemeralId = this.ephemeralId - 1);
            }
            while (true) {
                if (this.writeSemaphoreOwner == 0) {
                    this.writeSemaphoreOwner = n2;
                    break;
                }
                if (this.writeSemaphoreOwner == n2) break;
                try {
                    this.writeSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.writeSemaphoreCount;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeWriteSemaphore(int n) {
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.writeSemaphoreOwner == 0) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + n + "): semaphore not owned by any thread");
            }
            if (this.writeSemaphoreOwner != n) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + n + "): thread does not own the semaphore, owned by " + this.writeSemaphoreOwner);
            }
            if (--this.writeSemaphoreCount == 0) {
                this.writeSemaphoreOwner = 0;
                this.writeSemaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReader(Thread thread) throws LDAPException {
        while (this.reader != thread) {
            try {
                Object object;
                if (thread == this.deadReader) {
                    if (thread == null) {
                        return;
                    }
                    object = this.deadReaderException;
                    this.deadReaderException = null;
                    this.deadReader = null;
                    throw new LDAPException("CONNECTION_READER", 91, null, (Throwable)object);
                }
                object = this;
                synchronized (object) {
                    this.wait(5L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.deadReaderException = null;
        this.deadReader = null;
    }

    void connect(String string, int n) throws LDAPException {
        this.connect(string, n, 0);
    }

    private void connect(String string, int n, int n2) throws LDAPException {
        this.waitForReader(null);
        this.unsolSvrShutDnNotification = false;
        int n3 = this.acquireWriteSemaphore(n2);
        if (n == 0) {
            n = 389;
        }
        try {
            if (this.in == null || this.out == null) {
                this.socket = this.mySocketFactory != null ? this.mySocketFactory.createSocket(string, n) : new Socket(string, n);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            }
        }
        catch (IOException iOException) {
            this.freeWriteSemaphore(n3);
            throw new LDAPException("CONNECTION_ERROR", new Object[]{string, new Integer(n)}, 91, null, iOException);
        }
        this.host = string;
        this.port = n;
        this.startReader();
        this.freeWriteSemaphore(n3);
        this.clientActive = true;
    }

    final boolean isCloned() {
        return this.cloneCount > 0;
    }

    final synchronized void incrCloneCount() {
        ++this.cloneCount;
    }

    final synchronized Connection destroyClone(boolean bl) {
        Connection connection = this;
        if (this.cloneCount > 0) {
            --this.cloneCount;
            connection = bl ? (Connection)this.copy() : null;
        } else if (this.in != null) {
            InterThreadException interThreadException = new InterThreadException(bl ? "CONNECTION_CLOSED" : "CONNECTION_FINALIZED", null, 91, null, null);
            this.shutdown("destroy clone", 0, interThreadException);
        }
        return connection;
    }

    static final void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        socketFactory = lDAPSocketFactory;
    }

    final LDAPSocketFactory getSocketFactory() {
        return this.mySocketFactory;
    }

    final String getHost() {
        return this.host;
    }

    final int getPort() {
        return this.port;
    }

    int getBindSemId() {
        return this.bindSemaphoreId;
    }

    void setBindSemId(int n) {
        this.bindSemaphoreId = n;
    }

    void clearBindSemId() {
        this.bindSemaphoreId = 0;
    }

    boolean isBindSemIdClear() {
        return this.bindSemaphoreId == 0;
    }

    void writeMessage(Message message) throws LDAPException {
        this.messages.addElement(message);
        if (message.isBindRequest() && !this.isConnected() && this.host != null) {
            this.connect(this.host, this.port, message.getMessageID());
        }
        LDAPMessage lDAPMessage = message.getRequest();
        this.writeMessage(lDAPMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMessage(LDAPMessage lDAPMessage) throws LDAPException {
        int n = this.bindSemaphoreId == 0 ? lDAPMessage.getMessageID() : this.bindSemaphoreId;
        OutputStream outputStream = this.out;
        this.acquireWriteSemaphore(n);
        try {
            try {
                if (outputStream == null) {
                    throw new IOException("Output stream not initialized");
                }
                byte[] byArray = lDAPMessage.getASN1Object().getEncoding(this.encoder);
                outputStream.write(byArray, 0, byArray.length);
                outputStream.flush();
            }
            catch (IOException iOException) {
                if (this.clientActive) {
                    if (this.unsolSvrShutDnNotification) {
                        throw new LDAPException("SERVER_SHUTDOWN_REQ", new Object[]{this.host, new Integer(this.port)}, 91, null, iOException);
                    }
                    throw new LDAPException("IO_EXCEPTION", new Object[]{this.host, new Integer(this.port)}, 91, null, iOException);
                }
                Object var6_7 = null;
                this.freeWriteSemaphore(n);
            }
            Object var6_6 = null;
            this.freeWriteSemaphore(n);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.freeWriteSemaphore(n);
            throw throwable;
        }
    }

    final MessageAgent getMessageAgent(int n) throws NoSuchFieldException {
        Message message = this.messages.findMessageById(n);
        return message.getMessageAgent();
    }

    final boolean isBound() {
        if (this.bindProperties != null) {
            return !this.bindProperties.isAnonymous();
        }
        return false;
    }

    final boolean isConnected() {
        return this.in != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isConnectionAlive() {
        boolean bl = false;
        LDAPExtendedOperation lDAPExtendedOperation = null;
        if (this.in != null) {
            bl = true;
            lDAPExtendedOperation = new LDAPExtendedOperation("0.0.0.0", null);
            LDAPExtendedRequest lDAPExtendedRequest = new LDAPExtendedRequest(lDAPExtendedOperation, null);
            int n = lDAPExtendedRequest.getMessageID();
            this.acquireWriteSemaphore(n);
            OutputStream outputStream = this.out;
            try {
                try {
                    if (outputStream == null) {
                        throw new IOException("Output stream not initialized");
                    }
                    byte[] byArray = lDAPExtendedRequest.getASN1Object().getEncoding(this.encoder);
                    outputStream.write(byArray, 0, byArray.length);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    bl = false;
                    Object var8_9 = null;
                    this.freeWriteSemaphore(n);
                }
                Object var8_8 = null;
                this.freeWriteSemaphore(n);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.freeWriteSemaphore(n);
                throw throwable;
            }
        }
        return bl;
    }

    final void removeMessage(Message message) {
        boolean bl = this.messages.removeElement(message);
    }

    protected void finalize() {
        this.shutdown("Finalize", 0, null);
    }

    private void shutdown(String string, int n, InterThreadException interThreadException) {
        Message message = null;
        if (!this.clientActive) {
            return;
        }
        this.clientActive = false;
        while (true) {
            try {
                message = (Message)this.messages.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            message.abandon(null, interThreadException);
        }
        int n2 = this.acquireWriteSemaphore(n);
        if (this.bindProperties != null && this.out != null && !this.bindProperties.isAnonymous()) {
            try {
                LDAPUnbindRequest lDAPUnbindRequest = new LDAPUnbindRequest(null);
                byte[] byArray = lDAPUnbindRequest.getASN1Object().getEncoding(this.encoder);
                this.out.write(byArray, 0, byArray.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bindProperties = null;
        this.in = null;
        this.out = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.freeWriteSemaphore(n2);
    }

    final void setBindProperties(BindProperties bindProperties) {
        this.bindProperties = bindProperties;
    }

    final BindProperties getBindProperties() {
        return this.bindProperties;
    }

    final boolean areMessagesComplete() {
        Object[] objectArray = this.messages.getObjectArray();
        int n = objectArray.length;
        if (this.bindSemaphoreId != 0) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!((Message)objectArray[n2]).isComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    final void stopReaderOnReply(int n) {
        this.stopReaderMessageID = n;
    }

    final void startReader() throws LDAPException {
        Thread thread = new Thread(new ReaderThread());
        thread.setDaemon(true);
        thread.start();
        this.waitForReader(thread);
    }

    final boolean isTLS() {
        return this.nonTLSBackup != null;
    }

    final void startTLS() throws LDAPException {
        if (this.mySocketFactory == null) {
            throw new LDAPException("NO_TLS_FACTORY", 112, null);
        }
        if (!(this.mySocketFactory instanceof LDAPTLSSocketFactory)) {
            throw new LDAPException("WRONG_FACTORY", 112, null);
        }
        try {
            this.waitForReader(null);
            this.nonTLSBackup = this.socket;
            this.socket = ((LDAPTLSSocketFactory)this.mySocketFactory).createSocket(this.socket);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            this.nonTLSBackup = null;
            throw new LDAPException("The host is unknown", 91, null, unknownHostException);
        }
        catch (IOException iOException) {
            this.nonTLSBackup = null;
            throw new LDAPException("Could not negotiate a secure connection", 91, null, iOException);
        }
    }

    final void stopTLS() throws LDAPException {
        try {
            try {
                this.stopReaderMessageID = -98;
                this.socket.close();
                this.waitForReader(null);
                this.socket = this.nonTLSBackup;
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                this.stopReaderMessageID = -99;
            }
            catch (IOException iOException) {
                throw new LDAPException("STOPTLS_ERROR", 91, null, iOException);
            }
            Object var3_1 = null;
            this.nonTLSBackup = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.nonTLSBackup = null;
            this.startReader();
            throw throwable;
        }
        this.startReader();
    }

    final void setActiveReferral(ReferralInfo referralInfo) {
        this.activeReferral = referralInfo;
    }

    final ReferralInfo getActiveReferral() {
        return this.activeReferral;
    }

    final void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        this.unsolicitedListeners.add(lDAPUnsolicitedNotificationListener);
    }

    final void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        this.unsolicitedListeners.removeElement(lDAPUnsolicitedNotificationListener);
    }

    private void notifyAllUnsolicitedListeners(RfcLDAPMessage rfcLDAPMessage) {
        LDAPExtendedResponse lDAPExtendedResponse = new LDAPExtendedResponse(rfcLDAPMessage);
        String string = lDAPExtendedResponse.getID();
        if (string.equals("1.3.6.1.4.1.1466.20036")) {
            this.unsolSvrShutDnNotification = true;
        }
        int n = this.unsolicitedListeners.size();
        int n2 = 0;
        while (n2 < n) {
            LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener = (LDAPUnsolicitedNotificationListener)this.unsolicitedListeners.get(n2);
            LDAPExtendedResponse lDAPExtendedResponse2 = new LDAPExtendedResponse(rfcLDAPMessage);
            UnsolicitedListenerThread unsolicitedListenerThread = new UnsolicitedListenerThread(lDAPUnsolicitedNotificationListener, lDAPExtendedResponse2);
            unsolicitedListenerThread.start();
            ++n2;
        }
    }

    String getConnectionName() {
        return this.name;
    }

    static /* synthetic */ Thread access$102(Connection connection, Thread thread) {
        connection.reader = thread;
        return connection.reader;
    }

    static /* synthetic */ InputStream access$200(Connection connection) {
        return connection.in;
    }

    static /* synthetic */ LBERDecoder access$300(Connection connection) {
        return connection.decoder;
    }

    static /* synthetic */ MessageVector access$400(Connection connection) {
        return connection.messages;
    }

    static /* synthetic */ void access$500(Connection connection, RfcLDAPMessage rfcLDAPMessage) {
        connection.notifyAllUnsolicitedListeners(rfcLDAPMessage);
    }

    static /* synthetic */ boolean access$600(Connection connection) {
        return connection.unsolSvrShutDnNotification;
    }

    static /* synthetic */ String access$700(Connection connection) {
        return connection.host;
    }

    static /* synthetic */ int access$800(Connection connection) {
        return connection.port;
    }

    static /* synthetic */ int access$900(Connection connection) {
        return connection.stopReaderMessageID;
    }

    static /* synthetic */ boolean access$1000(Connection connection) {
        return connection.clientActive;
    }

    static /* synthetic */ InputStream access$202(Connection connection, InputStream inputStream) {
        connection.in = inputStream;
        return connection.in;
    }

    static /* synthetic */ OutputStream access$1102(Connection connection, OutputStream outputStream) {
        connection.out = outputStream;
        return connection.out;
    }

    static /* synthetic */ void access$1200(Connection connection, String string, int n, InterThreadException interThreadException) {
        connection.shutdown(string, n, interThreadException);
    }

    static /* synthetic */ int access$902(Connection connection, int n) {
        connection.stopReaderMessageID = n;
        return connection.stopReaderMessageID;
    }

    static /* synthetic */ IOException access$1302(Connection connection, IOException iOException) {
        connection.deadReaderException = iOException;
        return connection.deadReaderException;
    }

    static /* synthetic */ Thread access$1402(Connection connection, Thread thread) {
        connection.deadReader = thread;
        return connection.deadReader;
    }

    static /* synthetic */ Thread access$100(Connection connection) {
        return connection.reader;
    }

    private class UnsolicitedListenerThread
    extends Thread {
        private LDAPUnsolicitedNotificationListener listenerObj;
        private LDAPExtendedResponse unsolicitedMsg;

        UnsolicitedListenerThread(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener, LDAPExtendedResponse lDAPExtendedResponse) {
            this.listenerObj = lDAPUnsolicitedNotificationListener;
            this.unsolicitedMsg = lDAPExtendedResponse;
        }

        public final void run() {
            this.listenerObj.messageReceived(this.unsolicitedMsg);
        }
    }

    public class ReaderThread
    implements Runnable {
        private ReaderThread() {
        }

        /*
         * Exception decompiling
         */
        public final void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

