/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeDescriptionList;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcSearchRequest;
import java.util.Iterator;

public class LDAPSearchRequest
extends LDAPMessage {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUALITY_MATCH = 3;
    public static final int SUBSTRINGS = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS_OR_EQUAL = 6;
    public static final int PRESENT = 7;
    public static final int APPROX_MATCH = 8;
    public static final int EXTENSIBLE_MATCH = 9;
    public static final int INITIAL = 0;
    public static final int ANY = 1;
    public static final int FINAL = 2;

    public LDAPSearchRequest(String string, int n, String string2, String[] stringArray, int n2, int n3, int n4, boolean bl, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(3, new RfcSearchRequest(new RfcLDAPDN(string), new ASN1Enumerated(n), new ASN1Enumerated(n2), new ASN1Integer(n3), new ASN1Integer(n4), new ASN1Boolean(bl), new RfcFilter(string2), new RfcAttributeDescriptionList(stringArray)), lDAPControlArray);
    }

    public LDAPSearchRequest(String string, int n, RfcFilter rfcFilter, String[] stringArray, int n2, int n3, int n4, boolean bl, LDAPControl[] lDAPControlArray) {
        super(3, new RfcSearchRequest(new RfcLDAPDN(string), new ASN1Enumerated(n), new ASN1Enumerated(n2), new ASN1Integer(n3), new ASN1Integer(n4), new ASN1Boolean(bl), rfcFilter, new RfcAttributeDescriptionList(stringArray)), lDAPControlArray);
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public int getScope() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(1)).intValue();
    }

    public int getDereference() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(2)).intValue();
    }

    public int getMaxResults() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(3)).intValue();
    }

    public int getServerTimeLimit() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(4)).intValue();
    }

    public boolean isTypesOnly() {
        return ((ASN1Boolean)((RfcSearchRequest)this.getASN1Object().get(1)).get(5)).booleanValue();
    }

    public String[] getAttributes() {
        RfcAttributeDescriptionList rfcAttributeDescriptionList = (RfcAttributeDescriptionList)((RfcSearchRequest)this.getASN1Object().get(1)).get(7);
        String[] stringArray = new String[rfcAttributeDescriptionList.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((RfcAttributeDescription)rfcAttributeDescriptionList.get(n)).stringValue();
            ++n;
        }
        return stringArray;
    }

    public String getStringFilter() {
        return this.getRfcFilter().filterToString();
    }

    private RfcFilter getRfcFilter() {
        return (RfcFilter)((RfcSearchRequest)this.getASN1Object().get(1)).get(6);
    }

    public Iterator getSearchFilter() {
        return this.getRfcFilter().getFilterIterator();
    }
}

