/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class LDIFReader
implements LDAPReader {
    private boolean requestFile = true;
    private String version;
    private int reqType;
    private int lNumber;
    private int dnlNumber;
    private int fNumber = 0;
    private byte[] bytes = new byte[0];
    private boolean control = false;
    private String entryDN;
    private String[] modInfo;
    private ArrayList rFields = new ArrayList();
    private ArrayList cList = new ArrayList();
    private BufferedReader bufReader;
    private LDAPControl[] controls = null;
    private LDAPEntry currentEntry = null;
    private LDAPModification[] mods;
    private LDAPMessage currentRequest = null;

    public LDIFReader(InputStream inputStream) throws IOException, LDAPLocalException {
        this(inputStream, 1, 8192);
    }

    public LDIFReader(InputStream inputStream, int n) throws IOException, LDAPLocalException {
        this(inputStream, n, 8192);
    }

    public LDIFReader(InputStream inputStream, int n, int n2) throws IOException, LDAPLocalException {
        String string = null;
        if (n != 1) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFReader:found: " + n + ", Should be: 1");
        }
        this.setVersion(n);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
        this.bufReader = new BufferedReader(inputStreamReader);
        while ((string = this.bufReader.readLine()) != null && (string.length() == 0 || string.startsWith("#"))) {
            ++this.lNumber;
        }
        if (string == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: The file contains no LDIF info", 82);
        }
        ++this.lNumber;
        if (string.startsWith("version:")) {
            this.version = string.substring("version:".length()).trim();
            if (!this.version.equals("1")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: version: found '" + n + "' (on line " + this.lNumber + " of the file), should be '1'", 82);
            }
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Version line must be the first meaningful line(on line " + this.lNumber + " of the file)", 82);
        }
        do {
            this.bufReader.mark(n2);
            string = this.bufReader.readLine();
            if (string == null) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the LDIF file only contains version line.", 82);
            }
            ++this.lNumber;
        } while (string.length() == 0 || string.startsWith("#"));
        while ((string = this.bufReader.readLine()) != null) {
            if (string.startsWith(" ") || string.startsWith("#")) continue;
            if (string.length() != 0) break;
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (string == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (string.startsWith("changetype") || string.startsWith("control")) {
            this.setRequest(true);
        } else {
            this.setRequest(false);
        }
        this.bufReader.reset();
        --this.lNumber;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(int n) {
        this.version = String.valueOf(n);
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    private void setRequest(boolean bl) {
        this.requestFile = bl;
    }

    public LDAPMessage readMessage() throws IOException, LDAPException {
        this.readRecordFields();
        if (this.rFields == null) {
            return null;
        }
        this.toRecordProperties();
        if (!this.isRequest()) {
            return new LDAPSearchResult(this.currentEntry, null);
        }
        switch (this.reqType) {
            case 4: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 8: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 10: {
                this.currentRequest = new LDAPDeleteRequest(this.entryDN, this.controls);
                break;
            }
            case 12: {
                boolean bl = Integer.parseInt(this.modInfo[1]) == 1;
                if (this.modInfo[2].length() == 0) {
                    this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], null, bl, this.controls);
                    break;
                }
                this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], this.modInfo[2], bl, this.controls);
                break;
            }
            case 6: {
                this.currentRequest = new LDAPModifyRequest(this.entryDN, this.mods, this.controls);
                break;
            }
        }
        return this.currentRequest;
    }

    private void readRecordFields() throws IOException, LDAPException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(80);
        this.rFields.clear();
        while ((string = this.bufReader.readLine()) != null && (string.length() == 0 || string.startsWith("#"))) {
            ++this.lNumber;
        }
        ++this.lNumber;
        this.dnlNumber = this.lNumber;
        if (string == null) {
            this.rFields = null;
        } else {
            if (!string.startsWith("dn:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReacer: Any record should start with 'dn:'(on line " + this.lNumber + " of the file).", 82);
            }
            stringBuffer.append(string);
            while ((string = this.bufReader.readLine()) != null && string.length() != 0) {
                if (!string.startsWith("#")) {
                    if (string.startsWith(" ")) {
                        stringBuffer.append(string.substring(1, string.length()));
                    } else {
                        stringBuffer = this.trimField(stringBuffer);
                        if (!this.control) {
                            this.rFields.add(stringBuffer);
                        }
                        stringBuffer = new StringBuffer(80);
                        stringBuffer.append(string);
                    }
                }
                ++this.lNumber;
            }
            stringBuffer = this.trimField(stringBuffer);
            this.rFields.add(stringBuffer);
            ++this.lNumber;
            this.fNumber = this.rFields.size();
        }
    }

    private void toRecordProperties() throws IOException, LDAPException {
        StringBuffer stringBuffer = (StringBuffer)this.rFields.get(0);
        if (stringBuffer.charAt(3) != ':') {
            this.entryDN = stringBuffer.substring(3, stringBuffer.length());
        } else {
            this.bytes = Base64.decode(stringBuffer, 4, stringBuffer.length());
            try {
                this.entryDN = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        if (!this.isRequest()) {
            this.toLDAPEntry();
        } else {
            int n = 10;
            StringBuffer stringBuffer2 = (StringBuffer)this.rFields.get(1);
            if (!stringBuffer2.substring(0, n).equalsIgnoreCase("changetype")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed changetype field in record starting on line " + this.dnlNumber + " of the file).", 82);
            }
            String string = stringBuffer2.substring(n + 1);
            if (string.equalsIgnoreCase("add")) {
                this.reqType = 8;
                this.toLDAPEntry();
            } else if (string.equalsIgnoreCase("delete")) {
                this.reqType = 10;
            } else if (string.equalsIgnoreCase("modrdn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (string.equalsIgnoreCase("moddn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (string.equalsIgnoreCase("modify")) {
                this.reqType = 6;
                this.toLDAPModifications();
            } else {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: unsupported request type '" + string + "' specified in changetype filed of the record starting " + "on line " + this.dnlNumber + " of the file.", 82);
            }
            if (this.cList.size() > 0) {
                this.controls = new LDAPControl[this.cList.size()];
            }
        }
    }

    private void toLDAPEntry() throws LDAPLocalException {
        String string = null;
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        int n = !this.isRequest() ? 1 : 2;
        int n2 = n;
        while (n2 < this.fNumber) {
            String string2;
            StringBuffer stringBuffer = (StringBuffer)this.rFields.get(n2);
            int n3 = this.IndexOf(stringBuffer, 58);
            if (n3 == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: missing ':' after attribute name in record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            string = stringBuffer.substring(0, n3);
            if (lDAPAttributeSet.getAttribute(string) == null) {
                lDAPAttributeSet.add(new LDAPAttribute(string));
            }
            if (stringBuffer.length() > n3 + 1) {
                if (stringBuffer.charAt(n3 + 1) == ':') {
                    lDAPAttributeSet.getAttribute(string).addBase64Value(stringBuffer.substring(n3 + 2));
                } else if (stringBuffer.charAt(n3 + 1) == '<') {
                    lDAPAttributeSet.getAttribute(string).addBase64Value(stringBuffer.substring(n3 + 2));
                } else {
                    string2 = stringBuffer.substring(n3 + 1).trim();
                    lDAPAttributeSet.getAttribute(string).addValue(string2);
                }
            } else if (stringBuffer.length() == n3 + 1) {
                string2 = new String("");
                lDAPAttributeSet.getAttribute(string).addValue(string2);
            }
            ++n2;
        }
        this.currentEntry = new LDAPEntry(this.entryDN, lDAPAttributeSet);
    }

    private void toModInfo() throws LDAPLocalException {
        int n = 6;
        int n2 = 2;
        this.modInfo = new String[3];
        StringBuffer stringBuffer = (StringBuffer)this.rFields.get(n2);
        if (!stringBuffer.substring(0, n + 1).equalsIgnoreCase("newrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (stringBuffer.charAt(n + 1) != ':') {
            this.modInfo[0] = stringBuffer.substring(n + 1);
        } else {
            this.bytes = Base64.decode(stringBuffer, n + 2, stringBuffer.length());
            try {
                this.modInfo[0] = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        n = 13;
        stringBuffer = (StringBuffer)this.rFields.get(++n2);
        if (!stringBuffer.substring(0, n).equalsIgnoreCase("deleteoldrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed deleteoldrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        char c = stringBuffer.charAt(n);
        if (c == '1') {
            this.modInfo[1] = new String("1");
        } else if (c == '0') {
            this.modInfo[1] = new String("0");
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: value for deleteoldrdn field should '0' or '1', found '" + c + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        stringBuffer = (StringBuffer)this.rFields.get(++n2);
        if (n2 == this.fNumber) {
            this.modInfo[2] = new String("");
        } else {
            n = 12;
            if (!stringBuffer.substring(0, n).equalsIgnoreCase("newsuperior:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newsuperior field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            if (stringBuffer.charAt(n) != ':') {
                this.modInfo[2] = stringBuffer.substring(n);
            } else {
                this.bytes = Base64.decode(stringBuffer, n + 1, stringBuffer.length());
                this.modInfo[2] = new String(this.bytes);
            }
        }
    }

    private void toLDAPModifications() throws LDAPLocalException {
        int n = 2;
        LDAPAttribute lDAPAttribute = null;
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        if (!this.rFields.get(this.fNumber - 1).toString().equalsIgnoreCase("-")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: modify record not ends with '-' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        int n2 = n;
        while (n2 < this.fNumber) {
            int n3 = this.IndexOf((StringBuffer)this.rFields.get(n2), 58);
            if (n3 == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed opName:attrName field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            StringBuffer stringBuffer = (StringBuffer)this.rFields.get(n2);
            String string = stringBuffer.substring(0, n3);
            String string2 = stringBuffer.substring(n3 + 1);
            if ((stringBuffer = (StringBuffer)this.rFields.get(++n2)).charAt(0) != '-') {
                while (stringBuffer.charAt(0) != '-') {
                    n3 = this.IndexOf(stringBuffer, 58);
                    if (n3 == -1) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : no ':' found in attrName:attrValue field in the record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    String string3 = stringBuffer.substring(0, n3);
                    if (!string3.equalsIgnoreCase(string2)) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : found attribute name '" + string3 + "', should be '" + string2 + "' in attrName:attrValue field in the record " + "starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    lDAPAttribute = new LDAPAttribute(string2);
                    if (stringBuffer.charAt(n3 + 1) == ':') {
                        lDAPAttribute.addBase64Value(stringBuffer.substring(n3 + 2));
                    } else if (stringBuffer.charAt(n3 + 1) == '<') {
                        lDAPAttribute.addBase64Value(stringBuffer.substring(n3 + 2));
                    } else {
                        lDAPAttribute.addValue(stringBuffer.substring(n3 + 1));
                    }
                    if (string.equalsIgnoreCase("add")) {
                        arrayList.add(new LDAPModification(0, lDAPAttribute));
                    } else if (string.equalsIgnoreCase("delete")) {
                        arrayList.add(new LDAPModification(1, lDAPAttribute));
                    } else if (string.equalsIgnoreCase("replace")) {
                        arrayList.add(new LDAPModification(2, lDAPAttribute));
                    } else {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : Not supported modify  request (" + string + ") specified in " + "record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    stringBuffer = (StringBuffer)this.rFields.get(++n2);
                }
            } else {
                lDAPAttribute = new LDAPAttribute(string2);
                if (string.equalsIgnoreCase("delete")) {
                    arrayList.add(new LDAPModification(1, lDAPAttribute));
                } else if (string.equalsIgnoreCase("replace")) {
                    arrayList.add(new LDAPModification(2, lDAPAttribute));
                } else {
                    throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: For '" + string + "', no value " + "specified for atribute '" + string2 + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
                }
            }
            ++n2;
        }
        this.mods = new LDAPModification[arrayList.size()];
        this.mods = arrayList.toArray(this.mods);
    }

    private int IndexOf(StringBuffer stringBuffer, int n) {
        if (stringBuffer != null) {
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private StringBuffer trimField(StringBuffer var1_1) throws LDAPLocalException {
        block29: {
            var3_2 = 0;
            var4_3 = 0;
            var7_4 = false;
            var8_5 = false;
            var9_6 = false;
            var10_7 = null;
            if (var1_1 == null || (var2_8 = this.IndexOf(var1_1, 58)) == -1) {
                return var1_1;
            }
            var3_2 = var1_1.length() - 1;
            while (var1_1.charAt(var3_2) == ' ') {
                --var3_2;
            }
            var6_9 = new char[var3_2 + 1];
            if (var2_8 > 6 && var1_1.substring(0, var2_8).equals("control")) {
                this.control = true;
                ++var2_8;
                while (var2_8 <= var3_2 && var1_1.charAt(var2_8) == ' ') {
                    ++var2_8;
                }
            } else {
                this.control = false;
                var1_1.getChars(0, var2_8 + 1, var6_9, 0);
                var4_3 += var2_8 + 1;
                ++var2_8;
            }
            if (!this.control) {
                if (var2_8 <= var3_2) {
                    var5_10 = var1_1.charAt(var2_8);
                    if (var5_10 == ':') {
                        var6_9[var4_3++] = 58;
                        ++var2_8;
                    } else if (var5_10 == '<') {
                        var6_9[var4_3++] = 60;
                        ++var2_8;
                    }
                }
                var11_12 = false;
                var12_14 = var1_1.substring(var2_8);
                if (var12_14.length() > 0 && var12_14.charAt(0) != '<' && (var13_16 = var12_14.trim()).length() > 0 && var13_16.charAt(0) == '<') {
                    var11_12 = true;
                }
                while (var2_8 <= var3_2 && var1_1.charAt(var2_8) == ' ') {
                    ++var2_8;
                }
                if (var11_12) {
                    --var2_8;
                }
                if (var2_8 <= var3_2) {
                    var1_1.getChars(var2_8, var3_2 + 1, var6_9, var4_3);
                    var13_16 = new StringBuffer(var3_2);
                    var13_16.append(var6_9, 0, var4_3 += var3_2 - var2_8 + 1);
                    return var13_16;
                }
                if (var1_1.length() == var2_8) {
                    var13_16 = new StringBuffer();
                    var1_1.getChars(var2_8, var3_2 + 1, var6_9, var4_3);
                    var13_16.append(var6_9, 0, var4_3 += var3_2 - var2_8 + 1);
                    return var13_16;
                }
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: a field contains no value after ':'. the field is in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            var11_13 = var2_8;
            while (var2_8 <= var3_2) {
                var5_11 = var1_1.charAt(var2_8);
                if (var5_11 != '.' && !Character.isDigit(var5_11)) break;
                ++var2_8;
            }
            if (var11_13 == var2_8) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Control with no oid in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            var12_15 /* !! */  = new char[var2_8 - var11_13];
            var1_1.getChars(var11_13, var2_8, var12_15 /* !! */ , 0);
            var10_7 = new String(var12_15 /* !! */ );
            if (var2_8 > var3_2) {
                var12_15 /* !! */  = (char[])new LDAPControl(var10_7, false, new byte[0]);
                this.cList.add(var12_15 /* !! */ );
                return null;
            }
            var5_11 = var1_1.charAt(var2_8);
            if (var5_11 == ' ') {
                while (var2_8 <= var3_2 && var1_1.charAt(var2_8) == ' ') {
                    ++var2_8;
                }
            }
            if (var2_8 + 3 <= var3_2 && var1_1.substring(var2_8, var2_8 + 4).equals("true")) {
                var2_8 += 4;
                var9_6 = true;
            } else if (var2_8 + 4 <= var3_2 && var1_1.substring(var2_8, var2_8 + 5).equals("false")) {
                var2_8 += 5;
                var9_6 = false;
            }
            if (var2_8 > var3_2) {
                var12_15 /* !! */  = (char[])new LDAPControl(var10_7, var9_6, new byte[0]);
                this.cList.add(var12_15 /* !! */ );
                return null;
            }
            var5_11 = var1_1.charAt(var2_8);
            if (var5_11 != ':') {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Unexcepted char '" + var5_11 + "'. Expecting " + "to see ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            if (++var2_8 > var3_2) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            var5_11 = var1_1.charAt(var2_8);
            if (var5_11 != ':') break block29;
            var7_4 = true;
            if (++var2_8 > var3_2) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after '::' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            ** GOTO lbl107
        }
        if (var5_11 != '<') ** GOTO lbl107
        var8_5 = true;
        if (++var2_8 <= var3_2) ** GOTO lbl107
        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':<' in the record starting on line " + this.dnlNumber + " of the file.", 82);
lbl-1000:
        // 1 sources

        {
            ++var2_8;
lbl107:
            // 4 sources

            ** while (var2_8 <= var3_2 && var1_1.charAt((int)var2_8) == ' ')
        }
lbl108:
        // 1 sources

        if (var2_8 <= var3_2) {
            var12_15 /* !! */  = new char[var3_2 + 1 - var2_8];
            var1_1.getChars(var2_8, var3_2 + 1, var12_15 /* !! */ , 0);
            this.bytes = var7_4 != false ? Base64.decode(var12_15 /* !! */ ) : (var8_5 != false ? new String(var12_15 /* !! */ ).getBytes() : new String(var12_15 /* !! */ ).getBytes());
        }
        var12_15 /* !! */  = (char[])new LDAPControl(var10_7, var9_6, this.bytes);
        this.cList.add(var12_15 /* !! */ );
        return null;
    }
}

