/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.security.nmas.client.NMASClient;
import com.novell.security.nmas.transport.MAFTransportException;
import com.novell.security.nmas.transport.NMASTransport;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class NMASSaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private NMASClient nmasClient = null;
    private NmasLdapTransport nmasTransport = null;
    private String loginSequence = null;
    private String dsDn;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_VALID_SERVER_RESPONSE = 1;
    private static final int STATE_INVALID_SERVER_RESPONSE = 2;
    private static final int STATE_DISPOSED = 3;
    private static final int NMAS_INVALID_CLIENT = 4;
    private static final int NMAS_INVALID_TRANSPORT = 5;

    public static SaslClient getClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        return new NMASSaslClient(string, string2, string3, map, callbackHandler);
    }

    private NMASSaslClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        this.m_authorizationId = string;
        this.m_protocol = string2;
        this.m_serverName = string3;
        this.m_props = map;
        this.m_cbh = callbackHandler;
        this.m_state = 0;
    }

    public String ldapToDSdn(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(".");
        while (n != -1) {
            stringBuffer.replace(n, n + 1, "\\.");
            String string2 = stringBuffer.toString();
            n = stringBuffer.indexOf(".", n + 2);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = true;
        n = stringBuffer.indexOf("=");
        while (n != -1) {
            int n2 = stringBuffer.indexOf(",", n);
            if (!bl) {
                stringBuffer2.append(".");
            }
            if (n2 != -1) {
                stringBuffer2.append(stringBuffer.substring(n + 1, n2));
                n = stringBuffer.indexOf("=", n2);
            } else {
                stringBuffer2.append(stringBuffer.substring(n + 1));
                n = -1;
            }
            bl = false;
        }
        return stringBuffer2.toString();
    }

    public boolean hasInitialResponse() {
        CallbackHandler callbackHandler = this.m_cbh;
        this.loginSequence = (String)this.m_props.get("LoginSequence");
        String string = this.m_authorizationId.trim();
        this.dsDn = this.ldapToDSdn(string.substring(3));
        this.nmasTransport = new NmasLdapTransport();
        if (this.nmasTransport == null) {
            this.m_state = 5;
            return false;
        }
        try {
            this.nmasClient = new NMASClient((NMASTransport)this.nmasTransport, callbackHandler);
        }
        catch (MAFTransportException mAFTransportException) {
            this.m_state = 4;
            return false;
        }
        catch (IOException iOException) {
            this.m_state = 4;
            return false;
        }
        if (this.nmasClient == null) {
            this.m_state = 4;
            return false;
        }
        return true;
    }

    public void end() {
        this.nmasTransport.end();
    }

    public synchronized byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        System.out.println("");
        switch (this.nmasClient.getState()) {
            case 1: {
                this.nmasClient.startLogin(this.dsDn, this.loginSequence);
                break;
            }
            default: {
                this.nmasTransport.setServerResponse(byArray);
            }
        }
        if (this.nmasTransport.isTransportActive()) {
            return this.nmasTransport.getNmasRequest();
        }
        throw new SaslException();
    }

    public String getMechanismName() {
        return "NMAS_LOGIN";
    }

    public boolean isComplete() {
        return this.nmasClient.getState() == 3 || this.m_state == 4 || this.m_state == 5 || this.m_state == 3;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    public Object getNegotiatedProperty(String string) {
        if (this.m_state != 1) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("javax.security.sasl.qop".equals(string)) {
            return "auth";
        }
        return null;
    }

    public void dispose() throws SaslException {
        if (this.m_state != 3) {
            this.nmasTransport.kill();
            this.m_state = 3;
        }
    }

    class NmasLdapTransport
    extends NMASTransport {
        private byte[] nmasRequest = null;
        private byte[] serverResponse = null;
        private boolean nmasRequestReady = false;
        private boolean serverResponseReady = false;
        private boolean transportActive = true;
        private boolean transportStopped = false;

        public synchronized byte[] transport(byte[] byArray, int n) throws MAFTransportException {
            if (this.transportStopped) {
                throw new MAFTransportException(-1502);
            }
            this.setNmasRequest(byArray);
            return this.getServerResponse();
        }

        public synchronized void setNmasRequest(byte[] byArray) {
            this.nmasRequest = byArray;
            this.nmasRequestReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void setServerResponse(byte[] byArray) {
            this.serverResponse = byArray;
            this.serverResponseReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized byte[] getServerResponse() throws MAFTransportException {
            while (!this.serverResponseReady) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serverResponseReady = false;
            if (this.transportStopped) {
                throw new MAFTransportException(-1502);
            }
            return this.serverResponse;
        }

        public synchronized byte[] getNmasRequest() {
            while (!this.nmasRequestReady) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.nmasRequestReady = false;
            return this.nmasRequest;
        }

        public synchronized void end() {
            this.transportActive = false;
            this.clearAll();
        }

        public synchronized void kill() {
            this.transportStopped = true;
            this.clearAll();
        }

        public synchronized void clearAll() {
            this.nmasRequest = null;
            this.serverResponse = null;
            this.nmasRequestReady = true;
            this.serverResponseReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized boolean isTransportActive() {
            return this.transportActive;
        }
    }
}

