/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.preview;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslClientFactory;
import com.sun.security.sasl.preview.SaslEnumFactory;
import com.sun.security.sasl.preview.SaslException;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class Sasl {
    private static SaslClientFactory cFactory = null;
    public static final String CLIENTPKGS = "javax.security.sasl.client.pkgs";
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        SaslClient saslClient = null;
        if (cFactory != null) {
            saslClient = cFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler);
        }
        if (saslClient == null) {
            Enumeration enumeration = Sasl.getSaslClientFactories(map);
            while (saslClient == null && enumeration.hasMoreElements()) {
                SaslClientFactory saslClientFactory = (SaslClientFactory)enumeration.nextElement();
                saslClient = saslClientFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler);
            }
        }
        return saslClient;
    }

    public static Enumeration getSaslClientFactories(Map map) {
        return new SaslEnumFactory("SaslClientFactory", map, CLIENTPKGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSaslClientFactory(SaslClientFactory saslClientFactory) {
        if (cFactory != null) {
            throw new IllegalStateException("SaslClientFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        SaslClientFactory saslClientFactory2 = cFactory;
        synchronized (saslClientFactory2) {
            cFactory = saslClientFactory;
        }
    }
}

