/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.store.impl.rdbms.SequenceAdapter;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.util.logger.Logger;

public class SQLServerRDBMSAdapter
extends StandardRDBMSAdapter
implements SequenceAdapter {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$impl$rdbms$SQLServerRDBMSAdapter == null ? (class$org$apache$slide$store$impl$rdbms$SQLServerRDBMSAdapter = SQLServerRDBMSAdapter.class$("org.apache.slide.store.impl.rdbms.SQLServerRDBMSAdapter")) : class$org$apache$slide$store$impl$rdbms$SQLServerRDBMSAdapter).getName();
    static /* synthetic */ Class class$org$apache$slide$store$impl$rdbms$SQLServerRDBMSAdapter;

    protected static String normalizeSequenceName(String sequenceName) {
        return sequenceName.replace('-', '_').toUpperCase() + "_SEQ";
    }

    public SQLServerRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    protected ServiceAccessException createException(SQLException e, String uri) {
        switch (e.getErrorCode()) {
            case 1205: {
                this.getLogger().log((Object)(e.getErrorCode() + ": Deadlock resolved on " + uri), LOG_CHANNEL, 4);
                return new ServiceAccessException(this.service, (Throwable)new ConflictException(uri));
            }
            case 547: 
            case 2627: {
                this.getLogger().log((Object)(e.getErrorCode() + ": Low isolation conflict for " + uri), LOG_CHANNEL, 4);
                return new ServiceAccessException(this.service, (Throwable)new ConflictException(uri));
            }
        }
        this.getLogger().log((Object)("SQL error " + e.getErrorCode() + " on " + uri + ": " + e.getMessage()), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    public boolean isSequenceSupported(Connection conn) {
        return true;
    }

    public boolean createSequence(Connection conn, String sequenceName) throws ServiceAccessException {
        String query = "CREATE TABLE dbo." + SQLServerRDBMSAdapter.normalizeSequenceName(sequenceName) + " (ID id_type IDENTITY UNIQUE NOT NULL, DUMY bit NOT NULL)";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
        finally {
            this.close(statement);
        }
    }

    public long nextSequenceValue(Connection conn, String sequenceName) throws ServiceAccessException {
        long l;
        String query = "INSERT INTO dbo." + SQLServerRDBMSAdapter.normalizeSequenceName(sequenceName) + " (DUMY) VALUES(1)";
        String selectQuery = "SELECT @@identity";
        PreparedStatement statement = null;
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            long value;
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            selectStatement = conn.prepareStatement(selectQuery);
            res = selectStatement.executeQuery();
            if (!res.next()) {
                throw new ServiceAccessException(this.service, "Could not increment sequence " + sequenceName);
            }
            l = value = res.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(selectStatement, res);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(selectStatement, res);
        return l;
    }

    public boolean sequenceExists(Connection conn, String sequenceName) throws ServiceAccessException {
        boolean bl;
        String selectQuery = this.getExistsQuery(sequenceName);
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            selectStatement = conn.prepareStatement(selectQuery);
            res = selectStatement.executeQuery();
            bl = res.next();
        }
        catch (SQLException e) {
            try {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(selectStatement, res);
                throw throwable;
            }
        }
        this.close(selectStatement, res);
        return bl;
    }

    protected String getExistsQuery(String sequenceName) {
        String selectQuery = "SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[" + SQLServerRDBMSAdapter.normalizeSequenceName(sequenceName) + "]') and OBJECTPROPERTY(id, N'IsUserTable') = 1";
        return selectQuery;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

