/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.txfile.AbstractTxFileStoreService;
import org.apache.slide.store.util.FileHelper;

public class TxFileContentStore
extends AbstractTxFileStoreService
implements ContentStore {
    protected static final String LOG_CHANNEL = "file-content-store";

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            Object txId = this.getActiveTxId();
            InputStream is = txId != null ? this.rm.readResource(txId, (Object)revisionUri) : this.rm.readResource((Object)revisionUri);
            NodeRevisionContent result = new NodeRevisionContent();
            result.setContent(is);
            return result;
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4002) {
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            this.throwInternalError(e, uri.toString());
            return null;
        }
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            this.rm.createResource(this.getActiveTxId(), (Object)revisionUri, false);
            this.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        }
        catch (RevisionNotFoundException e) {
            this.throwInternalError(e, uri.toString());
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4001) {
                throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            this.throwInternalError(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        block26: {
            InputStream is;
            OutputStream os;
            block24: {
                String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                os = null;
                is = null;
                os = this.rm.writeResource(this.getActiveTxId(), (Object)revisionUri);
                is = revisionContent.streamContent();
                if (is == null) break block24;
                long contentBytes = FileHelper.copy(is, os);
                long contentLength = revisionDescriptor.getContentLength();
                revisionDescriptor.setContentLength(contentBytes);
                if (contentLength == -1L || contentBytes == contentLength) break block24;
                this.rm.deleteResource(this.getActiveTxId(), (Object)revisionUri);
                this.throwInternalError("Content length does not match expected");
            }
            Object var12_11 = null;
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
                break block26;
            }
            catch (IOException e2) {}
            break block26;
            {
                catch (IOException e) {
                    this.throwInternalError(e, uri.toString());
                    Object var12_12 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block26;
                    }
                    catch (IOException e2) {}
                    break block26;
                }
                catch (ResourceManagerException e) {
                    if (e.getStatus() == 4002) {
                        throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                    }
                    this.throwInternalError(e, uri.toString());
                    Object var12_13 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block26;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            this.rm.deleteResource(this.getActiveTxId(), (Object)revisionUri);
        }
        catch (ResourceManagerException e) {
            this.throwInternalError(e, uri.toString());
        }
    }

    public String toString() {
        return "TxContentFileStore at " + this.storeDir + "  working on " + this.workDir;
    }

    protected String getLogChannel() {
        return LOG_CHANNEL;
    }
}

