/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txjndi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.CacheManagerFactory;

public class JNDIPrincipalStore
extends AbstractXAService
implements ContentStore,
LockStore,
NodeStore,
RevisionDescriptorStore,
RevisionDescriptorsStore,
SecurityStore {
    public static final String CACHE_NAME = (class$org$apache$slide$store$txjndi$JNDIPrincipalStore == null ? (class$org$apache$slide$store$txjndi$JNDIPrincipalStore = JNDIPrincipalStore.class$("org.apache.slide.store.txjndi.JNDIPrincipalStore")) : class$org$apache$slide$store$txjndi$JNDIPrincipalStore).getName();
    public static final String CACHE_OBJECT_PREFIX = "object: ";
    public static final String CACHE_DESCRIPTOR_PREFIX = "descriptor: ";
    public static final String JNDI_PROPERTY_PREFIX = "java.naming";
    public static final String PARAM_CACHE_REFRESH_CHECK_RATE = "cache.refresh.checkrate";
    public static final String PARAM_CACHE_REFRESH_RATE = "cache.refresh.rate";
    public static final String PARAM_CACHE_REFRESH_THRESHOLD = "cache.refresh.threshold";
    public static final String PARAM_JNDI_CONTAINER = "jndi.container";
    public static final String PARAM_JNDI_FILTER = "jndi.search.filter";
    public static final String PARAM_JNDI_GROUPMEMBERSET = "jndi.attributes.groupmemberset";
    public static final String PARAM_JNDI_RDN_ATTRIBUTE = "jndi.attributes.rdn";
    public static final String PARAM_JNDI_SEARCH_ATTRIBUTES = "jndi.search.attributes";
    public static final String PARAM_JNDI_SEARCH_SCOPE = "jndi.search.scope";
    public static final String PARAM_JNDI_USERPRINCIPALNAME = "jndi.attributes.userprincipalname";
    public static final String PARAM_LOG_VALIDATION_ERRORS = "log.validationerrors";
    public static final int DEFAULT_CACHE_SIZE = 200;
    public static final boolean DEFAULT_CACHE_OVERFLOW_TO_DISK = true;
    public static final boolean DEFAULT_CACHE_ETERNAL = false;
    public static final long DEFAULT_CACHE_TTL = 900L;
    public static final long DEFAULT_CACHE_TTI = 900L;
    public static final long DEFAULT_CACHE_REFRESH_CHECK_RATE = 15L;
    public static final long DEFAULT_CACHE_REFRESH_RATE = 800L;
    public static final long DEFAULT_CACHE_REFRESH_THRESHOLD = 200L;
    public static final String DEFAULT_JNDI_SEARCH_ATTRIBUTES = "cn";
    public static final String DEFAULT_JNDI_FILTER = "(objectClass=*)";
    public static final String LDAP_NAMESPACE = "LDAP:";
    public static final String LOG_CHANNEL = (class$org$apache$slide$store$txjndi$JNDIPrincipalStore == null ? (class$org$apache$slide$store$txjndi$JNDIPrincipalStore = JNDIPrincipalStore.class$("org.apache.slide.store.txjndi.JNDIPrincipalStore")) : class$org$apache$slide$store$txjndi$JNDIPrincipalStore).getName();
    protected Hashtable ctxParameters = new Hashtable();
    protected boolean isConnected = false;
    protected boolean logValidationErrors = false;
    protected Cache cache = this.getCache();
    protected TreeSet refreshList = new TreeSet();
    protected long refreshRate = 800L;
    protected long refreshThreadSleepTime = 15L;
    protected long refreshThreshold = 200L;
    protected RefreshThread refresher = new RefreshThread();
    protected String container;
    protected String[] descriptorAttributes;
    protected String filter;
    protected String groupMemberSet;
    protected String rdnAttribute;
    protected int searchScope;
    protected String principalNameAttribute;
    private String name = "";
    private String usersPath;
    private Map objectNameMap = new HashMap();
    static /* synthetic */ Class class$org$apache$slide$store$txjndi$JNDIPrincipalStore;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        this.name = "JNDIPrincipalStore[" + this.scope.toString() + "]";
        this.getLogger().log((Object)("Initializing " + this.name), LOG_CHANNEL, 7);
        super.initialize(token);
        this.usersPath = token.getNamespaceConfig().getUsersPath();
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.getLogger().log((Object)("Setting parameters for " + this.name), LOG_CHANNEL, 7);
        String temp = null;
        Iterator keys = parameters.keySet().iterator();
        while (keys.hasNext()) {
            temp = (String)keys.next();
            if (!temp.startsWith(JNDI_PROPERTY_PREFIX)) continue;
            this.ctxParameters.put(temp, parameters.get(temp));
        }
        this.container = (String)parameters.get(PARAM_JNDI_CONTAINER);
        if (this.container == null || this.container.length() == 0) {
            this.getLogger().log((Object)("Error during " + this.name + " setup: No value set for " + PARAM_JNDI_CONTAINER), LOG_CHANNEL, 1);
        }
        this.filter = (String)parameters.get(PARAM_JNDI_FILTER);
        if (this.filter == null || this.filter.length() == 0) {
            this.filter = DEFAULT_JNDI_FILTER;
        }
        this.rdnAttribute = (String)parameters.get(PARAM_JNDI_RDN_ATTRIBUTE);
        if (this.rdnAttribute == null || this.rdnAttribute.length() == 0) {
            this.getLogger().log((Object)("Error during " + this.name + " setup: No value set for " + PARAM_JNDI_RDN_ATTRIBUTE), LOG_CHANNEL, 1);
        }
        this.searchScope = "OBJECT_SCOPE".equalsIgnoreCase(temp = (String)parameters.get(PARAM_JNDI_SEARCH_SCOPE)) ? 0 : ("ONELEVEL_SCOPE".equalsIgnoreCase(temp) ? 1 : ("SUBTREE_SCOPE".equalsIgnoreCase(temp) ? 2 : 1));
        temp = (String)parameters.get(PARAM_JNDI_SEARCH_ATTRIBUTES);
        if (temp == null || temp.length() == 0) {
            temp = DEFAULT_JNDI_SEARCH_ATTRIBUTES;
        }
        ArrayList<String> searchAttributesList = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(temp, ",");
        while (tok.hasMoreTokens()) {
            searchAttributesList.add(tok.nextToken().trim());
        }
        String gms = (String)parameters.get(PARAM_JNDI_GROUPMEMBERSET);
        if (gms != null) {
            searchAttributesList.add(gms);
            this.groupMemberSet = gms;
        } else {
            this.groupMemberSet = "";
        }
        this.descriptorAttributes = searchAttributesList.toArray(new String[0]);
        temp = (String)parameters.get(PARAM_CACHE_REFRESH_RATE);
        this.refreshRate = temp != null ? Long.parseLong(temp) * 1000L : 800000L;
        temp = (String)parameters.get(PARAM_CACHE_REFRESH_CHECK_RATE);
        this.refreshThreadSleepTime = temp != null ? Long.parseLong(temp) * 1000L : 15000L;
        temp = (String)parameters.get(PARAM_CACHE_REFRESH_THRESHOLD);
        this.refreshThreshold = temp != null ? Long.parseLong(temp) : 200L;
        temp = (String)parameters.get(PARAM_LOG_VALIDATION_ERRORS);
        if ("true".equalsIgnoreCase(temp)) {
            this.logValidationErrors = true;
        }
        this.principalNameAttribute = (String)parameters.get(PARAM_JNDI_USERPRINCIPALNAME);
    }

    public boolean cacheResults() {
        return false;
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        this.getLogger().log((Object)(this.name + ": Retrieving Object " + uri.toString() + "."), LOG_CHANNEL, 7);
        String cacheKey = CACHE_OBJECT_PREFIX + uri.toString();
        Element cachedNode = null;
        try {
            if (this.cache != null) {
                cachedNode = this.cache.get((Serializable)((Object)cacheKey));
            }
        }
        catch (CacheException e) {
            this.getLogger().log((Object)(this.name + ": Error while getting \"" + cacheKey + "\" from cache."), (Throwable)e, LOG_CHANNEL, 2);
        }
        if (cachedNode != null) {
            this.getLogger().log((Object)(this.name + ": ObjectNode for \"" + uri.toString() + "\" found in cache."), LOG_CHANNEL, 7);
            return (ObjectNode)cachedNode.getValue();
        }
        return this.getObject(uri);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.getLogger().log((Object)(this.name + ": Retrieving Revision Descriptor for " + uri.toString() + "."), LOG_CHANNEL, 7);
        String cacheKey = CACHE_DESCRIPTOR_PREFIX + uri.toString();
        Element cachedDescriptor = null;
        try {
            if (this.cache != null) {
                cachedDescriptor = this.cache.get((Serializable)((Object)cacheKey));
            }
        }
        catch (CacheException e) {
            this.getLogger().log((Object)(this.name + ": Error while getting \"" + cacheKey + "\" from cache."), (Throwable)e, LOG_CHANNEL, 2);
        }
        if (cachedDescriptor != null) {
            this.getLogger().log((Object)(this.name + ": NodeRevisionDescriptor for \"" + uri.toString() + "\" found in cache."), LOG_CHANNEL, 7);
            return (NodeRevisionDescriptor)cachedDescriptor.getValue();
        }
        return this.getRevisionDescriptor(uri);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.getLogger().log((Object)(this.name + ": Retrieving Revision Descriptors for " + uri.toString() + "."), LOG_CHANNEL, 7);
        NodeRevisionNumber rev = new NodeRevisionNumber(1, 0);
        Hashtable<String, NodeRevisionNumber> workingRevisions = new Hashtable<String, NodeRevisionNumber>();
        workingRevisions.put("1.0", rev);
        Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
        latestRevisionNumbers.put("1.0", rev);
        Vector<NodeRevisionNumber> branches = new Vector<NodeRevisionNumber>();
        branches.add(rev);
        Hashtable<String, Vector<NodeRevisionNumber>> branchNames = new Hashtable<String, Vector<NodeRevisionNumber>>();
        branchNames.put("main", branches);
        return new NodeRevisionDescriptors(uri.toString(), rev, workingRevisions, latestRevisionNumbers, branchNames, false);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
    }

    public void connect() throws ServiceConnectionFailedException {
        if (!this.refresher.isAlive()) {
            this.refresher.start();
        }
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        if (this.refresher.isAlive()) {
            this.refresher.halt();
        }
    }

    public void reset() throws ServiceResetFailedException {
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource rm) throws XAException {
        return false;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    public int prepare(Xid txId) throws XAException {
        return 3;
    }

    public void forget(Xid txId) throws XAException {
    }

    public void rollback(Xid txId) throws XAException {
    }

    public void end(Xid txId, int flags) throws XAException {
    }

    public void start(Xid txId, int flags) throws XAException {
    }

    public void commit(Xid txId, boolean onePhase) throws XAException {
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent nrc = new NodeRevisionContent();
        nrc.setContent(new char[0]);
        return nrc;
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        permissions.add(new NodePermission(uri.toString(), "all", "/actions/read"));
        return permissions.elements();
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        return new Vector().elements();
    }

    protected SubjectNode getObject(Uri uri) throws ObjectNotFoundException, ServiceAccessException {
        long elapsed;
        NamingEnumeration<SearchResult> results;
        long start = System.currentTimeMillis();
        DirContext ctx = null;
        try {
            ctx = this.getContext();
        }
        catch (ServiceConnectionFailedException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        Uri parentUri = uri.getParentUri();
        String objectName = this.getObjectNameFromUri(uri);
        Vector<ObjectNode.Binding> parentBindings = new Vector<ObjectNode.Binding>();
        Vector<ObjectNode.Binding> childBindings = new Vector<ObjectNode.Binding>();
        if (!uri.toString().equals("/")) {
            parentBindings.add(new ObjectNode.Binding(objectName, parentUri.toString()));
        }
        SearchControls controls = new SearchControls();
        controls.setSearchScope(this.searchScope);
        if (uri.isStoreRoot()) {
            try {
                results = ctx.search(this.container, this.filter, controls);
                if (!results.hasMore()) {
                    this.getLogger().log((Object)(this.name + ": No objects found in container " + this.container + " that match filter " + this.filter + "."), LOG_CHANNEL, 4);
                }
                while (results.hasMore()) {
                    SearchResult result = null;
                    try {
                        result = results.next();
                    }
                    catch (NamingException e) {
                        this.getLogger().log((Object)(this.name + ": Error getting next search result."), (Throwable)e, LOG_CHANNEL, 2);
                    }
                    String name = result.getName();
                    if (!this.validatePathName(name)) continue;
                    String value = this.parseLdapName(name);
                    if (this.principalNameAttribute != null) {
                        String uriValue = ((String)result.getAttributes().get(this.principalNameAttribute).get()).toLowerCase();
                        this.objectNameMap.put(uriValue, value);
                        value = uriValue;
                    }
                    this.getLogger().log((Object)(name + ": Creating child binding \"" + value + "\" for \"" + uri.toString() + "\"."), LOG_CHANNEL, 7);
                    childBindings.add(new ObjectNode.Binding(value, uri.toString() + "/" + value));
                }
            }
            catch (NamingException e) {
                this.getLogger().log((Object)(this.name + ": Error during search."), (Throwable)e, LOG_CHANNEL, 2);
            }
        } else {
            try {
                if (this.principalNameAttribute != null && this.objectNameMap.get(objectName) == null) {
                    this.retrieveObject(parentUri);
                }
                if (!(results = ctx.search(this.container, this.rdnAttribute + "=" + (this.principalNameAttribute != null ? (String)this.objectNameMap.get(objectName) : objectName), controls)).hasMore()) {
                    if (ctx != null) {
                        this.closeContext(ctx);
                    }
                    throw new ObjectNotFoundException(uri);
                }
            }
            catch (NamingException e) {
                this.getLogger().log((Object)(this.name + ": Error retrieving " + uri.toString()), (Throwable)e, LOG_CHANNEL, 2);
                if (ctx != null) {
                    this.closeContext(ctx);
                }
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
        this.getLogger().log((Object)(this.name + ": Creating SubjectNode for \"" + uri.toString() + "\"."), LOG_CHANNEL, 7);
        SubjectNode node = new SubjectNode(uri.toString(), childBindings, parentBindings, new Vector());
        node.setUri(uri.toString());
        if (this.cache != null) {
            this.getLogger().log((Object)(this.name + ": Putting ObjectNode for " + uri.toString() + " to cache."), LOG_CHANNEL, 7);
            Element cachedNode = new Element((Serializable)((Object)(CACHE_OBJECT_PREFIX + uri.toString())), (Serializable)node);
            this.cache.put(cachedNode);
        }
        if ((elapsed = System.currentTimeMillis() - start) > this.refreshThreshold) {
            this.addRefreshee(uri, 0);
        }
        if (ctx != null) {
            this.closeContext(ctx);
        }
        return node;
    }

    protected NodeRevisionDescriptor getRevisionDescriptor(Uri uri) throws RevisionDescriptorNotFoundException, ServiceAccessException {
        long elapsed;
        long start = System.currentTimeMillis();
        DirContext ctx = null;
        try {
            ctx = this.getContext();
        }
        catch (ServiceConnectionFailedException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        String objectName = this.getObjectNameFromUri(uri);
        Hashtable<String, NodeProperty> props = new Hashtable<String, NodeProperty>();
        String resourceType = "<collection/>";
        if (!uri.isStoreRoot()) {
            resourceType = resourceType + "<principal/>";
        }
        props.put("DAV:resourcetype", new NodeProperty("resourcetype", (Object)resourceType, "DAV:", "", false));
        props.put("DAV:displayname", new NodeProperty("displayname", (Object)(!uri.isStoreRoot() && this.principalNameAttribute != null ? (String)this.objectNameMap.get(objectName) : objectName), "DAV:", "", false));
        if (!uri.isStoreRoot()) {
            String localFilter = this.rdnAttribute + "=" + (this.principalNameAttribute != null ? (String)this.objectNameMap.get(objectName) : objectName);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(this.descriptorAttributes);
            try {
                NamingEnumeration<SearchResult> results = ctx.search(this.container, localFilter, controls);
                if (!results.hasMore()) {
                    if (ctx != null) {
                        this.closeContext(ctx);
                    }
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                while (results.hasMore()) {
                    SearchResult result = null;
                    try {
                        result = results.next();
                    }
                    catch (NamingException e) {
                        this.getLogger().log((Object)(this.name + ": Error getting search result with filter: " + localFilter + " from container: " + this.container + "."), LOG_CHANNEL, 2);
                        if (ctx != null) {
                            this.closeContext(ctx);
                        }
                        throw new ServiceAccessException((Service)this, (Throwable)e);
                    }
                    NamingEnumeration<? extends Attribute> attributes = result.getAttributes().getAll();
                    while (attributes.hasMore()) {
                        Attribute attribute = attributes.next();
                        StringBuffer valueString = new StringBuffer();
                        boolean isGms = attribute.getID().equals(this.groupMemberSet);
                        boolean isMva = attribute.size() > 1;
                        for (int i = 0; i < attribute.size(); ++i) {
                            try {
                                Object value = attribute.get(i);
                                if (!(value instanceof String)) {
                                    this.getLogger().log((Object)(this.name + ": Non-string value found for " + attribute.getID() + "."), LOG_CHANNEL, 7);
                                    continue;
                                }
                                if (isGms) {
                                    valueString.append("<D:href xmlns:D='DAV:'>");
                                    valueString.append(this.usersPath).append("/");
                                    String name = this.parseLdapName(value.toString());
                                    if (this.principalNameAttribute != null) {
                                        controls.setReturningAttributes(new String[]{this.principalNameAttribute});
                                        NamingEnumeration<SearchResult> roleResults = ctx.search(this.container, this.rdnAttribute + "=" + name, controls);
                                        if (roleResults.hasMore()) {
                                            SearchResult userObject = roleResults.next();
                                            name = ((String)userObject.getAttributes().get(this.principalNameAttribute).get()).toLowerCase();
                                        }
                                    }
                                    valueString.append(name);
                                    valueString.append("</D:href>");
                                    continue;
                                }
                                if (isMva) {
                                    valueString.append("<mva xmlns=\"").append(LDAP_NAMESPACE).append("\">");
                                    valueString.append(value.toString());
                                    valueString.append("</mva>");
                                    continue;
                                }
                                valueString.append(value.toString());
                                continue;
                            }
                            catch (NamingException e) {
                                this.getLogger().log((Object)(this.name + ": Error fetching next attribute value for attribute " + attribute.getID() + "."), (Throwable)e, LOG_CHANNEL, 7);
                            }
                        }
                        if (isGms) {
                            this.getLogger().log((Object)(this.name + ": Adding property \"group-member-set\" in namespace " + "\"DAV:\" with value of \"" + valueString.toString() + "\" to " + uri.toString() + "."), LOG_CHANNEL, 7);
                            props.put("DAV:group-member-set", new NodeProperty("group-member-set", (Object)valueString.toString(), "DAV:"));
                            continue;
                        }
                        this.getLogger().log((Object)(this.name + ": Adding property \"" + attribute.getID() + "\" in namespace \"" + LDAP_NAMESPACE + "\" " + "with value of \"" + valueString.toString() + "\" to " + uri.toString() + "."), LOG_CHANNEL, 7);
                        props.put(LDAP_NAMESPACE + attribute.getID(), new NodeProperty(attribute.getID(), (Object)valueString.toString(), LDAP_NAMESPACE));
                    }
                }
            }
            catch (NamingException e) {
                this.getLogger().log((Object)(this.name + ": Error during search."), (Throwable)e, LOG_CHANNEL, 2);
            }
        }
        NodeRevisionDescriptor descriptor = new NodeRevisionDescriptor(new NodeRevisionNumber(1, 0), "main", new Vector(), props);
        if (this.cache != null) {
            this.getLogger().log((Object)(this.name + ": Putting NodeRevisionDescriptor for " + uri.toString() + " to cache."), LOG_CHANNEL, 7);
            Element cachedDescriptor = new Element((Serializable)((Object)(CACHE_DESCRIPTOR_PREFIX + uri.toString())), (Serializable)descriptor);
            this.cache.put(cachedDescriptor);
        }
        if ((elapsed = System.currentTimeMillis() - start) > this.refreshThreshold) {
            this.addRefreshee(uri, 1);
        }
        if (ctx != null) {
            this.closeContext(ctx);
        }
        return descriptor;
    }

    private void closeContext(DirContext ctx) {
        this.getLogger().log((Object)(this.name + ": Disconnecting from LDAP server."), LOG_CHANNEL, 7);
        try {
            ctx.close();
        }
        catch (NamingException e) {
            this.getLogger().log((Object)(this.name + ": Error disconnecting from LDAP"), (Throwable)e, LOG_CHANNEL, 4);
            ctx = null;
        }
    }

    private DirContext getContext() throws ServiceConnectionFailedException {
        this.getLogger().log((Object)(this.name + ": Connecting to LDAP server."), LOG_CHANNEL, 7);
        try {
            InitialDirContext ctx = new InitialDirContext(this.ctxParameters);
            if (ctx != null) {
                return ctx;
            }
            throw new ServiceConnectionFailedException((Service)this, "Invalid JNDI connection parameters.");
        }
        catch (NamingException e) {
            this.getLogger().log((Object)(this.name + ": Error Connecting to LDAP Server"), (Throwable)e, LOG_CHANNEL, 1);
            throw new ServiceConnectionFailedException((Service)this, (Exception)e);
        }
    }

    protected String getObjectNameFromUri(Uri uri) {
        String objectName = uri.toString().substring(uri.toString().lastIndexOf("/") + 1);
        return objectName.toLowerCase();
    }

    protected String parseLdapName(String name) {
        int secondEqual;
        int end;
        if (name.equals("")) {
            return name;
        }
        int firstEqual = name.indexOf("=");
        if (firstEqual < 0) {
            firstEqual = 0;
        }
        if ((end = name.substring(0, secondEqual = (secondEqual = name.substring(firstEqual + 1).indexOf("=")) < 0 ? name.length() - 1 : secondEqual + firstEqual + 1).lastIndexOf(",")) < 0) {
            end = name.length();
        }
        String value = name.substring(firstEqual + 1, end).toLowerCase();
        return value;
    }

    protected boolean validatePathName(String name) {
        boolean valid = true;
        if (name.indexOf("/") > -1) {
            valid = false;
            if (this.logValidationErrors) {
                this.getLogger().log((Object)(name + ": Skipping child with name \"" + name + "\" because " + "it contains a /."), LOG_CHANNEL, 2);
            }
        }
        return valid;
    }

    protected synchronized void addRefreshee(Uri uri, int refreshType) {
        this.getLogger().log((Object)(this.name + ": Adding refreshee for \"" + uri.toString() + "\" of type \"" + (refreshType == 0 ? "object" : "descriptor") + "\"."), LOG_CHANNEL, 7);
        this.refreshList.add(new Refreshee(uri, System.currentTimeMillis() + this.refreshRate, refreshType));
    }

    protected Cache getCache() {
        CacheManager cacheManager = null;
        Cache cache = null;
        try {
            cacheManager = CacheManagerFactory.getDefaultCacheManager();
        }
        catch (CacheException e) {
            this.getLogger().log((Object)(this.name + ": Error getting default CacheManager."), (Throwable)e, LOG_CHANNEL, 2);
            return null;
        }
        cache = cacheManager.getCache(CACHE_NAME);
        if (cache == null) {
            cache = new Cache(CACHE_NAME, 200, true, false, 900L, 900L);
            try {
                cacheManager.addCache(cache);
            }
            catch (IllegalStateException e) {
                this.getLogger().log((Object)(this.name + ": Error adding cache \"" + CACHE_NAME + "\" to CacheManager."), (Throwable)e, LOG_CHANNEL, 2);
            }
            catch (ObjectExistsException e) {
                this.getLogger().log((Object)(this.name + ": Error adding cache \"" + CACHE_NAME + "\" to CacheManager."), (Throwable)e, LOG_CHANNEL, 2);
            }
            catch (CacheException e) {
                this.getLogger().log((Object)(this.name + ": Error adding cache \"" + CACHE_NAME + "\" to CacheManager."), (Throwable)e, LOG_CHANNEL, 2);
            }
        }
        return cache;
    }

    protected synchronized Refreshee getNextRefreshee() {
        Refreshee refreshee = null;
        try {
            refreshee = (Refreshee)this.refreshList.last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return refreshee;
    }

    protected void refreshCache() {
        Refreshee oldest = this.getNextRefreshee();
        long now = System.currentTimeMillis();
        while (oldest != null && oldest.getRefreshTime() < now) {
            this.getLogger().log((Object)(this.name + ": Refreshing cache for \"" + oldest.getUri().toString() + "\" of type \"" + (oldest.getRefreshType() == 0 ? "object" : "descriptor") + "\"."), LOG_CHANNEL, 7);
            this.removeRefreshee(oldest);
            try {
                Cache cache = this.getCache();
                if (cache != null) {
                    switch (oldest.getRefreshType()) {
                        case 0: {
                            this.getObject(oldest.getUri());
                            break;
                        }
                        case 1: {
                            this.getRevisionDescriptor(oldest.getUri());
                        }
                    }
                }
            }
            catch (ObjectNotFoundException e) {
                this.getLogger().log((Object)(this.name + ": Error refreshing cache for \"" + oldest.getUri().toString() + "\"."), (Throwable)e, LOG_CHANNEL, 2);
            }
            catch (ServiceAccessException e) {
                this.getLogger().log((Object)(this.name + ": Error refreshing cache for \"" + oldest.getUri().toString() + "\"."), (Throwable)e, LOG_CHANNEL, 2);
            }
            catch (RevisionDescriptorNotFoundException e) {
                this.getLogger().log((Object)(this.name + ": Error refreshing cache for \"" + oldest.getUri().toString() + "\"."), (Throwable)e, LOG_CHANNEL, 2);
            }
            oldest = this.getNextRefreshee();
        }
    }

    protected synchronized void removeRefreshee(Refreshee refreshee) {
        this.refreshList.remove(refreshee);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RefreshThread
    extends Thread {
        private boolean run;

        public RefreshThread() {
            super("RefreshThread-" + JNDIPrincipalStore.this.name);
            this.setPriority(1);
            this.setDaemon(false);
        }

        public synchronized void halt() {
            this.run = false;
        }

        public void run() {
            this.run = true;
            while (this.keepRunning()) {
                try {
                    Thread.sleep(JNDIPrincipalStore.this.refreshThreadSleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JNDIPrincipalStore.this.refreshCache();
            }
        }

        private synchronized boolean keepRunning() {
            return this.run;
        }
    }

    protected class Refreshee
    implements Comparable {
        public static final int REFRESH_OBJECT = 0;
        public static final int REFRESH_DESCRIPTOR = 1;
        private long refreshTime;
        private Uri uri;
        private int refreshType;

        private Refreshee() {
        }

        public Refreshee(Uri uri, long refreshTime, int refreshType) {
            this.refreshTime = refreshTime;
            this.uri = uri;
            this.refreshType = refreshType;
        }

        public int compareTo(Object object) {
            if (object instanceof Refreshee) {
                Refreshee other = (Refreshee)object;
                int result = this.compare(this.getRefreshTime(), other.getRefreshTime());
                if (result != 0) {
                    return result;
                }
            }
            return this.compare(this.hashCode(), object.hashCode());
        }

        public long getRefreshTime() {
            return this.refreshTime;
        }

        public int getRefreshType() {
            return this.refreshType;
        }

        public Uri getUri() {
            return this.uri;
        }

        private int compare(long first, long second) {
            if (first < second) {
                return 1;
            }
            if (second < first) {
                return -1;
            }
            return 0;
        }
    }
}

