/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.car.CarClassLoader;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.services.LogService;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CarResources {
    private static CarResources instance = new CarResources();
    private static CarClassLoader loader = new CarClassLoader((class$org$jasig$portal$PortalSessionManager == null ? (class$org$jasig$portal$PortalSessionManager = CarResources.class$("org.jasig.portal.PortalSessionManager")) : class$org$jasig$portal$PortalSessionManager).getClassLoader());
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/car/CarResources.java,v 1.8 2003/11/04 01:03:50 wgthom Exp $";
    static final String DEPLOYMENT_DESCRIPTOR = "META-INF/comp.xml";
    private static final String WELL_KNOWN_DIR = "/WEB-INF/cars";
    private static final String CAR_DIR_PROP_NAME = "org.jasig.portal.car.CarResources.directory";
    private Hashtable resourceJars = new Hashtable();
    private Hashtable carsByJars = new Hashtable();
    private Hashtable carContents = new Hashtable();
    private Hashtable carsByPath = new Hashtable();
    Vector jarsWithDescriptors = new Vector();
    private String carDirPath = null;
    private boolean carDirExists = false;
    public static final String CAR_WORKER_ID = "carRsrc";
    public static final String CAR_RESOURCE_PARM = "carRsrc";
    private static final Map.Entry[] ENTRY_ARRAY = new Map.Entry[0];
    private static final String[] STRING_ARRAY = new String[0];
    private FileFilter carFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".car");
        }
    };
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    static /* synthetic */ Class class$org$jasig$portal$PortalSessionManager;

    private CarResources() {
        try {
            this.loadCars();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            e.printStackTrace(p);
            p.flush();
            LogService.log(LogService.ERROR, "An Exception occurred while loading channel archives. Any channels deployed via CARs will not be available. Details:\n" + sw);
        }
    }

    public static CarResources getInstance() {
        return instance;
    }

    public ClassLoader getClassLoader() {
        return loader;
    }

    private File getWellKnownDir() {
        PortalSessionManager servlet = PortalSessionManager.getInstance();
        if (servlet == null) {
            return null;
        }
        ServletContext ctx = servlet.getServletConfig().getServletContext();
        String carDirRealPath = ctx.getRealPath(WELL_KNOWN_DIR);
        if (carDirRealPath == null) {
            LogService.log(LogService.ERROR, "Channel Archives will not be  loaded. Unable to aquire the real path to '/WEB-INF/cars'. This can occur if the portal is deployed as a WAR and directories can not be created within its directory structure. Alternatively, you can specify a fully qualified path as the value of a 'org.jasig.portal.car.CarResources.directory' property in portal.properties.");
            return null;
        }
        File carDir = new File(carDirRealPath);
        if (!carDir.exists()) {
            LogService.log(LogService.ERROR, "Channel Archives can not be  loaded. CAR directory '" + carDirRealPath + "' does not exist.");
            return null;
        }
        this.carDirExists = true;
        this.carDirPath = carDirRealPath;
        return carDir;
    }

    private File getPropertySpecifiedDir() {
        String carDirPath = null;
        File carDir = null;
        try {
            carDirPath = PropertiesManager.getProperty(CAR_DIR_PROP_NAME);
            carDir = new File(carDirPath);
        }
        catch (RuntimeException re) {
            LogService.log(LogService.INFO, "CAR directory property 'org.jasig.portal.car.CarResources.directory' not specified. Defaulting to well-known directory '/WEB-INF/cars'.");
            return null;
        }
        if (!carDir.exists()) {
            LogService.log(LogService.ERROR, "CAR directory '" + carDirPath + "' specified by property '" + CAR_DIR_PROP_NAME + "' does not exist. " + "Channel Archives can not be " + "loaded from this directory.");
            return null;
        }
        this.carDirExists = true;
        this.carDirPath = carDirPath;
        return carDir;
    }

    private void loadCars() {
        File carDir = this.getPropertySpecifiedDir();
        if (carDir == null) {
            carDir = this.getWellKnownDir();
        }
        if (carDir != null) {
            this.scanDir(carDir);
            LogService.log(LogService.INFO, "Channel Archives Loaded: " + this.carsByPath.size() + " from '" + this.carDirPath + "'");
        }
    }

    private void scanDir(File dir) {
        File[] dirs;
        File[] cars = dir.listFiles(this.carFilter);
        if (cars != null && cars.length != 0) {
            for (int i = 0; i < cars.length; ++i) {
                this.loadCarEntries(cars[i]);
            }
        }
        if ((dirs = dir.listFiles(this.dirFilter)) != null && dirs.length != 0) {
            for (int i = 0; i < dirs.length; ++i) {
                this.scanDir(dirs[i]);
            }
        }
    }

    private void loadCarEntries(File car) {
        JarFile jar = null;
        try {
            jar = new JarFile(car);
        }
        catch (IOException ioe) {
            LogService.log(LogService.ERROR, "CAR " + this.getCarPath(car) + " could not be loaded. Details: " + (ioe.getMessage() != null ? ioe.getMessage() : ioe.getClass().getName()));
            return;
        }
        Vector<String> entryList = new Vector<String>();
        this.carsByJars.put(jar, car);
        this.carsByPath.put(this.getCarPath(car), car);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (name.equals(DEPLOYMENT_DESCRIPTOR)) {
                this.jarsWithDescriptors.add(jar);
            } else {
                this.resourceJars.put(name, jar);
            }
            entryList.add(name);
        }
        this.carContents.put(car, entryList);
    }

    public void getWorkers(Properties workers) {
        Enumeration jars = this.jarsWithDescriptors.elements();
        while (jars.hasMoreElements()) {
            JarFile j = (JarFile)jars.nextElement();
            DescriptorHandler handler = new DescriptorHandler(j);
            handler.getWorkers(workers);
        }
    }

    public boolean hasDescriptors() {
        return this.jarsWithDescriptors.size() > 0;
    }

    public void getServices(ContentHandler contentHandler) throws SAXException {
        Enumeration jars = this.jarsWithDescriptors.elements();
        while (jars.hasMoreElements()) {
            JarFile j = (JarFile)jars.nextElement();
            DescriptorHandler handler = new DescriptorHandler(j);
            handler.getServices(contentHandler);
        }
    }

    public InputStream getResourceAsStream(String resource) throws PortalException {
        JarFile jar = (JarFile)this.resourceJars.get(resource);
        if (jar == null) {
            return null;
        }
        ZipEntry entry = jar.getEntry(resource);
        if (entry == null) {
            return null;
        }
        try {
            return jar.getInputStream(entry);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to get input stream for " + resource);
        }
    }

    public long getResourceSize(String resource) {
        JarFile jar = (JarFile)this.resourceJars.get(resource);
        if (jar == null) {
            return -1L;
        }
        ZipEntry entry = jar.getEntry(resource);
        if (entry == null) {
            return -1L;
        }
        return entry.getSize();
    }

    public URL findResource(String entry) {
        if (entry == null) {
            return null;
        }
        JarFile jar = (JarFile)this.resourceJars.get(entry = this.resolveRegExpr(entry));
        if (jar == null) {
            return null;
        }
        File carFile = (File)this.carsByJars.get(jar);
        if (carFile == null) {
            return null;
        }
        String url = "jar:file:" + carFile.getAbsolutePath() + "!/" + entry;
        try {
            return new URL(url);
        }
        catch (MalformedURLException me) {
            return null;
        }
    }

    public String getContainingCarPath(String entry) {
        if (entry == null) {
            return null;
        }
        JarFile jar = (JarFile)this.resourceJars.get(entry);
        if (jar == null) {
            return null;
        }
        File carFile = (File)this.carsByJars.get(jar);
        if (carFile == null) {
            return null;
        }
        return this.getCarPath(carFile);
    }

    public boolean containsResource(String resource) {
        return this.resourceJars.containsKey(resource);
    }

    public String[] listCars() {
        Map.Entry[] entries = null;
        entries = this.carsByJars.entrySet().toArray(ENTRY_ARRAY);
        String[] carNames = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            carNames[i] = this.getCarPath((File)entries[i].getValue());
        }
        return carNames;
    }

    public String[] listCarResources(String carPath) {
        File car = (File)this.carsByPath.get(carPath);
        if (car == null) {
            return null;
        }
        Vector contents = (Vector)this.carContents.get(car);
        if (contents == null) {
            return null;
        }
        return contents.toArray(STRING_ARRAY);
    }

    private String getCarPath(File car) {
        String carPath = car.getAbsolutePath();
        return carPath.substring(this.carDirPath.length() + 1);
    }

    public String[] listAllResources() {
        return this.resourceJars.keySet().toArray(STRING_ARRAY);
    }

    private String replace(String entry, String regExpr, String replacement) {
        String copy = entry;
        int beginIdx = 0;
        int endIdx = copy.indexOf(regExpr);
        StringBuffer buff = new StringBuffer();
        while (endIdx != -1) {
            String newStr = copy.substring(beginIdx, endIdx);
            copy = copy.substring(endIdx + 3, copy.length());
            buff.append(newStr).append(replacement);
            endIdx = copy.indexOf(regExpr);
            if (endIdx != -1) continue;
            buff.append(copy);
        }
        if (buff.toString().length() > 0) {
            entry = buff.toString();
        }
        LogService.log(LogService.DEBUG, "CarResources replace() - returned entry is: " + entry);
        return entry;
    }

    private String resolveRegExpr(String entry) {
        String replacement = "~";
        if ((entry = this.replace(entry, "../", replacement)).indexOf(replacement) != -1) {
            String delim = "/";
            StringBuffer sb = new StringBuffer();
            LogService.log(LogService.DEBUG, "CarResources resolveRegExpr() -  Parsing resource name: " + entry);
            StringTokenizer st = new StringTokenizer(entry, replacement);
            int tokens = st.countTokens();
            int count = 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                LogService.log(LogService.DEBUG, "CarResources resolveRegExpr() - Token is now: " + token);
                StringTokenizer st1 = new StringTokenizer(token, delim);
                int childTokens = st1.countTokens();
                int childCount = 1;
                while (st1.hasMoreTokens()) {
                    String childToken = st1.nextToken();
                    LogService.log(LogService.DEBUG, "CarResources resolveRegExpr() - Child token is: " + childToken);
                    if (childCount < childTokens) {
                        sb.append(childToken);
                        sb.append(delim);
                    } else {
                        if (count != tokens) break;
                        sb.append(childToken);
                    }
                    ++childCount;
                }
                ++count;
            }
            entry = sb.toString();
        }
        LogService.log(LogService.DEBUG, "CarResources resolveRegExpr() - resolved entry is: " + entry);
        return entry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

