/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.UserPreferences;

import java.io.File;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channels.UserPreferences.BaseState;
import org.jasig.portal.channels.UserPreferences.GPreferencesState;
import org.jasig.portal.channels.UserPreferences.ManageProfilesState;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.services.LogService;
import org.xml.sax.ContentHandler;

public class CUserPreferences
implements IPrivilegedChannel {
    IUserPreferencesManager upm;
    ChannelRuntimeData runtimeData = new ChannelRuntimeData();
    ChannelStaticData staticData = null;
    StylesheetSet set = new StylesheetSet(this.getClass().getResource("/org/jasig/portal/channels/CUserPreferences/CUserPreferences.ssl").toString());
    private static final String fs = File.separator;
    private static final String sslLocation = "/org/jasig/portal/channels/CUserPreferences/CUserPreferences.ssl";
    private UserPreferences up = null;
    private int mode;
    public static final int MANAGE_PREFERENCES = 1;
    public static final int MANAGE_PROFILES = 2;
    IPrivilegedChannel internalState = null;
    IPrivilegedChannel managePreferences = null;
    IPrivilegedChannel manageProfiles = null;
    protected IUserLayoutStore ulsdb;
    private PortalControlStructures pcs;
    private boolean initialized = false;
    UserProfile editedProfile = null;

    public CUserPreferences() throws PortalException {
        this.set.setMediaProps("/properties/media.properties");
        this.manageProfiles = new ManageProfilesState(this);
        this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    }

    protected IUserPreferencesManager getUserPreferencesManager() {
        return this.upm;
    }

    protected IUserLayoutManager getUserLayoutManager() {
        return this.getUserPreferencesManager().getUserLayoutManager();
    }

    protected UserPreferences getCurrentUserPreferences() {
        return this.up;
    }

    protected ChannelRuntimeData getRuntimeData() {
        return this.runtimeData;
    }

    protected StylesheetSet getStylesheetSet() {
        return this.set;
    }

    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        if (this.upm == null) {
            this.upm = pcs.getUserPreferencesManager();
        }
        if (this.up == null) {
            this.up = this.upm.getUserPreferencesCopy();
        }
        this.pcs = pcs;
        if (!this.initialized) {
            this.instantiateManagePreferencesState(this.up.getProfile());
            this.internalState = this.managePreferences;
            this.internalState.setStaticData(this.staticData);
            this.editedProfile = this.up.getProfile();
            this.initialized = true;
        }
        if (this.internalState != null) {
            this.internalState.setPortalControlStructures(pcs);
        }
    }

    private void instantiateManagePreferencesState(UserProfile profile) {
        try {
            ThemeStylesheetDescription tsd = this.ulsdb.getThemeStylesheetDescription(profile.getThemeStylesheetId());
            if (tsd != null) {
                String cupmClass = tsd.getCustomUserPreferencesManagerClass();
                this.managePreferences = (IPrivilegedChannel)Class.forName(cupmClass).newInstance();
                ((BaseState)this.managePreferences).setContext(this);
            } else {
                LogService.log(LogService.ERROR, "CUserPreferences::instantiateManagePreferencesState() : unable to retrieve theme stylesheet description. stylesheetId=" + profile.getThemeStylesheetId());
                this.managePreferences = new GPreferencesState(this);
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
            this.managePreferences = new GPreferencesState(this);
        }
    }

    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev) {
        if (this.internalState != null) {
            this.internalState.receiveEvent(ev);
        }
    }

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        String action = this.runtimeData.getParameter("userPreferencesAction");
        if (action != null) {
            String profileType;
            Integer profileId = null;
            try {
                profileId = new Integer(this.runtimeData.getParameter("profileId"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            boolean systemProfile = false;
            if (profileId != null && (profileType = this.runtimeData.getParameter("profileType")) != null && profileType.equals("system")) {
                systemProfile = true;
            }
            if (action.equals("manageProfiles")) {
                this.internalState = this.manageProfiles;
            } else if (action.equals("managePreferences")) {
                if (profileId != null) {
                    try {
                        UserProfile newProfile;
                        if (systemProfile) {
                            newProfile = this.ulsdb.getSystemProfileById(profileId);
                            if (!(newProfile == null || this.editedProfile.isSystemProfile() && this.editedProfile.getProfileId() == newProfile.getProfileId())) {
                                this.editedProfile = newProfile;
                                this.instantiateManagePreferencesState(this.editedProfile);
                            }
                        } else {
                            newProfile = this.ulsdb.getUserProfileById(this.upm.getPerson(), profileId);
                            if (newProfile != null && (this.editedProfile.isSystemProfile() || this.editedProfile.getProfileId() != newProfile.getProfileId())) {
                                this.editedProfile = newProfile;
                                this.instantiateManagePreferencesState(this.editedProfile);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new PortalException(e.getMessage(), e);
                    }
                }
                if (this.editedProfile == null) {
                    this.editedProfile = this.up.getProfile();
                }
                this.internalState = this.managePreferences;
            }
        }
        if (this.internalState != null) {
            this.internalState.setRuntimeData(rd);
        }
    }

    public void renderXML(ContentHandler out) throws PortalException {
        this.internalState.renderXML(out);
    }

    private void prepareSaveChanges() throws PortalException {
        this.upm.setNewUserLayoutAndUserPreferences(null, this.up);
    }

    protected UserPreferences getUserPreferencesFromStore(UserProfile profile) throws Exception {
        this.up = this.ulsdb.getUserPreferences(this.getUserPreferencesManager().getPerson(), profile);
        this.up.synchronizeWithUserLayoutXML(UserLayoutStoreFactory.getUserLayoutStoreImpl().getUserLayout(this.getUserPreferencesManager().getPerson(), this.getCurrentUserPreferences().getProfile()));
        return this.up;
    }

    protected UserProfile getEditedUserProfile() {
        return this.editedProfile;
    }
}

