/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPermissionPolicy;
import org.jasig.portal.security.IPermissionSet;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.provider.AuthorizationPrincipalImpl;
import org.jasig.portal.security.provider.PermissionManagerImpl;
import org.jasig.portal.security.provider.PermissionSetImpl;
import org.jasig.portal.security.provider.UpdatingPermissionManagerImpl;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;

public class AuthorizationImpl
implements IAuthorizationService {
    protected IPermissionStore permissionStore;
    protected IPermissionPolicy defaultPermissionPolicy;
    protected Map principalCache = new HashMap(100);
    protected String PERIOD_STRING = ".";
    protected Class PERMISSION_SET_TYPE;
    protected boolean cachePermissions;
    protected static IAuthorizationService singleton;

    private AuthorizationImpl() throws AuthorizationException {
        this.initialize();
    }

    public void addPermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().add(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    public void addPermissions(IPermission[] permissions, IAuthorizationPrincipal principal) throws AuthorizationException {
        if (permissions.length > 0) {
            this.removeFromPermissionsCache(new IAuthorizationPrincipal[]{principal});
            this.getPermissionStore().add(permissions);
        }
    }

    protected void cacheAdd(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.instance().add(ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem adding permissions for " + ps + " to cache: " + ce.getMessage());
        }
    }

    protected IPermissionSet cacheGet(IAuthorizationPrincipal principal) throws AuthorizationException {
        try {
            return (IPermissionSet)EntityCachingService.instance().get(this.PERMISSION_SET_TYPE, principal.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem adding permissions for " + principal + " to cache: " + ce.getMessage());
        }
    }

    protected void cacheRemove(IAuthorizationPrincipal ap) throws AuthorizationException {
        try {
            EntityCachingService.instance().remove(this.PERMISSION_SET_TYPE, ap.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem removing permissions for " + ap + " from cache: " + ce.getMessage());
        }
    }

    protected void cacheUpdate(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.instance().update(ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem updating permissions for " + ps + " in cache: " + ce.getMessage());
        }
    }

    public boolean canPrincipalPublish(IAuthorizationPrincipal principal) throws AuthorizationException {
        return this.doesPrincipalHavePermission(principal, "UP_FRAMEWORK", "PUBLISH", null);
    }

    public boolean canPrincipalRender(IAuthorizationPrincipal principal, int channelPublishId) throws AuthorizationException {
        return this.canPrincipalSubscribe(principal, channelPublishId);
    }

    public boolean canPrincipalSubscribe(IAuthorizationPrincipal principal, int channelPublishId) throws AuthorizationException {
        String owner = "UP_FRAMEWORK";
        String target = "CHAN_ID." + channelPublishId;
        return this.doesPrincipalHavePermission(principal, owner, "SUBSCRIBE", target);
    }

    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.doesPrincipalHavePermission(principal, owner, activity, target, this.getDefaultPermissionPolicy());
    }

    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        return policy.doesPrincipalHavePermission(this, principal, owner, activity, target);
    }

    public IPermission[] getAllPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        IPermission[] perms = this.getPermissionsForPrincipal(principal, owner, activity, target);
        ArrayList<IPermission> al = new ArrayList<IPermission>(Arrays.asList(perms));
        Iterator i = this.getInheritedPrincipals(principal);
        while (i.hasNext()) {
            IAuthorizationPrincipal p = (IAuthorizationPrincipal)i.next();
            perms = this.getPermissionsForPrincipal(p, owner, activity, target);
            al.addAll(Arrays.asList(perms));
        }
        return al.toArray(new IPermission[al.size()]);
    }

    public Vector getAuthorizedChannels(IAuthorizationPrincipal principal) throws AuthorizationException {
        return new Vector();
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String owner, String activity, String target) throws AuthorizationException {
        IPermission[] permissions = this.getPermissionsForOwner(owner, activity, target);
        return this.getPrincipalsFromPermissions(permissions);
    }

    protected IPermissionPolicy getDefaultPermissionPolicy() {
        return this.defaultPermissionPolicy;
    }

    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.getGroupMemberForPrincipal(principal);
    }

    private IGroupMember getGroupMemberForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        LogService.log(LogService.DEBUG, "AuthorizationImpl.getGroupMemberForPrincipal(): for principal " + principal.toString());
        IGroupMember gm = GroupService.getGroupMember(principal.getKey(), principal.getType());
        LogService.log(LogService.DEBUG, "AuthorizationImpl.getGroupMemberForPrincipal(): got group member " + gm);
        return gm;
    }

    private Iterator getGroupsForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = this.getGroupMemberForPrincipal(principal);
        return gm.getAllContainingGroups();
    }

    private Iterator getInheritedPrincipals(IAuthorizationPrincipal principal) throws AuthorizationException {
        Iterator i = null;
        ArrayList<IAuthorizationPrincipal> al = new ArrayList<IAuthorizationPrincipal>(5);
        try {
            i = this.getGroupsForPrincipal(principal);
        }
        catch (GroupsException ge) {
            throw new AuthorizationException("Could not retrieve Groups for " + principal, (Exception)ge);
        }
        while (i.hasNext()) {
            IEntityGroup group = (IEntityGroup)i.next();
            IAuthorizationPrincipal p = this.getPrincipalForGroup(group);
            al.add(p);
        }
        return al.iterator();
    }

    public IPermission[] getPermissionsForOwner(String owner, String activity, String target) throws AuthorizationException {
        return this.primRetrievePermissions(owner, null, activity, target);
    }

    public IPermission[] getPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.primGetPermissionsForPrincipal(principal, owner, activity, target);
    }

    private IPermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public IAuthorizationPrincipal getPrincipal(IPermission permission) throws AuthorizationException {
        String principalString = permission.getPrincipal();
        int idx = principalString.indexOf(this.PERIOD_STRING);
        Integer typeId = new Integer(principalString.substring(0, idx));
        Class type = EntityTypes.getEntityType(typeId);
        String key = principalString.substring(idx + 1);
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal getPrincipalForGroup(IEntityGroup group) {
        String key = group.getKey();
        Class type = EntityTypes.GROUP_ENTITY_TYPE;
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal[] getPrincipalsFromPermissions(IPermission[] permissions) throws AuthorizationException {
        HashSet<IAuthorizationPrincipal> principals = new HashSet<IAuthorizationPrincipal>();
        for (int i = 0; i < permissions.length; ++i) {
            IAuthorizationPrincipal principal = this.getPrincipal(permissions[i]);
            principals.add(principal);
        }
        return principals.toArray(new IAuthorizationPrincipal[principals.size()]);
    }

    public String getPrincipalString(IAuthorizationPrincipal principal) {
        return this.getPrincipalString(principal.getType(), principal.getKey());
    }

    private String getPrincipalString(Class pType, String pKey) {
        Integer type = EntityTypes.getEntityTypeID(pType);
        return type + this.PERIOD_STRING + pKey;
    }

    public IPermission[] getUncachedPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        String pString = this.getPrincipalString(principal);
        return this.primRetrievePermissions(owner, pString, activity, target);
    }

    private void initialize() throws AuthorizationException {
        String eMsg = null;
        String factoryName = PropertiesManager.getProperty("org.jasig.portal.security.IPermissionStore.implementation");
        String policyName = PropertiesManager.getProperty("org.jasig.portal.security.IPermissionPolicy.defaultImplementation");
        this.cachePermissions = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.security.IAuthorizationService.cachePermissions");
        if (factoryName == null) {
            eMsg = "AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionStore.implementation portal.properties.";
            LogService.log(LogService.ERROR, eMsg);
            throw new AuthorizationException(eMsg);
        }
        if (policyName == null) {
            eMsg = "AuthorizationImpl.initialize(): No entry for org.jasig.portal.security.IPermissionPolicy.defaultImplementation portal.properties.";
            LogService.log(LogService.ERROR, eMsg);
            throw new AuthorizationException(eMsg);
        }
        try {
            this.permissionStore = (IPermissionStore)Class.forName(factoryName).newInstance();
        }
        catch (Exception e) {
            eMsg = "AuthorizationImpl.initialize(): Problem creating permission store... " + e.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new AuthorizationException(eMsg);
        }
        try {
            this.defaultPermissionPolicy = (IPermissionPolicy)Class.forName(policyName).newInstance();
        }
        catch (Exception e) {
            eMsg = "AuthorizationImpl.initialize(): Problem creating default permission policy... " + e.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new AuthorizationException(eMsg);
        }
        try {
            this.PERMISSION_SET_TYPE = Class.forName("org.jasig.portal.security.IPermissionSet");
        }
        catch (ClassNotFoundException cnfe) {
            eMsg = "AuthorizationImpl.initialize(): Problem initializing service. " + cnfe.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new AuthorizationException(eMsg);
        }
    }

    public IPermission newPermission(String owner) {
        return this.newPermission(owner, null);
    }

    public IPermission newPermission(String owner, IAuthorizationPrincipal principal) {
        IPermission p = this.getPermissionStore().newInstance(owner);
        if (principal != null) {
            String pString = this.getPrincipalString(principal);
            p.setPrincipal(pString);
        }
        return p;
    }

    public IPermissionManager newPermissionManager(String owner) {
        return new PermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuthorizationPrincipal newPrincipal(String key, Class type) {
        String principalKey = this.getPrincipalString(type, key);
        IAuthorizationPrincipal principal = (IAuthorizationPrincipal)this.getPrincipalCache().get(principalKey);
        if (principal == null) {
            AuthorizationImpl authorizationImpl = this;
            synchronized (authorizationImpl) {
                principal = (IAuthorizationPrincipal)this.getPrincipalCache().get(key);
                if (principal == null) {
                    principal = this.primNewPrincipal(key, type);
                    Map cache = this.copyPrincipalCache();
                    cache.put(principalKey, principal);
                    this.setPrincipalCache(cache);
                }
            }
        }
        return principal;
    }

    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        String key = groupMember.getKey();
        Class type = groupMember.getType();
        LogService.log(LogService.DEBUG, "AuthorizationImpl.newPrincipal(): for " + type + "(" + key + ")");
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal primNewPrincipal(String key, Class type) {
        return new AuthorizationPrincipalImpl(key, type, this);
    }

    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) {
        return new UpdatingPermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal) throws AuthorizationException {
        if (!this.cachePermissions) {
            return this.getUncachedPermissionsForPrincipal(principal, null, null, null);
        }
        IPermissionSet ps = null;
        ps = this.cacheGet(principal);
        if (ps == null) {
            IAuthorizationPrincipal iAuthorizationPrincipal = principal;
            synchronized (iAuthorizationPrincipal) {
                ps = this.cacheGet(principal);
                if (ps == null) {
                    IPermission[] permissions = this.getUncachedPermissionsForPrincipal(principal, null, null, null);
                    ps = new PermissionSetImpl(permissions, principal);
                    this.cacheAdd(ps);
                }
            }
        }
        return ps.getPermissions();
    }

    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        LogService.log(LogService.DEBUG, "AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: " + principal + " owner: " + owner + " activity: " + activity + " target: " + target);
        IPermission[] perms = this.primGetPermissionsForPrincipal(principal);
        if (owner == null && activity == null && target == null) {
            return perms;
        }
        ArrayList<IPermission> al = new ArrayList<IPermission>(perms.length);
        for (int i = 0; i < perms.length; ++i) {
            if (owner != null && !owner.equals(perms[i].getOwner()) || activity != null && !activity.equals(perms[i].getActivity()) || target != null && !target.equals(perms[i].getTarget())) continue;
            al.add(perms[i]);
        }
        LogService.log(LogService.DEBUG, "AuthorizationImpl.primGetPermissionsForPrincipal(): # permissions retrieved: " + al.size());
        return al.toArray(new IPermission[al.size()]);
    }

    private IPermission[] primRetrievePermissions(String owner, String principal, String activity, String target) throws AuthorizationException {
        return this.getPermissionStore().select(owner, principal, activity, target, null);
    }

    private void removeFromPermissionsCache(IAuthorizationPrincipal[] principals) throws AuthorizationException {
        for (int i = 0; i < principals.length; ++i) {
            this.cacheRemove(principals[i]);
        }
    }

    private void removeFromPermissionsCache(IPermission[] permissions) throws AuthorizationException {
        IAuthorizationPrincipal[] principals = this.getPrincipalsFromPermissions(permissions);
        this.removeFromPermissionsCache(principals);
    }

    public void removePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().delete(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    public void removePermissions(IPermission[] permissions, IAuthorizationPrincipal principal) throws AuthorizationException {
        if (permissions.length > 0) {
            this.removeFromPermissionsCache(new IAuthorizationPrincipal[]{principal});
            this.getPermissionStore().delete(permissions);
        }
    }

    protected void setDefaultPermissionPolicy(IPermissionPolicy newDefaultPermissionPolicy) {
        this.defaultPermissionPolicy = newDefaultPermissionPolicy;
    }

    private void setPermissionStore(IPermissionStore newPermissionStore) {
        this.permissionStore = newPermissionStore;
    }

    public static synchronized IAuthorizationService singleton() throws AuthorizationException {
        if (singleton == null) {
            singleton = new AuthorizationImpl();
        }
        return singleton;
    }

    public void updatePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().update(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    public void updatePermissions(IPermission[] permissions, IAuthorizationPrincipal principal) throws AuthorizationException {
        if (permissions.length > 0) {
            this.removeFromPermissionsCache(new IAuthorizationPrincipal[]{principal});
            this.getPermissionStore().update(permissions);
        }
    }

    private synchronized Map getPrincipalCache() {
        return this.principalCache;
    }

    private synchronized void setPrincipalCache(Map map) {
        this.principalCache = map;
    }

    private Map copyPrincipalCache() {
        HashMap hm = (HashMap)this.getPrincipalCache();
        return (Map)hm.clone();
    }
}

