/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.security.provider.NotSoOpaqueCredentials;
import org.jasig.portal.security.provider.SimpleLdapSecurityContext;

public class CacheLdapSecurityContext
extends SimpleLdapSecurityContext {
    private final int CACHELDAPSECURITYAUTHTYPE = 65286;
    private byte[] cachedCredentials;

    CacheLdapSecurityContext() {
    }

    public int getAuthType() {
        return this.CACHELDAPSECURITYAUTHTYPE;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        this.cachedCredentials = new byte[this.myOpaqueCredentials.credentialstring.length];
        System.arraycopy(this.myOpaqueCredentials.credentialstring, 0, this.cachedCredentials, 0, this.myOpaqueCredentials.credentialstring.length);
        super.authenticate();
        if (!this.isAuthenticated()) {
            this.cachedCredentials = null;
        }
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.isauth) {
            CacheOpaqueCredentials oc = new CacheOpaqueCredentials();
            oc.setCredentials(this.cachedCredentials);
            return oc;
        }
        return null;
    }

    private class CacheOpaqueCredentials
    extends ChainingSecurityContext.ChainingOpaqueCredentials
    implements NotSoOpaqueCredentials {
        private CacheOpaqueCredentials() {
            super(CacheLdapSecurityContext.this);
        }

        public String getCredentials() {
            if (this.credentialstring != null) {
                return new String(this.credentialstring);
            }
            return null;
        }
    }
}

