/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ChannelServlet
extends HttpServlet {
    public static String detachBaseStart = "detach_";
    private static int sizeLimit = 3000000;
    StylesheetSet set;
    MediaManager mediaM;
    private boolean initialized = false;
    private IChannel channel;
    private String channelName;
    private boolean hasEdit = false;
    private boolean hasAbout = false;
    private boolean hasHelp = false;
    private long timeOut = 10000L;
    private static final String fs = File.separator;
    private static final String relativeSSLLocation = "ChannelServlet/ChannelServlet.ssl";

    public void init() throws ServletException {
        ServletConfig sc = this.getServletConfig();
        if (sc != null) {
            try {
                this.set = new StylesheetSet(ResourceLoader.getResourceAsURLString(((Object)((Object)this)).getClass(), relativeSSLLocation));
                String mediaPropsUrl = ResourceLoader.getResourceAsURLString(((Object)((Object)this)).getClass(), "/properties/media.properties");
                String mimePropsUrl = ResourceLoader.getResourceAsURLString(((Object)((Object)this)).getClass(), "/properties/mime.properties");
                String serializerPropsUrl = ResourceLoader.getResourceAsURLString(((Object)((Object)this)).getClass(), "/properties/serializer.properties");
                this.set.setMediaProps(mediaPropsUrl);
                this.mediaM = new MediaManager(mediaPropsUrl, mimePropsUrl, serializerPropsUrl);
            }
            catch (PortalException pe) {
                throw new ServletException((Throwable)pe);
            }
            String className = sc.getInitParameter("className");
            this.channelName = sc.getInitParameter("channelName");
            this.hasEdit = Boolean.getBoolean(sc.getInitParameter("hasEdit"));
            this.hasHelp = Boolean.getBoolean(sc.getInitParameter("hasHelp"));
            this.hasAbout = Boolean.getBoolean(sc.getInitParameter("hasAbout"));
            String s_timeOut = sc.getInitParameter("timeOut");
            if (s_timeOut != null) {
                this.timeOut = Long.parseLong(s_timeOut);
            }
            try {
                this.channel = (IChannel)Class.forName(className).newInstance();
                ChannelStaticData sd = new ChannelStaticData();
                sd.setChannelSubscribeId("singlet");
                sd.setTimeout(this.timeOut);
                IPerson person = PersonFactory.createGuestPerson();
                sd.setPerson(person);
                this.channel.setStaticData(sd);
                this.initialized = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block21: {
            if (this.initialized) {
                ChannelRuntimeData rd = new ChannelRuntimeData();
                Enumeration en = req.getParameterNames();
                while (en.hasMoreElements()) {
                    String pName = (String)en.nextElement();
                    if (pName.startsWith("uP_")) continue;
                    String[] val = req.getParameterValues(pName);
                    rd.put(pName, val);
                }
                try {
                    rd.setUPFile(new UPFileSpec(null, 0, "servletRoot", "singlet", null));
                }
                catch (PortalException pe) {
                    System.out.println("unable to construct a UPFile !");
                }
                if (this.channel instanceof IPrivilegedChannel) {
                    PortalControlStructures pcs = new PortalControlStructures();
                    pcs.setHttpServletRequest(req);
                    pcs.setHttpServletResponse(res);
                    try {
                        ((IPrivilegedChannel)this.channel).setPortalControlStructures(pcs);
                    }
                    catch (Exception e) {
                        System.out.println("channel failed to accept portal control structures.");
                    }
                }
                SAX2BufferImpl buffer = new SAX2BufferImpl();
                Worker worker = new Worker(this.channel, rd, buffer);
                Thread workerThread = new Thread(worker);
                workerThread.start();
                long startTime = System.currentTimeMillis();
                res.setContentType(this.mediaM.getReturnMimeType(req));
                BaseMarkupSerializer ser = this.mediaM.getSerializer(this.mediaM.getMedia(req), (Writer)res.getWriter());
                ser.asContentHandler();
                String xslURI = null;
                try {
                    xslURI = this.set.getStylesheetURI(req);
                }
                catch (PortalException pe) {
                    throw new ServletException((Throwable)pe);
                }
                try {
                    TransformerHandler th = XSLT.getTransformerHandler(xslURI);
                    th.setResult(new SAXResult(ser));
                    try {
                        long wait = this.timeOut - System.currentTimeMillis() + startTime;
                        if (wait > 0L) {
                            workerThread.join(wait);
                        }
                    }
                    catch (InterruptedException e) {
                        System.out.println("thread waiting on the worker has been interrupted.");
                    }
                    workerThread.stop();
                    if (worker.done()) {
                        if (worker.successful()) {
                            try {
                                AttributesImpl atl = new AttributesImpl();
                                atl.addAttribute("", "name", "name", "CDATA", this.channelName);
                                th.startDocument();
                                th.startElement("", "channel", "channel", atl);
                                ChannelSAXStreamFilter custodian = new ChannelSAXStreamFilter(th);
                                custodian.setParent(buffer);
                                buffer.stopBuffering();
                                buffer.outputBuffer();
                                th.endElement("", "channel", "channel");
                                th.endDocument();
                            }
                            catch (SAXException e) {
                                System.out.println("error during unbuffering");
                                e.printStackTrace();
                            }
                        } else {
                            Exception e = worker.getException();
                            if (e != null) {
                                StringWriter sw = new StringWriter();
                                e.printStackTrace(new PrintWriter(sw));
                                sw.flush();
                                this.showErrorMessage("channel generated exception " + e.toString() + ". Stack trace: " + sw.toString(), res);
                            }
                        }
                        break block21;
                    }
                    this.showErrorMessage("channel rendering timed out", res);
                }
                catch (Exception e) {
                    this.showErrorMessage("Exception occurred during the framing transformation or XSLT processor initialization", res);
                }
            } else {
                this.showErrorMessage("failed to initialize", res);
            }
        }
    }

    private void showErrorMessage(String message, HttpServletResponse res) {
        res.setContentType("text/html");
        try {
            PrintWriter out = res.getWriter();
            out.println("<html>");
            out.println("<body>");
            if (this.channelName != null) {
                out.println("<h1>" + this.channelName + "</h1>");
            } else {
                out.println("<h1>" + this.getServletConfig().getServletName() + "</h1>");
            }
            out.println("<h3>Error !</h3>");
            out.println("<p>" + message + "<p>");
            out.println("</body></html>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPerson getPerson(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        IPerson person = (IPerson)session.getAttribute("up_person");
        return person;
    }

    protected class Worker
    implements Runnable {
        private boolean successful;
        private boolean done;
        private IChannel channel;
        private ChannelRuntimeData rd;
        private ContentHandler contentHandler;
        private Exception exc = null;

        public Worker(IChannel ch, ChannelRuntimeData runtimeData, ContentHandler dh) {
            this.channel = ch;
            this.contentHandler = dh;
            this.rd = runtimeData;
        }

        public void run() {
            this.successful = false;
            this.done = false;
            try {
                if (this.rd != null) {
                    this.channel.setRuntimeData(this.rd);
                }
                this.channel.renderXML(this.contentHandler);
                this.successful = true;
            }
            catch (Exception e) {
                this.exc = e;
            }
            this.done = true;
        }

        public boolean successful() {
            return this.successful;
        }

        public boolean done() {
            return this.done;
        }

        public Exception getException() {
            return this.exc;
        }
    }
}

