/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class CommonUtils {
    public static String nvl(String sourceStr, String replaceStr) {
        return sourceStr != null ? sourceStr : replaceStr;
    }

    public static String nvl(String sourceStr, String replaceStr, String prefix) {
        String nvlStr = CommonUtils.nvl(sourceStr, replaceStr);
        if (!nvlStr.trim().equals("")) {
            return new String(prefix + nvlStr);
        }
        return nvlStr;
    }

    public static String nvl(String sourceStr) {
        return CommonUtils.nvl(sourceStr, "");
    }

    public static String replaceText(String text, String replacedString, String newString) {
        int lastIndex = -newString.length();
        int replacedStringLength = replacedString.length();
        int newStringLength = newString.length();
        while ((lastIndex = text.indexOf(replacedString, lastIndex + newStringLength)) != -1) {
            text = text.substring(0, lastIndex) + newString + text.substring(lastIndex + replacedStringLength);
        }
        return text;
    }

    public static void replaceSubstVariables(Hashtable original, Hashtable subst) {
        Enumeration original_keys = original.keys();
        while (original_keys.hasMoreElements()) {
            String original_key = (String)original_keys.nextElement();
            String original_value = (String)original.get(original_key);
            Enumeration subst_keys = subst.keys();
            while (subst_keys.hasMoreElements()) {
                String subst_key = (String)subst_keys.nextElement();
                String subst_value = (String)subst.get(subst_key);
                original_value = CommonUtils.replaceText(original_value, subst_key, subst_value);
            }
            original.put(original_key, original_value);
        }
    }

    public static String stackTraceToString(Exception e) {
        StringWriter strwrt = new StringWriter();
        e.printStackTrace(new PrintWriter(strwrt));
        return strwrt.toString();
    }

    public static String[] getSplitStringByCommas(String str, String delim) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] strArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            strArray[i] = st.nextToken().trim();
            ++i;
        }
        return strArray;
    }

    public static Properties getSplitStringByCommas(String keys, String values, String delim) {
        if (values == null || keys == null) {
            return null;
        }
        StringTokenizer stValues = new StringTokenizer(values, delim);
        StringTokenizer stKeys = new StringTokenizer(keys, delim);
        Properties props = new Properties();
        while (stValues.hasMoreTokens() && stKeys.hasMoreTokens()) {
            props.put(stKeys.nextToken().trim(), stValues.nextToken().trim());
        }
        return props;
    }

    public static int[] getSplitIntByCommas(String str, String delim, int def) {
        if (str == null) {
            str = "";
        }
        String[] strarr = CommonUtils.getSplitStringByCommas(str, delim);
        int[] intarr = new int[strarr.length];
        for (int i = 0; i < strarr.length; ++i) {
            intarr[i] = CommonUtils.parseInt(strarr[i], def);
        }
        return intarr;
    }

    public static Hashtable getFamilyProps(Properties props, String prefix, String delim, Properties defaultProps) {
        Hashtable<String, Properties> hash = new Hashtable<String, Properties>();
        Enumeration<?> en = props.propertyNames();
        String propName = null;
        String propShort = null;
        String itemName = null;
        String itemPropName = null;
        String itemPropValue = null;
        StringTokenizer st = null;
        Properties itemProps = null;
        while (en.hasMoreElements()) {
            propName = (String)en.nextElement();
            if (!propName.startsWith(prefix)) continue;
            propShort = propName.substring(prefix.length());
            st = new StringTokenizer(propShort, delim);
            itemName = null;
            itemPropName = null;
            itemPropValue = null;
            if (st.hasMoreTokens()) {
                itemName = st.nextToken().trim();
                if (st.hasMoreTokens()) {
                    itemPropName = st.nextToken().trim();
                }
            }
            if (itemName == null || itemPropName == null) continue;
            itemPropValue = props.getProperty(propName, "");
            itemProps = (Properties)hash.get(itemName);
            if (itemProps == null) {
                itemProps = new Properties(defaultProps);
            }
            itemProps.put(itemPropName, itemPropValue);
            hash.put(itemName, itemProps);
        }
        return hash;
    }

    public static String[] getFamilyPropertyArrayString(Hashtable hash, String[] keys, String propName, String[] def) {
        String[] st = new String[keys.length];
        for (int i = 0; i < st.length; ++i) {
            st[i] = CommonUtils.getFamilyPropertyString(hash, keys[i], propName, null);
            if (def == null || st[i] != null || def.length <= i) continue;
            st[i] = def[i];
        }
        return st;
    }

    public static String getFamilyPropertyString(Hashtable hash, String key, String propName, String def) {
        return ((Properties)hash.get(key)).getProperty(propName, def);
    }

    public static String[] getFamilyPropertyArrayString(Hashtable hash, String[] keys, String propName, String def) {
        String[] st = new String[keys.length];
        for (int i = 0; i < st.length; ++i) {
            st[i] = def;
        }
        return CommonUtils.getFamilyPropertyArrayString(hash, keys, propName, st);
    }

    public static String[] getFamilyPropertyArrayString(Hashtable hash, String[] keys, String propName) {
        return CommonUtils.getFamilyPropertyArrayString(hash, keys, propName, (String[])null);
    }

    public static boolean[] getFamilyPropertyArrayBoolean(Hashtable hash, String[] keys, String propName, boolean def) {
        boolean[] st = new boolean[keys.length];
        for (int i = 0; i < st.length; ++i) {
            st[i] = CommonUtils.parseBoolean(((Properties)hash.get(keys[i])).getProperty(propName), def);
        }
        return st;
    }

    public static boolean[] getFamilyPropertyArrayBoolean(Hashtable hash, String[] keys, String propName) {
        return CommonUtils.getFamilyPropertyArrayBoolean(hash, keys, propName, false);
    }

    public static int[] getFamilyPropertyArrayInt(Hashtable hash, String[] keys, String propName) {
        int[] st = new int[keys.length];
        for (int i = 0; i < st.length; ++i) {
            st[i] = CommonUtils.parseInt(((Properties)hash.get(keys[i])).getProperty(propName));
        }
        return st;
    }

    public static boolean parseBoolean(String str, boolean defaultValue) {
        boolean res = defaultValue;
        if ("yes".equalsIgnoreCase(str)) {
            res = true;
        }
        if ("no".equalsIgnoreCase(str)) {
            res = false;
        }
        return res;
    }

    public static String boolToStr(boolean bool) {
        return bool ? "true" : "false";
    }

    public static boolean strToBool(String bool) {
        return "true".equalsIgnoreCase(bool);
    }

    public static boolean parseBoolean(String str) {
        return CommonUtils.parseBoolean(str, false);
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int parseInt(String str) {
        return CommonUtils.parseInt(str, -1);
    }

    public static boolean odd(int i) {
        return i >> 1 << 1 != i;
    }

    public static boolean isArrayEmpty(Object[] objects) {
        if (objects == null) {
            return true;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayEmpty(String[] objects) {
        if (objects == null) {
            return true;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null || "".equals(objects[i])) continue;
            return false;
        }
        return true;
    }
}

