/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.Hashtable;
import java.util.Iterator;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.IPortalDocument;
import org.jasig.portal.utils.XML;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PortalDocumentImpl
implements IPortalDocument {
    private final Hashtable identifiers = new Hashtable(1024);
    public Document document = null;

    PortalDocumentImpl() {
        this.document = DocumentFactory.__getNewDocument();
    }

    PortalDocumentImpl(Document doc) {
        this.document = doc;
    }

    public void putIdentifier(String key, Element element) throws DOMException {
        if (element == null) {
            this.removeElement(key);
            return;
        }
        if (element.getOwnerDocument() != this.document) {
            StringBuffer msg = new StringBuffer();
            msg.append("Trying to cache an element that doesn't belong to ");
            msg.append("this document.");
            throw new DOMException(4, msg.toString());
        }
        this.identifiers.put(key, element);
    }

    public void copyCache(IPortalDocument sourceDoc) {
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.preserveCache(sourceDoc, n);
        }
    }

    private void removeElement(String key) {
        this.identifiers.remove(key);
    }

    private void preserveCache(IPortalDocument sourceDoc, Node node) {
        String key;
        if (node instanceof Element && (key = ((PortalDocumentImpl)sourceDoc).getElementKey((Element)node)) != null) {
            this.putIdentifier(key, (Element)node);
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.preserveCache(sourceDoc, node);
        }
    }

    private String getElementKey(Element element) {
        String key = null;
        Iterator itr = this.identifiers.keySet().iterator();
        while (itr.hasNext()) {
            key = (String)itr.next();
            if (!XML.serializeNode(element).equals(XML.serializeNode(this.getElementById(key)))) continue;
            return key;
        }
        return null;
    }

    public Element getElementById(String key) {
        return (Element)this.identifiers.get(key);
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.document.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        Document newDoc = (Document)this.document.cloneNode(deep);
        PortalDocumentImpl newNode = new PortalDocumentImpl(newDoc);
        if (deep) {
            newNode.copyCache(this);
        }
        return newNode;
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    void checkCache() {
        System.out.println("CHECKING CACHE for: " + this + " (" + this.hashCode() + ")");
        Iterator itr = this.identifiers.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Element element = (Element)this.identifiers.get(key);
            if (element.getOwnerDocument() == this.document) continue;
            System.out.println("ERROR: element does not belong to this document: " + key);
        }
        System.out.println("DONE CHECKING CACHE for: " + this + " (" + this.hashCode() + ")\n");
    }

    void checkCaches(PortalDocumentImpl doc2) {
        System.out.println("CHECKING CACHES for: " + this + " (" + this.hashCode() + ") and " + doc2 + "( " + doc2.hashCode() + ")");
        this.checkCache();
        doc2.checkCache();
        Iterator itr = this.identifiers.keySet().iterator();
        while (itr.hasNext()) {
            String xml2;
            String key = (String)itr.next();
            Element element1 = (Element)this.identifiers.get(key);
            Element element2 = (Element)doc2.identifiers.get(key);
            if (element2 == null) {
                System.out.println("ERROR: Mapping does not exist in doc2 for key: " + key);
                continue;
            }
            String xml1 = XML.serializeNode(element1);
            if (!xml1.equals(xml2 = XML.serializeNode(element2))) {
                System.out.println("ERROR: xml differs for key: " + key);
                System.out.println("xml1...\n" + xml1);
                System.out.println("xml2...\n" + xml2);
                continue;
            }
            System.out.println("ok key: " + key);
        }
        System.out.println("DONE CHECKING CACHES for: " + this + " (" + this.hashCode() + ") and " + doc2 + "( " + doc2.hashCode() + ")");
    }

    void dumpCache() {
        System.out.println("Element Map size: " + this.identifiers.size());
        Iterator itr = this.identifiers.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Node node = (Node)this.identifiers.get(key);
            System.out.println("key/node: " + key + "/" + node + " (" + node.hashCode() + ")");
        }
    }
}

